<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLdapSystemReq StructType
 * @subpackage Structs
 */
class UpdateLdapSystemReq extends AbstractStructBase
{
    /**
     * The syncEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $syncEnabled;
    /**
     * The ldapServer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ldapServer;
    /**
     * The userIdAttribute
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userIdAttribute;
    /**
     * Constructor method for UpdateLdapSystemReq
     * @uses UpdateLdapSystemReq::setSyncEnabled()
     * @uses UpdateLdapSystemReq::setLdapServer()
     * @uses UpdateLdapSystemReq::setUserIdAttribute()
     * @param string $syncEnabled
     * @param string $ldapServer
     * @param string $userIdAttribute
     */
    public function __construct($syncEnabled = null, $ldapServer = null, $userIdAttribute = null)
    {
        $this
            ->setSyncEnabled($syncEnabled)
            ->setLdapServer($ldapServer)
            ->setUserIdAttribute($userIdAttribute);
    }
    /**
     * Get syncEnabled value
     * @return string|null
     */
    public function getSyncEnabled()
    {
        return $this->syncEnabled;
    }
    /**
     * Set syncEnabled value
     * @param string $syncEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapSystemReq
     */
    public function setSyncEnabled($syncEnabled = null)
    {
        $this->syncEnabled = $syncEnabled;
        return $this;
    }
    /**
     * Get ldapServer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLdapServer()
    {
        return isset($this->ldapServer) ? $this->ldapServer : null;
    }
    /**
     * Set ldapServer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ldapServer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapSystemReq
     */
    public function setLdapServer($ldapServer = null)
    {
        if (is_null($ldapServer) || (is_array($ldapServer) && empty($ldapServer))) {
            unset($this->ldapServer);
        } else {
            $this->ldapServer = $ldapServer;
        }
        return $this;
    }
    /**
     * Get userIdAttribute value
     * @return string|null
     */
    public function getUserIdAttribute()
    {
        return $this->userIdAttribute;
    }
    /**
     * Set userIdAttribute value
     * @param string $userIdAttribute
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapSystemReq
     */
    public function setUserIdAttribute($userIdAttribute = null)
    {
        $this->userIdAttribute = $userIdAttribute;
        return $this;
    }
}
