<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLdapDirectoryReq StructType
 * @subpackage Structs
 */
class UpdateLdapDirectoryReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The ldapDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapDn;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userSearchBase;
    /**
     * The repeatable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The intervalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $intervalValue;
    /**
     * The scheduleUnit
     * Meta information extracted from the WSDL
     * - default: DAY
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scheduleUnit;
    /**
     * The nextExecTime
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nextExecTime;
    /**
     * The servers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Servers
     */
    public $servers;
    /**
     * The ldapFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ldapFilter;
    /**
     * The removeAccessControlGroupInfo
     * Meta information extracted from the WSDL
     * - choice: removeAccessControlGroupInfo | addAccessControlGroupInfo | accessControlGroupInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAccessControlGroupInfo
     */
    public $removeAccessControlGroupInfo;
    /**
     * The addAccessControlGroupInfo
     * Meta information extracted from the WSDL
     * - choice: removeAccessControlGroupInfo | addAccessControlGroupInfo | accessControlGroupInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddAccessControlGroupInfo
     */
    public $addAccessControlGroupInfo;
    /**
     * The accessControlGroupInfo
     * Meta information extracted from the WSDL
     * - choice: removeAccessControlGroupInfo | addAccessControlGroupInfo | accessControlGroupInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo
     */
    public $accessControlGroupInfo;
    /**
     * The featureGroupTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $featureGroupTemplate;
    /**
     * The applyMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyMask;
    /**
     * The mask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mask;
    /**
     * The applyPoolList
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyPoolList;
    /**
     * The addDns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddDns
     */
    public $addDns;
    /**
     * Constructor method for UpdateLdapDirectoryReq
     * @uses UpdateLdapDirectoryReq::setNewName()
     * @uses UpdateLdapDirectoryReq::setLdapDn()
     * @uses UpdateLdapDirectoryReq::setLdapPassword()
     * @uses UpdateLdapDirectoryReq::setUserSearchBase()
     * @uses UpdateLdapDirectoryReq::setRepeatable()
     * @uses UpdateLdapDirectoryReq::setIntervalValue()
     * @uses UpdateLdapDirectoryReq::setScheduleUnit()
     * @uses UpdateLdapDirectoryReq::setNextExecTime()
     * @uses UpdateLdapDirectoryReq::setServers()
     * @uses UpdateLdapDirectoryReq::setLdapFilter()
     * @uses UpdateLdapDirectoryReq::setRemoveAccessControlGroupInfo()
     * @uses UpdateLdapDirectoryReq::setAddAccessControlGroupInfo()
     * @uses UpdateLdapDirectoryReq::setAccessControlGroupInfo()
     * @uses UpdateLdapDirectoryReq::setFeatureGroupTemplate()
     * @uses UpdateLdapDirectoryReq::setApplyMask()
     * @uses UpdateLdapDirectoryReq::setMask()
     * @uses UpdateLdapDirectoryReq::setApplyPoolList()
     * @uses UpdateLdapDirectoryReq::setAddDns()
     * @param string $newName
     * @param string $ldapDn
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param string $repeatable
     * @param string $intervalValue
     * @param string $scheduleUnit
     * @param string $nextExecTime
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAccessControlGroupInfo $removeAccessControlGroupInfo
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddAccessControlGroupInfo $addAccessControlGroupInfo
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate
     * @param string $applyMask
     * @param string $mask
     * @param string $applyPoolList
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns
     */
    public function __construct($newName = null, $ldapDn = null, $ldapPassword = null, $userSearchBase = null, $repeatable = null, $intervalValue = null, $scheduleUnit = 'DAY', $nextExecTime = null, \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter = null, \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAccessControlGroupInfo $removeAccessControlGroupInfo = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddAccessControlGroupInfo $addAccessControlGroupInfo = null, \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate = null, $applyMask = 'false', $mask = null, $applyPoolList = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns = null)
    {
        $this
            ->setNewName($newName)
            ->setLdapDn($ldapDn)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setRepeatable($repeatable)
            ->setIntervalValue($intervalValue)
            ->setScheduleUnit($scheduleUnit)
            ->setNextExecTime($nextExecTime)
            ->setServers($servers)
            ->setLdapFilter($ldapFilter)
            ->setRemoveAccessControlGroupInfo($removeAccessControlGroupInfo)
            ->setAddAccessControlGroupInfo($addAccessControlGroupInfo)
            ->setAccessControlGroupInfo($accessControlGroupInfo)
            ->setFeatureGroupTemplate($featureGroupTemplate)
            ->setApplyMask($applyMask)
            ->setMask($mask)
            ->setApplyPoolList($applyPoolList)
            ->setAddDns($addDns);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string|null
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setLdapDn($ldapDn = null)
    {
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setLdapPassword($ldapPassword = null)
    {
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setRepeatable($repeatable = null)
    {
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get intervalValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntervalValue()
    {
        return isset($this->intervalValue) ? $this->intervalValue : null;
    }
    /**
     * Set intervalValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intervalValue
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setIntervalValue($intervalValue = null)
    {
        if (is_null($intervalValue) || (is_array($intervalValue) && empty($intervalValue))) {
            unset($this->intervalValue);
        } else {
            $this->intervalValue = $intervalValue;
        }
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @param string $scheduleUnit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setScheduleUnit($scheduleUnit = 'DAY')
    {
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string|null
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setNextExecTime($nextExecTime = null)
    {
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get servers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Servers|null
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setServers(\\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get ldapFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLdapFilter()
    {
        return isset($this->ldapFilter) ? $this->ldapFilter : null;
    }
    /**
     * Set ldapFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setLdapFilter(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter = null)
    {
        if (is_null($ldapFilter) || (is_array($ldapFilter) && empty($ldapFilter))) {
            unset($this->ldapFilter);
        } else {
            $this->ldapFilter = $ldapFilter;
        }
        return $this;
    }
    /**
     * Get removeAccessControlGroupInfo value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAccessControlGroupInfo|null
     */
    public function getRemoveAccessControlGroupInfo()
    {
        return isset($this->removeAccessControlGroupInfo) ? $this->removeAccessControlGroupInfo : null;
    }
    /**
     * Set removeAccessControlGroupInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAccessControlGroupInfo $removeAccessControlGroupInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setRemoveAccessControlGroupInfo(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveAccessControlGroupInfo $removeAccessControlGroupInfo = null)
    {
        if (is_null($removeAccessControlGroupInfo) || (is_array($removeAccessControlGroupInfo) && empty($removeAccessControlGroupInfo))) {
            unset($this->removeAccessControlGroupInfo);
        } else {
            $this->removeAccessControlGroupInfo = $removeAccessControlGroupInfo;
        }
        return $this;
    }
    /**
     * Get addAccessControlGroupInfo value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddAccessControlGroupInfo|null
     */
    public function getAddAccessControlGroupInfo()
    {
        return isset($this->addAccessControlGroupInfo) ? $this->addAccessControlGroupInfo : null;
    }
    /**
     * Set addAccessControlGroupInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddAccessControlGroupInfo $addAccessControlGroupInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setAddAccessControlGroupInfo(\\Losc\CucmBundle\Model\Webservice\StructType\AddAccessControlGroupInfo $addAccessControlGroupInfo = null)
    {
        if (is_null($addAccessControlGroupInfo) || (is_array($addAccessControlGroupInfo) && empty($addAccessControlGroupInfo))) {
            unset($this->addAccessControlGroupInfo);
        } else {
            $this->addAccessControlGroupInfo = $addAccessControlGroupInfo;
        }
        return $this;
    }
    /**
     * Get accessControlGroupInfo value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo|null
     */
    public function getAccessControlGroupInfo()
    {
        return isset($this->accessControlGroupInfo) ? $this->accessControlGroupInfo : null;
    }
    /**
     * Set accessControlGroupInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setAccessControlGroupInfo(\\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo = null)
    {
        if (is_null($accessControlGroupInfo) || (is_array($accessControlGroupInfo) && empty($accessControlGroupInfo))) {
            unset($this->accessControlGroupInfo);
        } else {
            $this->accessControlGroupInfo = $accessControlGroupInfo;
        }
        return $this;
    }
    /**
     * Get featureGroupTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFeatureGroupTemplate()
    {
        return isset($this->featureGroupTemplate) ? $this->featureGroupTemplate : null;
    }
    /**
     * Set featureGroupTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setFeatureGroupTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate = null)
    {
        if (is_null($featureGroupTemplate) || (is_array($featureGroupTemplate) && empty($featureGroupTemplate))) {
            unset($this->featureGroupTemplate);
        } else {
            $this->featureGroupTemplate = $featureGroupTemplate;
        }
        return $this;
    }
    /**
     * Get applyMask value
     * @return string|null
     */
    public function getApplyMask()
    {
        return $this->applyMask;
    }
    /**
     * Set applyMask value
     * @param string $applyMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setApplyMask($applyMask = 'false')
    {
        $this->applyMask = $applyMask;
        return $this;
    }
    /**
     * Get mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMask()
    {
        return isset($this->mask) ? $this->mask : null;
    }
    /**
     * Set mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setMask($mask = null)
    {
        if (is_null($mask) || (is_array($mask) && empty($mask))) {
            unset($this->mask);
        } else {
            $this->mask = $mask;
        }
        return $this;
    }
    /**
     * Get applyPoolList value
     * @return string|null
     */
    public function getApplyPoolList()
    {
        return $this->applyPoolList;
    }
    /**
     * Set applyPoolList value
     * @param string $applyPoolList
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setApplyPoolList($applyPoolList = 'false')
    {
        $this->applyPoolList = $applyPoolList;
        return $this;
    }
    /**
     * Get addDns value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddDns|null
     */
    public function getAddDns()
    {
        return $this->addDns;
    }
    /**
     * Set addDns value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq
     */
    public function setAddDns(\\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns = null)
    {
        $this->addDns = $addDns;
        return $this;
    }
}
