<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIvrUserLocaleReq StructType
 * @subpackage Structs
 */
class UpdateIvrUserLocaleReq extends APIRequest
{
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - choice: uuid | userLocale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userLocale;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | userLocale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newUserLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newUserLocale;
    /**
     * The orderIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $orderIndex;
    /**
     * Constructor method for UpdateIvrUserLocaleReq
     * @uses UpdateIvrUserLocaleReq::setUserLocale()
     * @uses UpdateIvrUserLocaleReq::setUuid()
     * @uses UpdateIvrUserLocaleReq::setNewUserLocale()
     * @uses UpdateIvrUserLocaleReq::setOrderIndex()
     * @param string $userLocale
     * @param string $uuid
     * @param string $newUserLocale
     * @param string $orderIndex
     */
    public function __construct($userLocale = null, $uuid = null, $newUserLocale = null, $orderIndex = null)
    {
        $this
            ->setUserLocale($userLocale)
            ->setUuid($uuid)
            ->setNewUserLocale($newUserLocale)
            ->setOrderIndex($orderIndex);
    }
    /**
     * Get userLocale value
     * @return string
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIvrUserLocaleReq
     */
    public function setUserLocale($userLocale = null)
    {
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIvrUserLocaleReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newUserLocale value
     * @return string|null
     */
    public function getNewUserLocale()
    {
        return $this->newUserLocale;
    }
    /**
     * Set newUserLocale value
     * @param string $newUserLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIvrUserLocaleReq
     */
    public function setNewUserLocale($newUserLocale = null)
    {
        $this->newUserLocale = $newUserLocale;
        return $this;
    }
    /**
     * Get orderIndex value
     * @return string|null
     */
    public function getOrderIndex()
    {
        return $this->orderIndex;
    }
    /**
     * Set orderIndex value
     * @param string $orderIndex
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIvrUserLocaleReq
     */
    public function setOrderIndex($orderIndex = null)
    {
        $this->orderIndex = $orderIndex;
        return $this;
    }
}
