<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIpPhoneServicesReq StructType
 * @subpackage Structs
 */
class UpdateIpPhoneServicesReq extends APIRequest
{
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | serviceName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | serviceName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newServiceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newServiceName;
    /**
     * The asciiServiceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asciiServiceName;
    /**
     * The serviceDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceDescription;
    /**
     * The serviceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceUrl;
    /**
     * The secureServiceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secureServiceUrl;
    /**
     * The serviceCategory
     * Meta information extracted from the WSDL
     * - default: XML Service
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceCategory;
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - default: Standard IP Phone Service
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * The serviceVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVendor;
    /**
     * The serviceVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVersion;
    /**
     * The enabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The removeParameters
     * Meta information extracted from the WSDL
     * - choice: removeParameters | addParameters | parameters
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters
     */
    public $removeParameters;
    /**
     * The addParameters
     * Meta information extracted from the WSDL
     * - choice: removeParameters | addParameters | parameters
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddParameters
     */
    public $addParameters;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - choice: removeParameters | addParameters | parameters
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Parameters
     */
    public $parameters;
    /**
     * Constructor method for UpdateIpPhoneServicesReq
     * @uses UpdateIpPhoneServicesReq::setServiceName()
     * @uses UpdateIpPhoneServicesReq::setUuid()
     * @uses UpdateIpPhoneServicesReq::setNewServiceName()
     * @uses UpdateIpPhoneServicesReq::setAsciiServiceName()
     * @uses UpdateIpPhoneServicesReq::setServiceDescription()
     * @uses UpdateIpPhoneServicesReq::setServiceUrl()
     * @uses UpdateIpPhoneServicesReq::setSecureServiceUrl()
     * @uses UpdateIpPhoneServicesReq::setServiceCategory()
     * @uses UpdateIpPhoneServicesReq::setServiceType()
     * @uses UpdateIpPhoneServicesReq::setServiceVendor()
     * @uses UpdateIpPhoneServicesReq::setServiceVersion()
     * @uses UpdateIpPhoneServicesReq::setEnabled()
     * @uses UpdateIpPhoneServicesReq::setRemoveParameters()
     * @uses UpdateIpPhoneServicesReq::setAddParameters()
     * @uses UpdateIpPhoneServicesReq::setParameters()
     * @param string $serviceName
     * @param string $uuid
     * @param string $newServiceName
     * @param string $asciiServiceName
     * @param string $serviceDescription
     * @param string $serviceUrl
     * @param string $secureServiceUrl
     * @param string $serviceCategory
     * @param string $serviceType
     * @param string $serviceVendor
     * @param string $serviceVersion
     * @param string $enabled
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters $removeParameters
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddParameters $addParameters
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters
     */
    public function __construct($serviceName = null, $uuid = null, $newServiceName = null, $asciiServiceName = null, $serviceDescription = null, $serviceUrl = null, $secureServiceUrl = null, $serviceCategory = 'XML Service', $serviceType = 'Standard IP Phone Service', $serviceVendor = null, $serviceVersion = null, $enabled = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters $removeParameters = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddParameters $addParameters = null, \\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setUuid($uuid)
            ->setNewServiceName($newServiceName)
            ->setAsciiServiceName($asciiServiceName)
            ->setServiceDescription($serviceDescription)
            ->setServiceUrl($serviceUrl)
            ->setSecureServiceUrl($secureServiceUrl)
            ->setServiceCategory($serviceCategory)
            ->setServiceType($serviceType)
            ->setServiceVendor($serviceVendor)
            ->setServiceVersion($serviceVersion)
            ->setEnabled($enabled)
            ->setRemoveParameters($removeParameters)
            ->setAddParameters($addParameters)
            ->setParameters($parameters);
    }
    /**
     * Get serviceName value
     * @return string
     */
    public function getServiceName()
    {
        return isset($this->serviceName) ? $this->serviceName : null;
    }
    /**
     * Set serviceName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $serviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceName($serviceName = null)
    {
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->serviceName);
        } else {
            $this->serviceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newServiceName value
     * @return string|null
     */
    public function getNewServiceName()
    {
        return $this->newServiceName;
    }
    /**
     * Set newServiceName value
     * @param string $newServiceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setNewServiceName($newServiceName = null)
    {
        $this->newServiceName = $newServiceName;
        return $this;
    }
    /**
     * Get asciiServiceName value
     * @return string|null
     */
    public function getAsciiServiceName()
    {
        return $this->asciiServiceName;
    }
    /**
     * Set asciiServiceName value
     * @param string $asciiServiceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setAsciiServiceName($asciiServiceName = null)
    {
        $this->asciiServiceName = $asciiServiceName;
        return $this;
    }
    /**
     * Get serviceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceDescription()
    {
        return isset($this->serviceDescription) ? $this->serviceDescription : null;
    }
    /**
     * Set serviceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceDescription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceDescription($serviceDescription = null)
    {
        if (is_null($serviceDescription) || (is_array($serviceDescription) && empty($serviceDescription))) {
            unset($this->serviceDescription);
        } else {
            $this->serviceDescription = $serviceDescription;
        }
        return $this;
    }
    /**
     * Get serviceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceUrl()
    {
        return isset($this->serviceUrl) ? $this->serviceUrl : null;
    }
    /**
     * Set serviceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceUrl($serviceUrl = null)
    {
        if (is_null($serviceUrl) || (is_array($serviceUrl) && empty($serviceUrl))) {
            unset($this->serviceUrl);
        } else {
            $this->serviceUrl = $serviceUrl;
        }
        return $this;
    }
    /**
     * Get secureServiceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecureServiceUrl()
    {
        return isset($this->secureServiceUrl) ? $this->secureServiceUrl : null;
    }
    /**
     * Set secureServiceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secureServiceUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setSecureServiceUrl($secureServiceUrl = null)
    {
        if (is_null($secureServiceUrl) || (is_array($secureServiceUrl) && empty($secureServiceUrl))) {
            unset($this->secureServiceUrl);
        } else {
            $this->secureServiceUrl = $secureServiceUrl;
        }
        return $this;
    }
    /**
     * Get serviceCategory value
     * @return string|null
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @param string $serviceCategory
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceCategory($serviceCategory = 'XML Service')
    {
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceType($serviceType = 'Standard IP Phone Service')
    {
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceVendor value
     * @return string|null
     */
    public function getServiceVendor()
    {
        return $this->serviceVendor;
    }
    /**
     * Set serviceVendor value
     * @param string $serviceVendor
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceVendor($serviceVendor = null)
    {
        $this->serviceVendor = $serviceVendor;
        return $this;
    }
    /**
     * Get serviceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->serviceVersion;
    }
    /**
     * Set serviceVersion value
     * @param string $serviceVersion
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceVersion($serviceVersion = null)
    {
        $this->serviceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setEnabled($enabled = 'true')
    {
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get removeParameters value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters|null
     */
    public function getRemoveParameters()
    {
        return isset($this->removeParameters) ? $this->removeParameters : null;
    }
    /**
     * Set removeParameters value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters $removeParameters
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setRemoveParameters(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters $removeParameters = null)
    {
        if (is_null($removeParameters) || (is_array($removeParameters) && empty($removeParameters))) {
            unset($this->removeParameters);
        } else {
            $this->removeParameters = $removeParameters;
        }
        return $this;
    }
    /**
     * Get addParameters value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddParameters|null
     */
    public function getAddParameters()
    {
        return isset($this->addParameters) ? $this->addParameters : null;
    }
    /**
     * Set addParameters value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddParameters $addParameters
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setAddParameters(\\Losc\CucmBundle\Model\Webservice\StructType\AddParameters $addParameters = null)
    {
        if (is_null($addParameters) || (is_array($addParameters) && empty($addParameters))) {
            unset($this->addParameters);
        } else {
            $this->addParameters = $addParameters;
        }
        return $this;
    }
    /**
     * Get parameters value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Parameters|null
     */
    public function getParameters()
    {
        return isset($this->parameters) ? $this->parameters : null;
    }
    /**
     * Set parameters value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setParameters(\\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters = null)
    {
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->parameters);
        } else {
            $this->parameters = $parameters;
        }
        return $this;
    }
}
