<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeServerReq StructType
 * @subpackage Structs
 */
class UpdateImeServerReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Value shpuld be between 1024 and 65535
     * - default: 5620
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - default: Authenticated
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $applicationUser;
    /**
     * The reconnectInterval
     * Meta information extracted from the WSDL
     * - documentation: Value should be between 60 and 600
     * - default: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $reconnectInterval;
    /**
     * Constructor method for UpdateImeServerReq
     * @uses UpdateImeServerReq::setNewName()
     * @uses UpdateImeServerReq::setDescription()
     * @uses UpdateImeServerReq::setIpAddress()
     * @uses UpdateImeServerReq::setPort()
     * @uses UpdateImeServerReq::setDeviceSecurityMode()
     * @uses UpdateImeServerReq::setApplicationUser()
     * @uses UpdateImeServerReq::setReconnectInterval()
     * @param string $newName
     * @param string $description
     * @param string $ipAddress
     * @param string $port
     * @param string $deviceSecurityMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @param string $reconnectInterval
     */
    public function __construct($newName = null, $description = null, $ipAddress = null, $port = '5620', $deviceSecurityMode = 'Authenticated', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null, $reconnectInterval = '120')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setApplicationUser($applicationUser)
            ->setReconnectInterval($reconnectInterval);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setPort($port = '5620')
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @param string $deviceSecurityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setDeviceSecurityMode($deviceSecurityMode = 'Authenticated')
    {
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get applicationUser value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setApplicationUser(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get reconnectInterval value
     * @return string|null
     */
    public function getReconnectInterval()
    {
        return $this->reconnectInterval;
    }
    /**
     * Set reconnectInterval value
     * @param string $reconnectInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq
     */
    public function setReconnectInterval($reconnectInterval = '120')
    {
        $this->reconnectInterval = $reconnectInterval;
        return $this;
    }
}
