<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateH323GatewayReq StructType
 * @subpackage Structs
 */
class UpdateH323GatewayReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The tunneledProtocol
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The asn1RoseOidEncoding
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only if PRI variant is QSIG
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only PRI variant is QSIG
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qsigVariant;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The pathReplacementSupport
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppDomainId;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - documentation: When this flag is checked, IPSec needs to be configured in the network to provide end to end security. Failure to do so will expose keys and other information
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The waitForFarEndH245TerminalSet
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $waitForFarEndH245TerminalSet;
    /**
     * The mtpRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - default: Originator
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingLineIdPresentation
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The enableInboundFaststart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableInboundFaststart;
    /**
     * The enableOutboundFaststart
     * Meta information extracted from the WSDL
     * - documentation: If set to True,mediaResourceList must be mentioned and mtpRequired must be set to True.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundFaststart;
    /**
     * The codecForOutboundFaststart
     * Meta information extracted from the WSDL
     * - documentation: enableOutboundFaststart must be set to true for it to be read.Not Nillable.
     * - default: G711 u-law 64K
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codecForOutboundFaststart;
    /**
     * The transmitUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The signalingPort
     * Meta information extracted from the WSDL
     * - default: 1720
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $signalingPort;
    /**
     * The allowH235PassThrough
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowH235PassThrough;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The prefixDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prefixDn;
    /**
     * The calledPartyIeNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyIeNumberType;
    /**
     * The callingPartyIeNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyIeNumberType;
    /**
     * The calledNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledNumberingPlan;
    /**
     * The callingNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingNumberingPlan;
    /**
     * The callingPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNationalPrefix;
    /**
     * The callingPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyInternationalPrefix;
    /**
     * The callingPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyUnknownPrefix;
    /**
     * The callingPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySubscriberPrefix;
    /**
     * The callingPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The displayIeDelivery
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIeDelivery;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The useDevicePoolCalledCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssNatl;
    /**
     * The useDevicePoolCalledCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssIntl;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The useDevicePoolCalledCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssSubs;
    /**
     * The useDevicePoolCntdPnTransformationCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCntdPnTransformationCss;
    /**
     * The cntdPnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The redirectingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $redirectingPartyTransformationCSS;
    /**
     * Constructor method for UpdateH323GatewayReq
     * @uses UpdateH323GatewayReq::setNewName()
     * @uses UpdateH323GatewayReq::setDescription()
     * @uses UpdateH323GatewayReq::setCallingSearchSpaceName()
     * @uses UpdateH323GatewayReq::setDevicePoolName()
     * @uses UpdateH323GatewayReq::setCommonDeviceConfigName()
     * @uses UpdateH323GatewayReq::setNetworkLocation()
     * @uses UpdateH323GatewayReq::setLocationName()
     * @uses UpdateH323GatewayReq::setMediaResourceListName()
     * @uses UpdateH323GatewayReq::setAutomatedAlternateRoutingCssName()
     * @uses UpdateH323GatewayReq::setAarNeighborhoodName()
     * @uses UpdateH323GatewayReq::setLoadInformation()
     * @uses UpdateH323GatewayReq::setTunneledProtocol()
     * @uses UpdateH323GatewayReq::setAsn1RoseOidEncoding()
     * @uses UpdateH323GatewayReq::setQsigVariant()
     * @uses UpdateH323GatewayReq::setVendorConfig()
     * @uses UpdateH323GatewayReq::setPathReplacementSupport()
     * @uses UpdateH323GatewayReq::setTraceFlag()
     * @uses UpdateH323GatewayReq::setMlppDomainId()
     * @uses UpdateH323GatewayReq::setUseTrustedRelayPoint()
     * @uses UpdateH323GatewayReq::setRetryVideoCallAsAudio()
     * @uses UpdateH323GatewayReq::setCgpnTransformationCssName()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCgpnTransformCss()
     * @uses UpdateH323GatewayReq::setGeoLocationName()
     * @uses UpdateH323GatewayReq::setGeoLocationFilterName()
     * @uses UpdateH323GatewayReq::setCdpnTransformationCssName()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCdpnTransformCss()
     * @uses UpdateH323GatewayReq::setPacketCaptureMode()
     * @uses UpdateH323GatewayReq::setPacketCaptureDuration()
     * @uses UpdateH323GatewayReq::setSrtpAllowed()
     * @uses UpdateH323GatewayReq::setWaitForFarEndH245TerminalSet()
     * @uses UpdateH323GatewayReq::setMtpRequired()
     * @uses UpdateH323GatewayReq::setCallerIdDn()
     * @uses UpdateH323GatewayReq::setCallingPartySelection()
     * @uses UpdateH323GatewayReq::setCallingLineIdPresentation()
     * @uses UpdateH323GatewayReq::setEnableInboundFaststart()
     * @uses UpdateH323GatewayReq::setEnableOutboundFaststart()
     * @uses UpdateH323GatewayReq::setCodecForOutboundFaststart()
     * @uses UpdateH323GatewayReq::setTransmitUtf8()
     * @uses UpdateH323GatewayReq::setSignalingPort()
     * @uses UpdateH323GatewayReq::setAllowH235PassThrough()
     * @uses UpdateH323GatewayReq::setSigDigits()
     * @uses UpdateH323GatewayReq::setPrefixDn()
     * @uses UpdateH323GatewayReq::setCalledPartyIeNumberType()
     * @uses UpdateH323GatewayReq::setCallingPartyIeNumberType()
     * @uses UpdateH323GatewayReq::setCalledNumberingPlan()
     * @uses UpdateH323GatewayReq::setCallingNumberingPlan()
     * @uses UpdateH323GatewayReq::setCallingPartyNationalPrefix()
     * @uses UpdateH323GatewayReq::setCallingPartyInternationalPrefix()
     * @uses UpdateH323GatewayReq::setCallingPartyUnknownPrefix()
     * @uses UpdateH323GatewayReq::setCallingPartySubscriberPrefix()
     * @uses UpdateH323GatewayReq::setCallingPartyNationalStripDigits()
     * @uses UpdateH323GatewayReq::setCallingPartyInternationalStripDigits()
     * @uses UpdateH323GatewayReq::setCallingPartyUnknownStripDigits()
     * @uses UpdateH323GatewayReq::setCallingPartySubscriberStripDigits()
     * @uses UpdateH323GatewayReq::setCallingPartyNationalTransformationCssName()
     * @uses UpdateH323GatewayReq::setCallingPartyInternationalTransformationCssName()
     * @uses UpdateH323GatewayReq::setCallingPartyUnknownTransformationCssName()
     * @uses UpdateH323GatewayReq::setCallingPartySubscriberTransformationCssName()
     * @uses UpdateH323GatewayReq::setCalledPartyNationalPrefix()
     * @uses UpdateH323GatewayReq::setCalledPartyInternationalPrefix()
     * @uses UpdateH323GatewayReq::setCalledPartyUnknownPrefix()
     * @uses UpdateH323GatewayReq::setCalledPartySubscriberPrefix()
     * @uses UpdateH323GatewayReq::setCalledPartyNationalStripDigits()
     * @uses UpdateH323GatewayReq::setCalledPartyInternationalStripDigits()
     * @uses UpdateH323GatewayReq::setCalledPartyUnknownStripDigits()
     * @uses UpdateH323GatewayReq::setCalledPartySubscriberStripDigits()
     * @uses UpdateH323GatewayReq::setCalledPartyNationalTransformationCssName()
     * @uses UpdateH323GatewayReq::setCalledPartyInternationalTransformationCssName()
     * @uses UpdateH323GatewayReq::setCalledPartyUnknownTransformationCssName()
     * @uses UpdateH323GatewayReq::setCalledPartySubscriberTransformationCssName()
     * @uses UpdateH323GatewayReq::setPstnAccess()
     * @uses UpdateH323GatewayReq::setImeE164TransformationName()
     * @uses UpdateH323GatewayReq::setDisplayIeDelivery()
     * @uses UpdateH323GatewayReq::setRedirectOutboundNumberIe()
     * @uses UpdateH323GatewayReq::setRedirectInboundNumberIe()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCgpnTransformCssNatl()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCgpnTransformCssIntl()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCgpnTransformCssSubs()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCalledCssNatl()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCalledCssIntl()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCalledCssUnkn()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCalledCssSubs()
     * @uses UpdateH323GatewayReq::setUseDevicePoolCntdPnTransformationCss()
     * @uses UpdateH323GatewayReq::setCntdPnTransformationCssName()
     * @uses UpdateH323GatewayReq::setConfidentialAccess()
     * @uses UpdateH323GatewayReq::setRedirectingPartyTransformationCSS()
     * @param string $newName
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param string $tunneledProtocol
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $pathReplacementSupport
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $srtpAllowed
     * @param string $waitForFarEndH245TerminalSet
     * @param string $mtpRequired
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingLineIdPresentation
     * @param string $enableInboundFaststart
     * @param string $enableOutboundFaststart
     * @param string $codecForOutboundFaststart
     * @param string $transmitUtf8
     * @param string $signalingPort
     * @param string $allowH235PassThrough
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $prefixDn
     * @param string $calledPartyIeNumberType
     * @param string $callingPartyIeNumberType
     * @param string $calledNumberingPlan
     * @param string $callingNumberingPlan
     * @param string $callingPartyNationalPrefix
     * @param string $callingPartyInternationalPrefix
     * @param string $callingPartyUnknownPrefix
     * @param string $callingPartySubscriberPrefix
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param string $pstnAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @param string $displayIeDelivery
     * @param string $redirectOutboundNumberIe
     * @param string $redirectInboundNumberIe
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $useDevicePoolCalledCssNatl
     * @param string $useDevicePoolCalledCssIntl
     * @param string $useDevicePoolCalledCssUnkn
     * @param string $useDevicePoolCalledCssSubs
     * @param string $useDevicePoolCntdPnTransformationCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS
     */
    public function __construct($newName = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, $tunneledProtocol = 'None', $asn1RoseOidEncoding = 'No Changes', $qsigVariant = 'No Changes', \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $pathReplacementSupport = 'false', $traceFlag = null, $mlppDomainId = null, $useTrustedRelayPoint = 'Default', $retryVideoCallAsAudio = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = 'true', $packetCaptureMode = 'None', $packetCaptureDuration = '0', $srtpAllowed = 'false', $waitForFarEndH245TerminalSet = null, $mtpRequired = null, $callerIdDn = null, $callingPartySelection = 'Originator', $callingLineIdPresentation = 'Default', $enableInboundFaststart = null, $enableOutboundFaststart = null, $codecForOutboundFaststart = 'G711 u-law 64K', $transmitUtf8 = 'false', $signalingPort = '1720', $allowH235PassThrough = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = '0', $prefixDn = null, $calledPartyIeNumberType = 'Cisco CallManager', $callingPartyIeNumberType = 'Cisco CallManager', $calledNumberingPlan = 'Cisco CallManager', $callingNumberingPlan = 'Cisco CallManager', $callingPartyNationalPrefix = null, $callingPartyInternationalPrefix = null, $callingPartyUnknownPrefix = null, $callingPartySubscriberPrefix = null, $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null, $pstnAccess = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null, $displayIeDelivery = null, $redirectOutboundNumberIe = null, $redirectInboundNumberIe = null, $useDevicePoolCgpnTransformCssNatl = 'true', $useDevicePoolCgpnTransformCssIntl = 'true', $useDevicePoolCgpnTransformCssUnkn = 'true', $useDevicePoolCgpnTransformCssSubs = 'true', $useDevicePoolCalledCssNatl = 'true', $useDevicePoolCalledCssIntl = 'true', $useDevicePoolCalledCssUnkn = 'true', $useDevicePoolCalledCssSubs = 'true', $useDevicePoolCntdPnTransformationCss = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setTunneledProtocol($tunneledProtocol)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setVendorConfig($vendorConfig)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSrtpAllowed($srtpAllowed)
            ->setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet)
            ->setMtpRequired($mtpRequired)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setEnableInboundFaststart($enableInboundFaststart)
            ->setEnableOutboundFaststart($enableOutboundFaststart)
            ->setCodecForOutboundFaststart($codecForOutboundFaststart)
            ->setTransmitUtf8($transmitUtf8)
            ->setSignalingPort($signalingPort)
            ->setAllowH235PassThrough($allowH235PassThrough)
            ->setSigDigits($sigDigits)
            ->setPrefixDn($prefixDn)
            ->setCalledPartyIeNumberType($calledPartyIeNumberType)
            ->setCallingPartyIeNumberType($callingPartyIeNumberType)
            ->setCalledNumberingPlan($calledNumberingPlan)
            ->setCallingNumberingPlan($callingNumberingPlan)
            ->setCallingPartyNationalPrefix($callingPartyNationalPrefix)
            ->setCallingPartyInternationalPrefix($callingPartyInternationalPrefix)
            ->setCallingPartyUnknownPrefix($callingPartyUnknownPrefix)
            ->setCallingPartySubscriberPrefix($callingPartySubscriberPrefix)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setDisplayIeDelivery($displayIeDelivery)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl)
            ->setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs)
            ->setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setConfidentialAccess($confidentialAccess)
            ->setRedirectingPartyTransformationCSS($redirectingPartyTransformationCSS);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string|null
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @param string $tunneledProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setTunneledProtocol($tunneledProtocol = 'None')
    {
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @param string $asn1RoseOidEncoding
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = 'No Changes')
    {
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @param string $qsigVariant
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setQsigVariant($qsigVariant = 'No Changes')
    {
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setPathReplacementSupport($pathReplacementSupport = 'false')
    {
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setTraceFlag($traceFlag = null)
    {
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = 'true')
    {
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = 'true')
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = 'true')
    {
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param string $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packetCaptureDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setSrtpAllowed($srtpAllowed = 'false')
    {
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get waitForFarEndH245TerminalSet value
     * @return string|null
     */
    public function getWaitForFarEndH245TerminalSet()
    {
        return $this->waitForFarEndH245TerminalSet;
    }
    /**
     * Set waitForFarEndH245TerminalSet value
     * @param string $waitForFarEndH245TerminalSet
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet = null)
    {
        $this->waitForFarEndH245TerminalSet = $waitForFarEndH245TerminalSet;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setMtpRequired($mtpRequired = null)
    {
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @param string $callingPartySelection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartySelection($callingPartySelection = 'Originator')
    {
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @param string $callingLineIdPresentation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = 'Default')
    {
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get enableInboundFaststart value
     * @return string|null
     */
    public function getEnableInboundFaststart()
    {
        return $this->enableInboundFaststart;
    }
    /**
     * Set enableInboundFaststart value
     * @param string $enableInboundFaststart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setEnableInboundFaststart($enableInboundFaststart = null)
    {
        $this->enableInboundFaststart = $enableInboundFaststart;
        return $this;
    }
    /**
     * Get enableOutboundFaststart value
     * @return string|null
     */
    public function getEnableOutboundFaststart()
    {
        return $this->enableOutboundFaststart;
    }
    /**
     * Set enableOutboundFaststart value
     * @param string $enableOutboundFaststart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setEnableOutboundFaststart($enableOutboundFaststart = null)
    {
        $this->enableOutboundFaststart = $enableOutboundFaststart;
        return $this;
    }
    /**
     * Get codecForOutboundFaststart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodecForOutboundFaststart()
    {
        return isset($this->codecForOutboundFaststart) ? $this->codecForOutboundFaststart : null;
    }
    /**
     * Set codecForOutboundFaststart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codecForOutboundFaststart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCodecForOutboundFaststart($codecForOutboundFaststart = 'G711 u-law 64K')
    {
        if (is_null($codecForOutboundFaststart) || (is_array($codecForOutboundFaststart) && empty($codecForOutboundFaststart))) {
            unset($this->codecForOutboundFaststart);
        } else {
            $this->codecForOutboundFaststart = $codecForOutboundFaststart;
        }
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setTransmitUtf8($transmitUtf8 = 'false')
    {
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get signalingPort value
     * @return string|null
     */
    public function getSignalingPort()
    {
        return $this->signalingPort;
    }
    /**
     * Set signalingPort value
     * @param string $signalingPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setSignalingPort($signalingPort = '1720')
    {
        $this->signalingPort = $signalingPort;
        return $this;
    }
    /**
     * Get allowH235PassThrough value
     * @return string|null
     */
    public function getAllowH235PassThrough()
    {
        return $this->allowH235PassThrough;
    }
    /**
     * Set allowH235PassThrough value
     * @param string $allowH235PassThrough
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setAllowH235PassThrough($allowH235PassThrough = 'false')
    {
        $this->allowH235PassThrough = $allowH235PassThrough;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setSigDigits(\\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = '0')
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get prefixDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDn()
    {
        return isset($this->prefixDn) ? $this->prefixDn : null;
    }
    /**
     * Set prefixDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setPrefixDn($prefixDn = null)
    {
        if (is_null($prefixDn) || (is_array($prefixDn) && empty($prefixDn))) {
            unset($this->prefixDn);
        } else {
            $this->prefixDn = $prefixDn;
        }
        return $this;
    }
    /**
     * Get calledPartyIeNumberType value
     * @return string|null
     */
    public function getCalledPartyIeNumberType()
    {
        return $this->calledPartyIeNumberType;
    }
    /**
     * Set calledPartyIeNumberType value
     * @param string $calledPartyIeNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyIeNumberType($calledPartyIeNumberType = 'Cisco CallManager')
    {
        $this->calledPartyIeNumberType = $calledPartyIeNumberType;
        return $this;
    }
    /**
     * Get callingPartyIeNumberType value
     * @return string|null
     */
    public function getCallingPartyIeNumberType()
    {
        return $this->callingPartyIeNumberType;
    }
    /**
     * Set callingPartyIeNumberType value
     * @param string $callingPartyIeNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyIeNumberType($callingPartyIeNumberType = 'Cisco CallManager')
    {
        $this->callingPartyIeNumberType = $callingPartyIeNumberType;
        return $this;
    }
    /**
     * Get calledNumberingPlan value
     * @return string|null
     */
    public function getCalledNumberingPlan()
    {
        return $this->calledNumberingPlan;
    }
    /**
     * Set calledNumberingPlan value
     * @param string $calledNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledNumberingPlan($calledNumberingPlan = 'Cisco CallManager')
    {
        $this->calledNumberingPlan = $calledNumberingPlan;
        return $this;
    }
    /**
     * Get callingNumberingPlan value
     * @return string|null
     */
    public function getCallingNumberingPlan()
    {
        return $this->callingNumberingPlan;
    }
    /**
     * Set callingNumberingPlan value
     * @param string $callingNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingNumberingPlan($callingNumberingPlan = 'Cisco CallManager')
    {
        $this->callingNumberingPlan = $callingNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNationalPrefix value
     * @return string|null
     */
    public function getCallingPartyNationalPrefix()
    {
        return $this->callingPartyNationalPrefix;
    }
    /**
     * Set callingPartyNationalPrefix value
     * @param string $callingPartyNationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyNationalPrefix($callingPartyNationalPrefix = null)
    {
        $this->callingPartyNationalPrefix = $callingPartyNationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyInternationalPrefix value
     * @return string|null
     */
    public function getCallingPartyInternationalPrefix()
    {
        return $this->callingPartyInternationalPrefix;
    }
    /**
     * Set callingPartyInternationalPrefix value
     * @param string $callingPartyInternationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyInternationalPrefix($callingPartyInternationalPrefix = null)
    {
        $this->callingPartyInternationalPrefix = $callingPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyUnknownPrefix value
     * @return string|null
     */
    public function getCallingPartyUnknownPrefix()
    {
        return $this->callingPartyUnknownPrefix;
    }
    /**
     * Set callingPartyUnknownPrefix value
     * @param string $callingPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyUnknownPrefix($callingPartyUnknownPrefix = null)
    {
        $this->callingPartyUnknownPrefix = $callingPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get callingPartySubscriberPrefix value
     * @return string|null
     */
    public function getCallingPartySubscriberPrefix()
    {
        return $this->callingPartySubscriberPrefix;
    }
    /**
     * Set callingPartySubscriberPrefix value
     * @param string $callingPartySubscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartySubscriberPrefix($callingPartySubscriberPrefix = null)
    {
        $this->callingPartySubscriberPrefix = $callingPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return isset($this->callingPartyNationalStripDigits) ? $this->callingPartyNationalStripDigits : null;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyNationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        if (is_null($callingPartyNationalStripDigits) || (is_array($callingPartyNationalStripDigits) && empty($callingPartyNationalStripDigits))) {
            unset($this->callingPartyNationalStripDigits);
        } else {
            $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return isset($this->callingPartyInternationalStripDigits) ? $this->callingPartyInternationalStripDigits : null;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyInternationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        if (is_null($callingPartyInternationalStripDigits) || (is_array($callingPartyInternationalStripDigits) && empty($callingPartyInternationalStripDigits))) {
            unset($this->callingPartyInternationalStripDigits);
        } else {
            $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return isset($this->callingPartyUnknownStripDigits) ? $this->callingPartyUnknownStripDigits : null;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        if (is_null($callingPartyUnknownStripDigits) || (is_array($callingPartyUnknownStripDigits) && empty($callingPartyUnknownStripDigits))) {
            unset($this->callingPartyUnknownStripDigits);
        } else {
            $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return isset($this->callingPartySubscriberStripDigits) ? $this->callingPartySubscriberStripDigits : null;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartySubscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        if (is_null($callingPartySubscriberStripDigits) || (is_array($callingPartySubscriberStripDigits) && empty($callingPartySubscriberStripDigits))) {
            unset($this->callingPartySubscriberStripDigits);
        } else {
            $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return isset($this->callingPartyNationalTransformationCssName) ? $this->callingPartyNationalTransformationCssName : null;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName = null)
    {
        if (is_null($callingPartyNationalTransformationCssName) || (is_array($callingPartyNationalTransformationCssName) && empty($callingPartyNationalTransformationCssName))) {
            unset($this->callingPartyNationalTransformationCssName);
        } else {
            $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return isset($this->callingPartyInternationalTransformationCssName) ? $this->callingPartyInternationalTransformationCssName : null;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName = null)
    {
        if (is_null($callingPartyInternationalTransformationCssName) || (is_array($callingPartyInternationalTransformationCssName) && empty($callingPartyInternationalTransformationCssName))) {
            unset($this->callingPartyInternationalTransformationCssName);
        } else {
            $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return isset($this->callingPartyUnknownTransformationCssName) ? $this->callingPartyUnknownTransformationCssName : null;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        if (is_null($callingPartyUnknownTransformationCssName) || (is_array($callingPartyUnknownTransformationCssName) && empty($callingPartyUnknownTransformationCssName))) {
            unset($this->callingPartyUnknownTransformationCssName);
        } else {
            $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return isset($this->callingPartySubscriberTransformationCssName) ? $this->callingPartySubscriberTransformationCssName : null;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCallingPartySubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName = null)
    {
        if (is_null($callingPartySubscriberTransformationCssName) || (is_array($callingPartySubscriberTransformationCssName) && empty($callingPartySubscriberTransformationCssName))) {
            unset($this->callingPartySubscriberTransformationCssName);
        } else {
            $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return isset($this->calledPartyNationalStripDigits) ? $this->calledPartyNationalStripDigits : null;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyNationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        if (is_null($calledPartyNationalStripDigits) || (is_array($calledPartyNationalStripDigits) && empty($calledPartyNationalStripDigits))) {
            unset($this->calledPartyNationalStripDigits);
        } else {
            $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return isset($this->calledPartyInternationalStripDigits) ? $this->calledPartyInternationalStripDigits : null;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyInternationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        if (is_null($calledPartyInternationalStripDigits) || (is_array($calledPartyInternationalStripDigits) && empty($calledPartyInternationalStripDigits))) {
            unset($this->calledPartyInternationalStripDigits);
        } else {
            $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return isset($this->calledPartySubscriberStripDigits) ? $this->calledPartySubscriberStripDigits : null;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartySubscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        if (is_null($calledPartySubscriberStripDigits) || (is_array($calledPartySubscriberStripDigits) && empty($calledPartySubscriberStripDigits))) {
            unset($this->calledPartySubscriberStripDigits);
        } else {
            $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return isset($this->calledPartyNationalTransformationCssName) ? $this->calledPartyNationalTransformationCssName : null;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        if (is_null($calledPartyNationalTransformationCssName) || (is_array($calledPartyNationalTransformationCssName) && empty($calledPartyNationalTransformationCssName))) {
            unset($this->calledPartyNationalTransformationCssName);
        } else {
            $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return isset($this->calledPartyInternationalTransformationCssName) ? $this->calledPartyInternationalTransformationCssName : null;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        if (is_null($calledPartyInternationalTransformationCssName) || (is_array($calledPartyInternationalTransformationCssName) && empty($calledPartyInternationalTransformationCssName))) {
            unset($this->calledPartyInternationalTransformationCssName);
        } else {
            $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return isset($this->calledPartySubscriberTransformationCssName) ? $this->calledPartySubscriberTransformationCssName : null;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCalledPartySubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        if (is_null($calledPartySubscriberTransformationCssName) || (is_array($calledPartySubscriberTransformationCssName) && empty($calledPartySubscriberTransformationCssName))) {
            unset($this->calledPartySubscriberTransformationCssName);
        } else {
            $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setPstnAccess($pstnAccess = 'true')
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setImeE164TransformationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get displayIeDelivery value
     * @return string|null
     */
    public function getDisplayIeDelivery()
    {
        return $this->displayIeDelivery;
    }
    /**
     * Set displayIeDelivery value
     * @param string $displayIeDelivery
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setDisplayIeDelivery($displayIeDelivery = null)
    {
        $this->displayIeDelivery = $displayIeDelivery;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = 'true')
    {
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = 'true')
    {
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = 'true')
    {
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = 'true')
    {
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssNatl()
    {
        return $this->useDevicePoolCalledCssNatl;
    }
    /**
     * Set useDevicePoolCalledCssNatl value
     * @param string $useDevicePoolCalledCssNatl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl = 'true')
    {
        $this->useDevicePoolCalledCssNatl = $useDevicePoolCalledCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssIntl()
    {
        return $this->useDevicePoolCalledCssIntl;
    }
    /**
     * Set useDevicePoolCalledCssIntl value
     * @param string $useDevicePoolCalledCssIntl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl = 'true')
    {
        $this->useDevicePoolCalledCssIntl = $useDevicePoolCalledCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = 'true')
    {
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssSubs()
    {
        return $this->useDevicePoolCalledCssSubs;
    }
    /**
     * Set useDevicePoolCalledCssSubs value
     * @param string $useDevicePoolCalledCssSubs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs = 'true')
    {
        $this->useDevicePoolCalledCssSubs = $useDevicePoolCalledCssSubs;
        return $this;
    }
    /**
     * Get useDevicePoolCntdPnTransformationCss value
     * @return string|null
     */
    public function getUseDevicePoolCntdPnTransformationCss()
    {
        return $this->useDevicePoolCntdPnTransformationCss;
    }
    /**
     * Set useDevicePoolCntdPnTransformationCss value
     * @param string $useDevicePoolCntdPnTransformationCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss = 'true')
    {
        $this->useDevicePoolCntdPnTransformationCss = $useDevicePoolCntdPnTransformationCss;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setCntdPnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get redirectingPartyTransformationCSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRedirectingPartyTransformationCSS()
    {
        return isset($this->redirectingPartyTransformationCSS) ? $this->redirectingPartyTransformationCSS : null;
    }
    /**
     * Set redirectingPartyTransformationCSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq
     */
    public function setRedirectingPartyTransformationCSS(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS = null)
    {
        if (is_null($redirectingPartyTransformationCSS) || (is_array($redirectingPartyTransformationCSS) && empty($redirectingPartyTransformationCSS))) {
            unset($this->redirectingPartyTransformationCSS);
        } else {
            $this->redirectingPartyTransformationCSS = $redirectingPartyTransformationCSS;
        }
        return $this;
    }
}
