<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGatewayReq StructType
 * @subpackage Structs
 */
class UpdateGatewayReq extends APIRequest
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: uuid | domainName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | domainName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newDomainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newDomainName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - default: Cisco VG200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $product;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - default: MGCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * Constructor method for UpdateGatewayReq
     * @uses UpdateGatewayReq::setDomainName()
     * @uses UpdateGatewayReq::setUuid()
     * @uses UpdateGatewayReq::setNewDomainName()
     * @uses UpdateGatewayReq::setDescription()
     * @uses UpdateGatewayReq::setProduct()
     * @uses UpdateGatewayReq::setProtocol()
     * @uses UpdateGatewayReq::setCallManagerGroupName()
     * @uses UpdateGatewayReq::setVendorConfig()
     * @param string $domainName
     * @param string $uuid
     * @param string $newDomainName
     * @param string $description
     * @param string $product
     * @param string $protocol
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     */
    public function __construct($domainName = null, $uuid = null, $newDomainName = null, $description = null, $product = 'Cisco VG200', $protocol = 'MGCP', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this
            ->setDomainName($domainName)
            ->setUuid($uuid)
            ->setNewDomainName($newDomainName)
            ->setDescription($description)
            ->setProduct($product)
            ->setProtocol($protocol)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setVendorConfig($vendorConfig);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq
     */
    public function setDomainName($domainName = null)
    {
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newDomainName value
     * @return string|null
     */
    public function getNewDomainName()
    {
        return $this->newDomainName;
    }
    /**
     * Set newDomainName value
     * @param string $newDomainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq
     */
    public function setNewDomainName($newDomainName = null)
    {
        $this->newDomainName = $newDomainName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduct()
    {
        return isset($this->product) ? $this->product : null;
    }
    /**
     * Set product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq
     */
    public function setProduct($product = 'Cisco VG200')
    {
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->product);
        } else {
            $this->product = $product;
        }
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq
     */
    public function setProtocol($protocol = 'MGCP')
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return isset($this->callManagerGroupName) ? $this->callManagerGroupName : null;
    }
    /**
     * Set callManagerGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq
     */
    public function setCallManagerGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null)
    {
        if (is_null($callManagerGroupName) || (is_array($callManagerGroupName) && empty($callManagerGroupName))) {
            unset($this->callManagerGroupName);
        } else {
            $this->callManagerGroupName = $callManagerGroupName;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
}
