<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFeatureGroupTemplateReq StructType
 * @subpackage Structs
 */
class UpdateFeatureGroupTemplateReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The homeCluster
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $homeCluster;
    /**
     * The imAndUcPresenceEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $imAndUcPresenceEnable;
    /**
     * The serviceProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $serviceProfile;
    /**
     * The allowCTIControl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCTIControl;
    /**
     * The enableEMCC
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEMCC;
    /**
     * The enableMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The maxDeskPickupWait
     * Meta information extracted from the WSDL
     * - default: 10000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxDeskPickupWait;
    /**
     * The remoteDestinationLimit
     * Meta information extracted from the WSDL
     * - default: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The BLFPresenceGp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $BLFPresenceGp;
    /**
     * The subscribeCallingSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearch;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The userProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $userProfile;
    /**
     * The meetingInformation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $meetingInformation;
    /**
     * Constructor method for UpdateFeatureGroupTemplateReq
     * @uses UpdateFeatureGroupTemplateReq::setNewName()
     * @uses UpdateFeatureGroupTemplateReq::setDescription()
     * @uses UpdateFeatureGroupTemplateReq::setHomeCluster()
     * @uses UpdateFeatureGroupTemplateReq::setImAndUcPresenceEnable()
     * @uses UpdateFeatureGroupTemplateReq::setServiceProfile()
     * @uses UpdateFeatureGroupTemplateReq::setAllowCTIControl()
     * @uses UpdateFeatureGroupTemplateReq::setEnableEMCC()
     * @uses UpdateFeatureGroupTemplateReq::setEnableMobility()
     * @uses UpdateFeatureGroupTemplateReq::setEnableMobileVoiceAccess()
     * @uses UpdateFeatureGroupTemplateReq::setMaxDeskPickupWait()
     * @uses UpdateFeatureGroupTemplateReq::setRemoteDestinationLimit()
     * @uses UpdateFeatureGroupTemplateReq::setBLFPresenceGp()
     * @uses UpdateFeatureGroupTemplateReq::setSubscribeCallingSearch()
     * @uses UpdateFeatureGroupTemplateReq::setUserLocale()
     * @uses UpdateFeatureGroupTemplateReq::setUserProfile()
     * @uses UpdateFeatureGroupTemplateReq::setMeetingInformation()
     * @param string $newName
     * @param string $description
     * @param string $homeCluster
     * @param string $imAndUcPresenceEnable
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @param string $allowCTIControl
     * @param string $enableEMCC
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param string $maxDeskPickupWait
     * @param string $remoteDestinationLimit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $bLFPresenceGp
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearch
     * @param string $userLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @param string $meetingInformation
     */
    public function __construct($newName = null, $description = null, $homeCluster = null, $imAndUcPresenceEnable = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null, $allowCTIControl = null, $enableEMCC = null, $enableMobility = null, $enableMobileVoiceAccess = null, $maxDeskPickupWait = '10000', $remoteDestinationLimit = '4', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $bLFPresenceGp = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearch = null, $userLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null, $meetingInformation = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setHomeCluster($homeCluster)
            ->setImAndUcPresenceEnable($imAndUcPresenceEnable)
            ->setServiceProfile($serviceProfile)
            ->setAllowCTIControl($allowCTIControl)
            ->setEnableEMCC($enableEMCC)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setMaxDeskPickupWait($maxDeskPickupWait)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setBLFPresenceGp($bLFPresenceGp)
            ->setSubscribeCallingSearch($subscribeCallingSearch)
            ->setUserLocale($userLocale)
            ->setUserProfile($userProfile)
            ->setMeetingInformation($meetingInformation);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get homeCluster value
     * @return string|null
     */
    public function getHomeCluster()
    {
        return $this->homeCluster;
    }
    /**
     * Set homeCluster value
     * @param string $homeCluster
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setHomeCluster($homeCluster = null)
    {
        $this->homeCluster = $homeCluster;
        return $this;
    }
    /**
     * Get imAndUcPresenceEnable value
     * @return string|null
     */
    public function getImAndUcPresenceEnable()
    {
        return $this->imAndUcPresenceEnable;
    }
    /**
     * Set imAndUcPresenceEnable value
     * @param string $imAndUcPresenceEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setImAndUcPresenceEnable($imAndUcPresenceEnable = null)
    {
        $this->imAndUcPresenceEnable = $imAndUcPresenceEnable;
        return $this;
    }
    /**
     * Get serviceProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getServiceProfile()
    {
        return isset($this->serviceProfile) ? $this->serviceProfile : null;
    }
    /**
     * Set serviceProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setServiceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null)
    {
        if (is_null($serviceProfile) || (is_array($serviceProfile) && empty($serviceProfile))) {
            unset($this->serviceProfile);
        } else {
            $this->serviceProfile = $serviceProfile;
        }
        return $this;
    }
    /**
     * Get allowCTIControl value
     * @return string|null
     */
    public function getAllowCTIControl()
    {
        return $this->allowCTIControl;
    }
    /**
     * Set allowCTIControl value
     * @param string $allowCTIControl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setAllowCTIControl($allowCTIControl = null)
    {
        $this->allowCTIControl = $allowCTIControl;
        return $this;
    }
    /**
     * Get enableEMCC value
     * @return string|null
     */
    public function getEnableEMCC()
    {
        return $this->enableEMCC;
    }
    /**
     * Set enableEMCC value
     * @param string $enableEMCC
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setEnableEMCC($enableEMCC = null)
    {
        $this->enableEMCC = $enableEMCC;
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setEnableMobility($enableMobility = null)
    {
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = null)
    {
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get maxDeskPickupWait value
     * @return string|null
     */
    public function getMaxDeskPickupWait()
    {
        return $this->maxDeskPickupWait;
    }
    /**
     * Set maxDeskPickupWait value
     * @param string $maxDeskPickupWait
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setMaxDeskPickupWait($maxDeskPickupWait = '10000')
    {
        $this->maxDeskPickupWait = $maxDeskPickupWait;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string|null
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @param string $remoteDestinationLimit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = '4')
    {
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get BLFPresenceGp value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getBLFPresenceGp()
    {
        return $this->BLFPresenceGp;
    }
    /**
     * Set BLFPresenceGp value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $bLFPresenceGp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setBLFPresenceGp(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $bLFPresenceGp = null)
    {
        $this->BLFPresenceGp = $bLFPresenceGp;
        return $this;
    }
    /**
     * Get subscribeCallingSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearch()
    {
        return isset($this->subscribeCallingSearch) ? $this->subscribeCallingSearch : null;
    }
    /**
     * Set subscribeCallingSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearch
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setSubscribeCallingSearch(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearch = null)
    {
        if (is_null($subscribeCallingSearch) || (is_array($subscribeCallingSearch) && empty($subscribeCallingSearch))) {
            unset($this->subscribeCallingSearch);
        } else {
            $this->subscribeCallingSearch = $subscribeCallingSearch;
        }
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setUserLocale($userLocale = null)
    {
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get userProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUserProfile()
    {
        return isset($this->userProfile) ? $this->userProfile : null;
    }
    /**
     * Set userProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setUserProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null)
    {
        if (is_null($userProfile) || (is_array($userProfile) && empty($userProfile))) {
            unset($this->userProfile);
        } else {
            $this->userProfile = $userProfile;
        }
        return $this;
    }
    /**
     * Get meetingInformation value
     * @return string|null
     */
    public function getMeetingInformation()
    {
        return $this->meetingInformation;
    }
    /**
     * Set meetingInformation value
     * @param string $meetingInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq
     */
    public function setMeetingInformation($meetingInformation = null)
    {
        $this->meetingInformation = $meetingInformation;
        return $this;
    }
}
