<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDirNumberAliasLookupandSyncReq StructType
 * @subpackage Structs
 */
class UpdateDirNumberAliasLookupandSyncReq extends NameAndGUIDRequest
{
    /**
     * The ldapConfigName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapConfigName;
    /**
     * The ldapManagerDisgName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapManagerDisgName;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPassword;
    /**
     * The ldapUserSearch
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapUserSearch;
    /**
     * The ldapDirectoryServerUsage
     * Meta information extracted from the WSDL
     * - default: DirSync
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapDirectoryServerUsage;
    /**
     * The keepAliveSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $keepAliveSearch;
    /**
     * The keepAliveTime
     * Meta information extracted from the WSDL
     * - default: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keepAliveTime;
    /**
     * The sipAliasSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sipAliasSuffix;
    /**
     * The enableCachingofRecords
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCachingofRecords;
    /**
     * The servers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Servers
     */
    public $servers;
    /**
     * The cacheSizeforAliasLookup
     * Meta information extracted from the WSDL
     * - default: 3000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cacheSizeforAliasLookup;
    /**
     * The cacheAgeforAliasLookup
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cacheAgeforAliasLookup;
    /**
     * Constructor method for UpdateDirNumberAliasLookupandSyncReq
     * @uses UpdateDirNumberAliasLookupandSyncReq::setLdapConfigName()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setLdapManagerDisgName()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setLdapPassword()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setLdapUserSearch()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setLdapDirectoryServerUsage()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setKeepAliveSearch()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setKeepAliveTime()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setSipAliasSuffix()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setEnableCachingofRecords()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setServers()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setCacheSizeforAliasLookup()
     * @uses UpdateDirNumberAliasLookupandSyncReq::setCacheAgeforAliasLookup()
     * @param string $ldapConfigName
     * @param string $ldapManagerDisgName
     * @param string $ldapPassword
     * @param string $ldapUserSearch
     * @param string $ldapDirectoryServerUsage
     * @param string $keepAliveSearch
     * @param string $keepAliveTime
     * @param string $sipAliasSuffix
     * @param string $enableCachingofRecords
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @param string $cacheSizeforAliasLookup
     * @param string $cacheAgeforAliasLookup
     */
    public function __construct($ldapConfigName = null, $ldapManagerDisgName = null, $ldapPassword = null, $ldapUserSearch = null, $ldapDirectoryServerUsage = 'DirSync', $keepAliveSearch = null, $keepAliveTime = '5', $sipAliasSuffix = null, $enableCachingofRecords = null, \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null, $cacheSizeforAliasLookup = '3000', $cacheAgeforAliasLookup = '0')
    {
        $this
            ->setLdapConfigName($ldapConfigName)
            ->setLdapManagerDisgName($ldapManagerDisgName)
            ->setLdapPassword($ldapPassword)
            ->setLdapUserSearch($ldapUserSearch)
            ->setLdapDirectoryServerUsage($ldapDirectoryServerUsage)
            ->setKeepAliveSearch($keepAliveSearch)
            ->setKeepAliveTime($keepAliveTime)
            ->setSipAliasSuffix($sipAliasSuffix)
            ->setEnableCachingofRecords($enableCachingofRecords)
            ->setServers($servers)
            ->setCacheSizeforAliasLookup($cacheSizeforAliasLookup)
            ->setCacheAgeforAliasLookup($cacheAgeforAliasLookup);
    }
    /**
     * Get ldapConfigName value
     * @return string|null
     */
    public function getLdapConfigName()
    {
        return $this->ldapConfigName;
    }
    /**
     * Set ldapConfigName value
     * @param string $ldapConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setLdapConfigName($ldapConfigName = null)
    {
        $this->ldapConfigName = $ldapConfigName;
        return $this;
    }
    /**
     * Get ldapManagerDisgName value
     * @return string|null
     */
    public function getLdapManagerDisgName()
    {
        return $this->ldapManagerDisgName;
    }
    /**
     * Set ldapManagerDisgName value
     * @param string $ldapManagerDisgName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setLdapManagerDisgName($ldapManagerDisgName = null)
    {
        $this->ldapManagerDisgName = $ldapManagerDisgName;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setLdapPassword($ldapPassword = null)
    {
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get ldapUserSearch value
     * @return string|null
     */
    public function getLdapUserSearch()
    {
        return $this->ldapUserSearch;
    }
    /**
     * Set ldapUserSearch value
     * @param string $ldapUserSearch
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setLdapUserSearch($ldapUserSearch = null)
    {
        $this->ldapUserSearch = $ldapUserSearch;
        return $this;
    }
    /**
     * Get ldapDirectoryServerUsage value
     * @return string|null
     */
    public function getLdapDirectoryServerUsage()
    {
        return $this->ldapDirectoryServerUsage;
    }
    /**
     * Set ldapDirectoryServerUsage value
     * @param string $ldapDirectoryServerUsage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setLdapDirectoryServerUsage($ldapDirectoryServerUsage = 'DirSync')
    {
        $this->ldapDirectoryServerUsage = $ldapDirectoryServerUsage;
        return $this;
    }
    /**
     * Get keepAliveSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeepAliveSearch()
    {
        return isset($this->keepAliveSearch) ? $this->keepAliveSearch : null;
    }
    /**
     * Set keepAliveSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keepAliveSearch
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setKeepAliveSearch($keepAliveSearch = null)
    {
        if (is_null($keepAliveSearch) || (is_array($keepAliveSearch) && empty($keepAliveSearch))) {
            unset($this->keepAliveSearch);
        } else {
            $this->keepAliveSearch = $keepAliveSearch;
        }
        return $this;
    }
    /**
     * Get keepAliveTime value
     * @return string|null
     */
    public function getKeepAliveTime()
    {
        return $this->keepAliveTime;
    }
    /**
     * Set keepAliveTime value
     * @param string $keepAliveTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setKeepAliveTime($keepAliveTime = '5')
    {
        $this->keepAliveTime = $keepAliveTime;
        return $this;
    }
    /**
     * Get sipAliasSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSipAliasSuffix()
    {
        return isset($this->sipAliasSuffix) ? $this->sipAliasSuffix : null;
    }
    /**
     * Set sipAliasSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sipAliasSuffix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setSipAliasSuffix($sipAliasSuffix = null)
    {
        if (is_null($sipAliasSuffix) || (is_array($sipAliasSuffix) && empty($sipAliasSuffix))) {
            unset($this->sipAliasSuffix);
        } else {
            $this->sipAliasSuffix = $sipAliasSuffix;
        }
        return $this;
    }
    /**
     * Get enableCachingofRecords value
     * @return string|null
     */
    public function getEnableCachingofRecords()
    {
        return $this->enableCachingofRecords;
    }
    /**
     * Set enableCachingofRecords value
     * @param string $enableCachingofRecords
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setEnableCachingofRecords($enableCachingofRecords = null)
    {
        $this->enableCachingofRecords = $enableCachingofRecords;
        return $this;
    }
    /**
     * Get servers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Servers|null
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setServers(\\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get cacheSizeforAliasLookup value
     * @return string|null
     */
    public function getCacheSizeforAliasLookup()
    {
        return $this->cacheSizeforAliasLookup;
    }
    /**
     * Set cacheSizeforAliasLookup value
     * @param string $cacheSizeforAliasLookup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setCacheSizeforAliasLookup($cacheSizeforAliasLookup = '3000')
    {
        $this->cacheSizeforAliasLookup = $cacheSizeforAliasLookup;
        return $this;
    }
    /**
     * Get cacheAgeforAliasLookup value
     * @return string|null
     */
    public function getCacheAgeforAliasLookup()
    {
        return $this->cacheAgeforAliasLookup;
    }
    /**
     * Set cacheAgeforAliasLookup value
     * @param string $cacheAgeforAliasLookup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq
     */
    public function setCacheAgeforAliasLookup($cacheAgeforAliasLookup = '0')
    {
        $this->cacheAgeforAliasLookup = $cacheAgeforAliasLookup;
        return $this;
    }
}
