<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDhcpSubnetReq StructType
 * @subpackage Structs
 */
class UpdateDhcpSubnetReq extends APIRequest
{
    /**
     * The dhcpServerName
     * Meta information extracted from the WSDL
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dhcpServerName;
    /**
     * The subnetIpAddress
     * Meta information extracted from the WSDL
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subnetIpAddress;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newDhcpServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $newDhcpServerName;
    /**
     * The newSubnetIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newSubnetIpAddress;
    /**
     * The primaryStartIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryStartIpAddress;
    /**
     * The primaryEndIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryEndIpAddress;
    /**
     * The secondaryStartIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryStartIpAddress;
    /**
     * The secondaryEndIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryEndIpAddress;
    /**
     * The primaryRouterIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryRouterIpAddress;
    /**
     * The secondaryRouterIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryRouterIpAddress;
    /**
     * The subnetMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subnetMask;
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The primaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryDnsIpAddress;
    /**
     * The secondaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryDnsIpAddress;
    /**
     * The tftpServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tftpServerName;
    /**
     * The primaryTftpServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primaryTftpServerIpAddress;
    /**
     * The secondaryTftpServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryTftpServerIpAddress;
    /**
     * The bootstrapServerIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bootstrapServerIpAddress;
    /**
     * The arpCacheTimeout
     * Meta information extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $arpCacheTimeout;
    /**
     * The ipAddressLeaseTime
     * Meta information extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddressLeaseTime;
    /**
     * The renewalTime
     * Meta information extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $renewalTime;
    /**
     * The rebindingTime
     * Meta information extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rebindingTime;
    /**
     * Constructor method for UpdateDhcpSubnetReq
     * @uses UpdateDhcpSubnetReq::setDhcpServerName()
     * @uses UpdateDhcpSubnetReq::setSubnetIpAddress()
     * @uses UpdateDhcpSubnetReq::setUuid()
     * @uses UpdateDhcpSubnetReq::setNewDhcpServerName()
     * @uses UpdateDhcpSubnetReq::setNewSubnetIpAddress()
     * @uses UpdateDhcpSubnetReq::setPrimaryStartIpAddress()
     * @uses UpdateDhcpSubnetReq::setPrimaryEndIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryStartIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryEndIpAddress()
     * @uses UpdateDhcpSubnetReq::setPrimaryRouterIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryRouterIpAddress()
     * @uses UpdateDhcpSubnetReq::setSubnetMask()
     * @uses UpdateDhcpSubnetReq::setDomainName()
     * @uses UpdateDhcpSubnetReq::setPrimaryDnsIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryDnsIpAddress()
     * @uses UpdateDhcpSubnetReq::setTftpServerName()
     * @uses UpdateDhcpSubnetReq::setPrimaryTftpServerIpAddress()
     * @uses UpdateDhcpSubnetReq::setSecondaryTftpServerIpAddress()
     * @uses UpdateDhcpSubnetReq::setBootstrapServerIpAddress()
     * @uses UpdateDhcpSubnetReq::setArpCacheTimeout()
     * @uses UpdateDhcpSubnetReq::setIpAddressLeaseTime()
     * @uses UpdateDhcpSubnetReq::setRenewalTime()
     * @uses UpdateDhcpSubnetReq::setRebindingTime()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dhcpServerName
     * @param string $subnetIpAddress
     * @param string $uuid
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newDhcpServerName
     * @param string $newSubnetIpAddress
     * @param string $primaryStartIpAddress
     * @param string $primaryEndIpAddress
     * @param string $secondaryStartIpAddress
     * @param string $secondaryEndIpAddress
     * @param string $primaryRouterIpAddress
     * @param string $secondaryRouterIpAddress
     * @param string $subnetMask
     * @param string $domainName
     * @param string $primaryDnsIpAddress
     * @param string $secondaryDnsIpAddress
     * @param string $tftpServerName
     * @param string $primaryTftpServerIpAddress
     * @param string $secondaryTftpServerIpAddress
     * @param string $bootstrapServerIpAddress
     * @param string $arpCacheTimeout
     * @param string $ipAddressLeaseTime
     * @param string $renewalTime
     * @param string $rebindingTime
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dhcpServerName = null, $subnetIpAddress = null, $uuid = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newDhcpServerName = null, $newSubnetIpAddress = null, $primaryStartIpAddress = null, $primaryEndIpAddress = null, $secondaryStartIpAddress = null, $secondaryEndIpAddress = null, $primaryRouterIpAddress = null, $secondaryRouterIpAddress = null, $subnetMask = null, $domainName = null, $primaryDnsIpAddress = null, $secondaryDnsIpAddress = null, $tftpServerName = null, $primaryTftpServerIpAddress = null, $secondaryTftpServerIpAddress = null, $bootstrapServerIpAddress = null, $arpCacheTimeout = '0', $ipAddressLeaseTime = '0', $renewalTime = '0', $rebindingTime = '0')
    {
        $this
            ->setDhcpServerName($dhcpServerName)
            ->setSubnetIpAddress($subnetIpAddress)
            ->setUuid($uuid)
            ->setNewDhcpServerName($newDhcpServerName)
            ->setNewSubnetIpAddress($newSubnetIpAddress)
            ->setPrimaryStartIpAddress($primaryStartIpAddress)
            ->setPrimaryEndIpAddress($primaryEndIpAddress)
            ->setSecondaryStartIpAddress($secondaryStartIpAddress)
            ->setSecondaryEndIpAddress($secondaryEndIpAddress)
            ->setPrimaryRouterIpAddress($primaryRouterIpAddress)
            ->setSecondaryRouterIpAddress($secondaryRouterIpAddress)
            ->setSubnetMask($subnetMask)
            ->setDomainName($domainName)
            ->setPrimaryDnsIpAddress($primaryDnsIpAddress)
            ->setSecondaryDnsIpAddress($secondaryDnsIpAddress)
            ->setTftpServerName($tftpServerName)
            ->setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress)
            ->setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress)
            ->setBootstrapServerIpAddress($bootstrapServerIpAddress)
            ->setArpCacheTimeout($arpCacheTimeout)
            ->setIpAddressLeaseTime($ipAddressLeaseTime)
            ->setRenewalTime($renewalTime)
            ->setRebindingTime($rebindingTime);
    }
    /**
     * Get dhcpServerName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDhcpServerName()
    {
        return isset($this->dhcpServerName) ? $this->dhcpServerName : null;
    }
    /**
     * Set dhcpServerName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dhcpServerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setDhcpServerName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dhcpServerName = null)
    {
        if (is_null($dhcpServerName) || (is_array($dhcpServerName) && empty($dhcpServerName))) {
            unset($this->dhcpServerName);
        } else {
            $this->dhcpServerName = $dhcpServerName;
        }
        return $this;
    }
    /**
     * Get subnetIpAddress value
     * @return string
     */
    public function getSubnetIpAddress()
    {
        return isset($this->subnetIpAddress) ? $this->subnetIpAddress : null;
    }
    /**
     * Set subnetIpAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $subnetIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setSubnetIpAddress($subnetIpAddress = null)
    {
        if (is_null($subnetIpAddress) || (is_array($subnetIpAddress) && empty($subnetIpAddress))) {
            unset($this->subnetIpAddress);
        } else {
            $this->subnetIpAddress = $subnetIpAddress;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newDhcpServerName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNewDhcpServerName()
    {
        return $this->newDhcpServerName;
    }
    /**
     * Set newDhcpServerName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newDhcpServerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setNewDhcpServerName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newDhcpServerName = null)
    {
        $this->newDhcpServerName = $newDhcpServerName;
        return $this;
    }
    /**
     * Get newSubnetIpAddress value
     * @return string|null
     */
    public function getNewSubnetIpAddress()
    {
        return $this->newSubnetIpAddress;
    }
    /**
     * Set newSubnetIpAddress value
     * @param string $newSubnetIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setNewSubnetIpAddress($newSubnetIpAddress = null)
    {
        $this->newSubnetIpAddress = $newSubnetIpAddress;
        return $this;
    }
    /**
     * Get primaryStartIpAddress value
     * @return string|null
     */
    public function getPrimaryStartIpAddress()
    {
        return $this->primaryStartIpAddress;
    }
    /**
     * Set primaryStartIpAddress value
     * @param string $primaryStartIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryStartIpAddress($primaryStartIpAddress = null)
    {
        $this->primaryStartIpAddress = $primaryStartIpAddress;
        return $this;
    }
    /**
     * Get primaryEndIpAddress value
     * @return string|null
     */
    public function getPrimaryEndIpAddress()
    {
        return $this->primaryEndIpAddress;
    }
    /**
     * Set primaryEndIpAddress value
     * @param string $primaryEndIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryEndIpAddress($primaryEndIpAddress = null)
    {
        $this->primaryEndIpAddress = $primaryEndIpAddress;
        return $this;
    }
    /**
     * Get secondaryStartIpAddress value
     * @return string|null
     */
    public function getSecondaryStartIpAddress()
    {
        return $this->secondaryStartIpAddress;
    }
    /**
     * Set secondaryStartIpAddress value
     * @param string $secondaryStartIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryStartIpAddress($secondaryStartIpAddress = null)
    {
        $this->secondaryStartIpAddress = $secondaryStartIpAddress;
        return $this;
    }
    /**
     * Get secondaryEndIpAddress value
     * @return string|null
     */
    public function getSecondaryEndIpAddress()
    {
        return $this->secondaryEndIpAddress;
    }
    /**
     * Set secondaryEndIpAddress value
     * @param string $secondaryEndIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryEndIpAddress($secondaryEndIpAddress = null)
    {
        $this->secondaryEndIpAddress = $secondaryEndIpAddress;
        return $this;
    }
    /**
     * Get primaryRouterIpAddress value
     * @return string|null
     */
    public function getPrimaryRouterIpAddress()
    {
        return $this->primaryRouterIpAddress;
    }
    /**
     * Set primaryRouterIpAddress value
     * @param string $primaryRouterIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryRouterIpAddress($primaryRouterIpAddress = null)
    {
        $this->primaryRouterIpAddress = $primaryRouterIpAddress;
        return $this;
    }
    /**
     * Get secondaryRouterIpAddress value
     * @return string|null
     */
    public function getSecondaryRouterIpAddress()
    {
        return $this->secondaryRouterIpAddress;
    }
    /**
     * Set secondaryRouterIpAddress value
     * @param string $secondaryRouterIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryRouterIpAddress($secondaryRouterIpAddress = null)
    {
        $this->secondaryRouterIpAddress = $secondaryRouterIpAddress;
        return $this;
    }
    /**
     * Get subnetMask value
     * @return string|null
     */
    public function getSubnetMask()
    {
        return $this->subnetMask;
    }
    /**
     * Set subnetMask value
     * @param string $subnetMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setSubnetMask($subnetMask = null)
    {
        $this->subnetMask = $subnetMask;
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setDomainName($domainName = null)
    {
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get primaryDnsIpAddress value
     * @return string|null
     */
    public function getPrimaryDnsIpAddress()
    {
        return $this->primaryDnsIpAddress;
    }
    /**
     * Set primaryDnsIpAddress value
     * @param string $primaryDnsIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryDnsIpAddress($primaryDnsIpAddress = null)
    {
        $this->primaryDnsIpAddress = $primaryDnsIpAddress;
        return $this;
    }
    /**
     * Get secondaryDnsIpAddress value
     * @return string|null
     */
    public function getSecondaryDnsIpAddress()
    {
        return $this->secondaryDnsIpAddress;
    }
    /**
     * Set secondaryDnsIpAddress value
     * @param string $secondaryDnsIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryDnsIpAddress($secondaryDnsIpAddress = null)
    {
        $this->secondaryDnsIpAddress = $secondaryDnsIpAddress;
        return $this;
    }
    /**
     * Get tftpServerName value
     * @return string|null
     */
    public function getTftpServerName()
    {
        return $this->tftpServerName;
    }
    /**
     * Set tftpServerName value
     * @param string $tftpServerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setTftpServerName($tftpServerName = null)
    {
        $this->tftpServerName = $tftpServerName;
        return $this;
    }
    /**
     * Get primaryTftpServerIpAddress value
     * @return string|null
     */
    public function getPrimaryTftpServerIpAddress()
    {
        return $this->primaryTftpServerIpAddress;
    }
    /**
     * Set primaryTftpServerIpAddress value
     * @param string $primaryTftpServerIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress = null)
    {
        $this->primaryTftpServerIpAddress = $primaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get secondaryTftpServerIpAddress value
     * @return string|null
     */
    public function getSecondaryTftpServerIpAddress()
    {
        return $this->secondaryTftpServerIpAddress;
    }
    /**
     * Set secondaryTftpServerIpAddress value
     * @param string $secondaryTftpServerIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress = null)
    {
        $this->secondaryTftpServerIpAddress = $secondaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get bootstrapServerIpAddress value
     * @return string|null
     */
    public function getBootstrapServerIpAddress()
    {
        return $this->bootstrapServerIpAddress;
    }
    /**
     * Set bootstrapServerIpAddress value
     * @param string $bootstrapServerIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setBootstrapServerIpAddress($bootstrapServerIpAddress = null)
    {
        $this->bootstrapServerIpAddress = $bootstrapServerIpAddress;
        return $this;
    }
    /**
     * Get arpCacheTimeout value
     * @return string|null
     */
    public function getArpCacheTimeout()
    {
        return $this->arpCacheTimeout;
    }
    /**
     * Set arpCacheTimeout value
     * @param string $arpCacheTimeout
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setArpCacheTimeout($arpCacheTimeout = '0')
    {
        $this->arpCacheTimeout = $arpCacheTimeout;
        return $this;
    }
    /**
     * Get ipAddressLeaseTime value
     * @return string|null
     */
    public function getIpAddressLeaseTime()
    {
        return $this->ipAddressLeaseTime;
    }
    /**
     * Set ipAddressLeaseTime value
     * @param string $ipAddressLeaseTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setIpAddressLeaseTime($ipAddressLeaseTime = '0')
    {
        $this->ipAddressLeaseTime = $ipAddressLeaseTime;
        return $this;
    }
    /**
     * Get renewalTime value
     * @return string|null
     */
    public function getRenewalTime()
    {
        return $this->renewalTime;
    }
    /**
     * Set renewalTime value
     * @param string $renewalTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setRenewalTime($renewalTime = '0')
    {
        $this->renewalTime = $renewalTime;
        return $this;
    }
    /**
     * Get rebindingTime value
     * @return string|null
     */
    public function getRebindingTime()
    {
        return $this->rebindingTime;
    }
    /**
     * Set rebindingTime value
     * @param string $rebindingTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq
     */
    public function setRebindingTime($rebindingTime = '0')
    {
        $this->rebindingTime = $rebindingTime;
        return $this;
    }
}
