<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDevicePoolReq StructType
 * @subpackage Structs
 */
class UpdateDevicePoolReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: Not nullable.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The autoSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $autoSearchSpaceName;
    /**
     * The dateTimeSettingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dateTimeSettingName;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionName;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XCountry in AXLEnums.xsd
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The srstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $srstName;
    /**
     * The connectionMonitorDuration
     * Meta information extracted from the WSDL
     * - documentation: -1 means using system default
     * - default: -1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectionMonitorDuration;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Automated Alternate Routing. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - documentation: For IP Phones and Gateways. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mobilityCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Device Mobility. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobilityCssName;
    /**
     * The physicalLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $physicalLocationName;
    /**
     * The deviceMobilityGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $deviceMobilityGroupName;
    /**
     * The revertPriority
     * Meta information extracted from the WSDL
     * - documentation: The value accepted and retrieved from the database for this field will be of type XRevertPriority in AXLEnums.xsd.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $revertPriority;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The localRouteGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $localRouteGroupName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The callingPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNationalPrefix;
    /**
     * The callingPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyInternationalPrefix;
    /**
     * The callingPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyUnknownPrefix;
    /**
     * The callingPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySubscriberPrefix;
    /**
     * The adjunctCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $adjunctCallingSearchSpace;
    /**
     * The callingPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The imeEnrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * The cntdPnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The localRouteGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup[]
     */
    public $localRouteGroup;
    /**
     * The redirectingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $redirectingPartyTransformationCSS;
    /**
     * The callingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyTransformationCSS;
    /**
     * The wirelessLanProfileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * Constructor method for UpdateDevicePoolReq
     * @uses UpdateDevicePoolReq::setNewName()
     * @uses UpdateDevicePoolReq::setAutoSearchSpaceName()
     * @uses UpdateDevicePoolReq::setDateTimeSettingName()
     * @uses UpdateDevicePoolReq::setCallManagerGroupName()
     * @uses UpdateDevicePoolReq::setMediaResourceListName()
     * @uses UpdateDevicePoolReq::setRegionName()
     * @uses UpdateDevicePoolReq::setNetworkLocale()
     * @uses UpdateDevicePoolReq::setSrstName()
     * @uses UpdateDevicePoolReq::setConnectionMonitorDuration()
     * @uses UpdateDevicePoolReq::setAutomatedAlternateRoutingCssName()
     * @uses UpdateDevicePoolReq::setAarNeighborhoodName()
     * @uses UpdateDevicePoolReq::setLocationName()
     * @uses UpdateDevicePoolReq::setMobilityCssName()
     * @uses UpdateDevicePoolReq::setPhysicalLocationName()
     * @uses UpdateDevicePoolReq::setDeviceMobilityGroupName()
     * @uses UpdateDevicePoolReq::setRevertPriority()
     * @uses UpdateDevicePoolReq::setSingleButtonBarge()
     * @uses UpdateDevicePoolReq::setJoinAcrossLines()
     * @uses UpdateDevicePoolReq::setCgpnTransformationCssName()
     * @uses UpdateDevicePoolReq::setCdpnTransformationCssName()
     * @uses UpdateDevicePoolReq::setLocalRouteGroupName()
     * @uses UpdateDevicePoolReq::setGeoLocationName()
     * @uses UpdateDevicePoolReq::setGeoLocationFilterName()
     * @uses UpdateDevicePoolReq::setCallingPartyNationalPrefix()
     * @uses UpdateDevicePoolReq::setCallingPartyInternationalPrefix()
     * @uses UpdateDevicePoolReq::setCallingPartyUnknownPrefix()
     * @uses UpdateDevicePoolReq::setCallingPartySubscriberPrefix()
     * @uses UpdateDevicePoolReq::setAdjunctCallingSearchSpace()
     * @uses UpdateDevicePoolReq::setCallingPartyNationalStripDigits()
     * @uses UpdateDevicePoolReq::setCallingPartyInternationalStripDigits()
     * @uses UpdateDevicePoolReq::setCallingPartyUnknownStripDigits()
     * @uses UpdateDevicePoolReq::setCallingPartySubscriberStripDigits()
     * @uses UpdateDevicePoolReq::setCallingPartyNationalTransformationCssName()
     * @uses UpdateDevicePoolReq::setCallingPartyInternationalTransformationCssName()
     * @uses UpdateDevicePoolReq::setCallingPartyUnknownTransformationCssName()
     * @uses UpdateDevicePoolReq::setCallingPartySubscriberTransformationCssName()
     * @uses UpdateDevicePoolReq::setCalledPartyNationalPrefix()
     * @uses UpdateDevicePoolReq::setCalledPartyInternationalPrefix()
     * @uses UpdateDevicePoolReq::setCalledPartyUnknownPrefix()
     * @uses UpdateDevicePoolReq::setCalledPartySubscriberPrefix()
     * @uses UpdateDevicePoolReq::setCalledPartyNationalStripDigits()
     * @uses UpdateDevicePoolReq::setCalledPartyInternationalStripDigits()
     * @uses UpdateDevicePoolReq::setCalledPartyUnknownStripDigits()
     * @uses UpdateDevicePoolReq::setCalledPartySubscriberStripDigits()
     * @uses UpdateDevicePoolReq::setCalledPartyNationalTransformationCssName()
     * @uses UpdateDevicePoolReq::setCalledPartyInternationalTransformationCssName()
     * @uses UpdateDevicePoolReq::setCalledPartyUnknownTransformationCssName()
     * @uses UpdateDevicePoolReq::setCalledPartySubscriberTransformationCssName()
     * @uses UpdateDevicePoolReq::setImeEnrolledPatternGroupName()
     * @uses UpdateDevicePoolReq::setCntdPnTransformationCssName()
     * @uses UpdateDevicePoolReq::setLocalRouteGroup()
     * @uses UpdateDevicePoolReq::setRedirectingPartyTransformationCSS()
     * @uses UpdateDevicePoolReq::setCallingPartyTransformationCSS()
     * @uses UpdateDevicePoolReq::setWirelessLanProfileGroup()
     * @param string $newName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $autoSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dateTimeSettingName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName
     * @param string $networkLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $srstName
     * @param string $connectionMonitorDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $physicalLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceMobilityGroupName
     * @param string $revertPriority
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $localRouteGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $callingPartyNationalPrefix
     * @param string $callingPartyInternationalPrefix
     * @param string $callingPartyUnknownPrefix
     * @param string $callingPartySubscriberPrefix
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $adjunctCallingSearchSpace
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup[] $localRouteGroup
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyTransformationCSS
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup
     */
    public function __construct($newName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $autoSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dateTimeSettingName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName = null, $networkLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $srstName = null, $connectionMonitorDuration = '-1', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $physicalLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceMobilityGroupName = null, $revertPriority = 'Default', $singleButtonBarge = 'Default', $joinAcrossLines = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $localRouteGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $callingPartyNationalPrefix = null, $callingPartyInternationalPrefix = null, $callingPartyUnknownPrefix = null, $callingPartySubscriberPrefix = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $adjunctCallingSearchSpace = null, $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName = null, array $localRouteGroup = array(), \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyTransformationCSS = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup = null)
    {
        $this
            ->setNewName($newName)
            ->setAutoSearchSpaceName($autoSearchSpaceName)
            ->setDateTimeSettingName($dateTimeSettingName)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setRegionName($regionName)
            ->setNetworkLocale($networkLocale)
            ->setSrstName($srstName)
            ->setConnectionMonitorDuration($connectionMonitorDuration)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLocationName($locationName)
            ->setMobilityCssName($mobilityCssName)
            ->setPhysicalLocationName($physicalLocationName)
            ->setDeviceMobilityGroupName($deviceMobilityGroupName)
            ->setRevertPriority($revertPriority)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setLocalRouteGroupName($localRouteGroupName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setCallingPartyNationalPrefix($callingPartyNationalPrefix)
            ->setCallingPartyInternationalPrefix($callingPartyInternationalPrefix)
            ->setCallingPartyUnknownPrefix($callingPartyUnknownPrefix)
            ->setCallingPartySubscriberPrefix($callingPartySubscriberPrefix)
            ->setAdjunctCallingSearchSpace($adjunctCallingSearchSpace)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setLocalRouteGroup($localRouteGroup)
            ->setRedirectingPartyTransformationCSS($redirectingPartyTransformationCSS)
            ->setCallingPartyTransformationCSS($callingPartyTransformationCSS)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get autoSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutoSearchSpaceName()
    {
        return isset($this->autoSearchSpaceName) ? $this->autoSearchSpaceName : null;
    }
    /**
     * Set autoSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $autoSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setAutoSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $autoSearchSpaceName = null)
    {
        if (is_null($autoSearchSpaceName) || (is_array($autoSearchSpaceName) && empty($autoSearchSpaceName))) {
            unset($this->autoSearchSpaceName);
        } else {
            $this->autoSearchSpaceName = $autoSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get dateTimeSettingName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDateTimeSettingName()
    {
        return $this->dateTimeSettingName;
    }
    /**
     * Set dateTimeSettingName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dateTimeSettingName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setDateTimeSettingName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dateTimeSettingName = null)
    {
        $this->dateTimeSettingName = $dateTimeSettingName;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallManagerGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get regionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setRegionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setNetworkLocale($networkLocale = null)
    {
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get srstName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSrstName()
    {
        return $this->srstName;
    }
    /**
     * Set srstName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $srstName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setSrstName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $srstName = null)
    {
        $this->srstName = $srstName;
        return $this;
    }
    /**
     * Get connectionMonitorDuration value
     * @return string|null
     */
    public function getConnectionMonitorDuration()
    {
        return $this->connectionMonitorDuration;
    }
    /**
     * Set connectionMonitorDuration value
     * @param string $connectionMonitorDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setConnectionMonitorDuration($connectionMonitorDuration = '-1')
    {
        $this->connectionMonitorDuration = $connectionMonitorDuration;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get locationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return isset($this->locationName) ? $this->locationName : null;
    }
    /**
     * Set locationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->locationName);
        } else {
            $this->locationName = $locationName;
        }
        return $this;
    }
    /**
     * Get mobilityCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobilityCssName()
    {
        return isset($this->mobilityCssName) ? $this->mobilityCssName : null;
    }
    /**
     * Set mobilityCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setMobilityCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityCssName = null)
    {
        if (is_null($mobilityCssName) || (is_array($mobilityCssName) && empty($mobilityCssName))) {
            unset($this->mobilityCssName);
        } else {
            $this->mobilityCssName = $mobilityCssName;
        }
        return $this;
    }
    /**
     * Get physicalLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPhysicalLocationName()
    {
        return isset($this->physicalLocationName) ? $this->physicalLocationName : null;
    }
    /**
     * Set physicalLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $physicalLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setPhysicalLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $physicalLocationName = null)
    {
        if (is_null($physicalLocationName) || (is_array($physicalLocationName) && empty($physicalLocationName))) {
            unset($this->physicalLocationName);
        } else {
            $this->physicalLocationName = $physicalLocationName;
        }
        return $this;
    }
    /**
     * Get deviceMobilityGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDeviceMobilityGroupName()
    {
        return isset($this->deviceMobilityGroupName) ? $this->deviceMobilityGroupName : null;
    }
    /**
     * Set deviceMobilityGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceMobilityGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setDeviceMobilityGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceMobilityGroupName = null)
    {
        if (is_null($deviceMobilityGroupName) || (is_array($deviceMobilityGroupName) && empty($deviceMobilityGroupName))) {
            unset($this->deviceMobilityGroupName);
        } else {
            $this->deviceMobilityGroupName = $deviceMobilityGroupName;
        }
        return $this;
    }
    /**
     * Get revertPriority value
     * @return string|null
     */
    public function getRevertPriority()
    {
        return $this->revertPriority;
    }
    /**
     * Set revertPriority value
     * @param string $revertPriority
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setRevertPriority($revertPriority = 'Default')
    {
        $this->revertPriority = $revertPriority;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param string $singleButtonBarge
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param string $joinAcrossLines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get localRouteGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocalRouteGroupName()
    {
        return $this->localRouteGroupName;
    }
    /**
     * Set localRouteGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $localRouteGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setLocalRouteGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $localRouteGroupName = null)
    {
        $this->localRouteGroupName = $localRouteGroupName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalPrefix value
     * @return string|null
     */
    public function getCallingPartyNationalPrefix()
    {
        return $this->callingPartyNationalPrefix;
    }
    /**
     * Set callingPartyNationalPrefix value
     * @param string $callingPartyNationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyNationalPrefix($callingPartyNationalPrefix = null)
    {
        $this->callingPartyNationalPrefix = $callingPartyNationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyInternationalPrefix value
     * @return string|null
     */
    public function getCallingPartyInternationalPrefix()
    {
        return $this->callingPartyInternationalPrefix;
    }
    /**
     * Set callingPartyInternationalPrefix value
     * @param string $callingPartyInternationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyInternationalPrefix($callingPartyInternationalPrefix = null)
    {
        $this->callingPartyInternationalPrefix = $callingPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyUnknownPrefix value
     * @return string|null
     */
    public function getCallingPartyUnknownPrefix()
    {
        return $this->callingPartyUnknownPrefix;
    }
    /**
     * Set callingPartyUnknownPrefix value
     * @param string $callingPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyUnknownPrefix($callingPartyUnknownPrefix = null)
    {
        $this->callingPartyUnknownPrefix = $callingPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get callingPartySubscriberPrefix value
     * @return string|null
     */
    public function getCallingPartySubscriberPrefix()
    {
        return $this->callingPartySubscriberPrefix;
    }
    /**
     * Set callingPartySubscriberPrefix value
     * @param string $callingPartySubscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartySubscriberPrefix($callingPartySubscriberPrefix = null)
    {
        $this->callingPartySubscriberPrefix = $callingPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get adjunctCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAdjunctCallingSearchSpace()
    {
        return isset($this->adjunctCallingSearchSpace) ? $this->adjunctCallingSearchSpace : null;
    }
    /**
     * Set adjunctCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $adjunctCallingSearchSpace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setAdjunctCallingSearchSpace(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $adjunctCallingSearchSpace = null)
    {
        if (is_null($adjunctCallingSearchSpace) || (is_array($adjunctCallingSearchSpace) && empty($adjunctCallingSearchSpace))) {
            unset($this->adjunctCallingSearchSpace);
        } else {
            $this->adjunctCallingSearchSpace = $adjunctCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return isset($this->callingPartyNationalStripDigits) ? $this->callingPartyNationalStripDigits : null;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyNationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        if (is_null($callingPartyNationalStripDigits) || (is_array($callingPartyNationalStripDigits) && empty($callingPartyNationalStripDigits))) {
            unset($this->callingPartyNationalStripDigits);
        } else {
            $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return isset($this->callingPartyInternationalStripDigits) ? $this->callingPartyInternationalStripDigits : null;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyInternationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        if (is_null($callingPartyInternationalStripDigits) || (is_array($callingPartyInternationalStripDigits) && empty($callingPartyInternationalStripDigits))) {
            unset($this->callingPartyInternationalStripDigits);
        } else {
            $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return isset($this->callingPartyUnknownStripDigits) ? $this->callingPartyUnknownStripDigits : null;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        if (is_null($callingPartyUnknownStripDigits) || (is_array($callingPartyUnknownStripDigits) && empty($callingPartyUnknownStripDigits))) {
            unset($this->callingPartyUnknownStripDigits);
        } else {
            $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return isset($this->callingPartySubscriberStripDigits) ? $this->callingPartySubscriberStripDigits : null;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartySubscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        if (is_null($callingPartySubscriberStripDigits) || (is_array($callingPartySubscriberStripDigits) && empty($callingPartySubscriberStripDigits))) {
            unset($this->callingPartySubscriberStripDigits);
        } else {
            $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return isset($this->callingPartyNationalTransformationCssName) ? $this->callingPartyNationalTransformationCssName : null;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName = null)
    {
        if (is_null($callingPartyNationalTransformationCssName) || (is_array($callingPartyNationalTransformationCssName) && empty($callingPartyNationalTransformationCssName))) {
            unset($this->callingPartyNationalTransformationCssName);
        } else {
            $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return isset($this->callingPartyInternationalTransformationCssName) ? $this->callingPartyInternationalTransformationCssName : null;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName = null)
    {
        if (is_null($callingPartyInternationalTransformationCssName) || (is_array($callingPartyInternationalTransformationCssName) && empty($callingPartyInternationalTransformationCssName))) {
            unset($this->callingPartyInternationalTransformationCssName);
        } else {
            $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return isset($this->callingPartyUnknownTransformationCssName) ? $this->callingPartyUnknownTransformationCssName : null;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        if (is_null($callingPartyUnknownTransformationCssName) || (is_array($callingPartyUnknownTransformationCssName) && empty($callingPartyUnknownTransformationCssName))) {
            unset($this->callingPartyUnknownTransformationCssName);
        } else {
            $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return isset($this->callingPartySubscriberTransformationCssName) ? $this->callingPartySubscriberTransformationCssName : null;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartySubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName = null)
    {
        if (is_null($callingPartySubscriberTransformationCssName) || (is_array($callingPartySubscriberTransformationCssName) && empty($callingPartySubscriberTransformationCssName))) {
            unset($this->callingPartySubscriberTransformationCssName);
        } else {
            $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return isset($this->calledPartyNationalStripDigits) ? $this->calledPartyNationalStripDigits : null;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyNationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        if (is_null($calledPartyNationalStripDigits) || (is_array($calledPartyNationalStripDigits) && empty($calledPartyNationalStripDigits))) {
            unset($this->calledPartyNationalStripDigits);
        } else {
            $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return isset($this->calledPartyInternationalStripDigits) ? $this->calledPartyInternationalStripDigits : null;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyInternationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        if (is_null($calledPartyInternationalStripDigits) || (is_array($calledPartyInternationalStripDigits) && empty($calledPartyInternationalStripDigits))) {
            unset($this->calledPartyInternationalStripDigits);
        } else {
            $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return isset($this->calledPartySubscriberStripDigits) ? $this->calledPartySubscriberStripDigits : null;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartySubscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        if (is_null($calledPartySubscriberStripDigits) || (is_array($calledPartySubscriberStripDigits) && empty($calledPartySubscriberStripDigits))) {
            unset($this->calledPartySubscriberStripDigits);
        } else {
            $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return isset($this->calledPartyNationalTransformationCssName) ? $this->calledPartyNationalTransformationCssName : null;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        if (is_null($calledPartyNationalTransformationCssName) || (is_array($calledPartyNationalTransformationCssName) && empty($calledPartyNationalTransformationCssName))) {
            unset($this->calledPartyNationalTransformationCssName);
        } else {
            $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return isset($this->calledPartyInternationalTransformationCssName) ? $this->calledPartyInternationalTransformationCssName : null;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        if (is_null($calledPartyInternationalTransformationCssName) || (is_array($calledPartyInternationalTransformationCssName) && empty($calledPartyInternationalTransformationCssName))) {
            unset($this->calledPartyInternationalTransformationCssName);
        } else {
            $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return isset($this->calledPartySubscriberTransformationCssName) ? $this->calledPartySubscriberTransformationCssName : null;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCalledPartySubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        if (is_null($calledPartySubscriberTransformationCssName) || (is_array($calledPartySubscriberTransformationCssName) && empty($calledPartySubscriberTransformationCssName))) {
            unset($this->calledPartySubscriberTransformationCssName);
        } else {
            $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return isset($this->imeEnrolledPatternGroupName) ? $this->imeEnrolledPatternGroupName : null;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setImeEnrolledPatternGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        if (is_null($imeEnrolledPatternGroupName) || (is_array($imeEnrolledPatternGroupName) && empty($imeEnrolledPatternGroupName))) {
            unset($this->imeEnrolledPatternGroupName);
        } else {
            $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        }
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCntdPnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get localRouteGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup[]|null
     */
    public function getLocalRouteGroup()
    {
        return $this->localRouteGroup;
    }
    /**
     * Set localRouteGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup[] $localRouteGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setLocalRouteGroup(array $localRouteGroup = array())
    {
        $this->localRouteGroup = $localRouteGroup;
        return $this;
    }
    /**
     * Add item to localRouteGroup value
     * @throws \InvalidArgumentException
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup $item
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function addToLocalRouteGroup(\\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup $item)
    {
        $this->localRouteGroup[] = $item;
        return $this;
    }
    /**
     * Get redirectingPartyTransformationCSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRedirectingPartyTransformationCSS()
    {
        return isset($this->redirectingPartyTransformationCSS) ? $this->redirectingPartyTransformationCSS : null;
    }
    /**
     * Set redirectingPartyTransformationCSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setRedirectingPartyTransformationCSS(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS = null)
    {
        if (is_null($redirectingPartyTransformationCSS) || (is_array($redirectingPartyTransformationCSS) && empty($redirectingPartyTransformationCSS))) {
            unset($this->redirectingPartyTransformationCSS);
        } else {
            $this->redirectingPartyTransformationCSS = $redirectingPartyTransformationCSS;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationCSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyTransformationCSS()
    {
        return isset($this->callingPartyTransformationCSS) ? $this->callingPartyTransformationCSS : null;
    }
    /**
     * Set callingPartyTransformationCSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyTransformationCSS
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setCallingPartyTransformationCSS(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyTransformationCSS = null)
    {
        if (is_null($callingPartyTransformationCSS) || (is_array($callingPartyTransformationCSS) && empty($callingPartyTransformationCSS))) {
            unset($this->callingPartyTransformationCSS);
        } else {
            $this->callingPartyTransformationCSS = $callingPartyTransformationCSS;
        }
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return isset($this->wirelessLanProfileGroup) ? $this->wirelessLanProfileGroup : null;
    }
    /**
     * Set wirelessLanProfileGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq
     */
    public function setWirelessLanProfileGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup = null)
    {
        if (is_null($wirelessLanProfileGroup) || (is_array($wirelessLanProfileGroup) && empty($wirelessLanProfileGroup))) {
            unset($this->wirelessLanProfileGroup);
        } else {
            $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        }
        return $this;
    }
}
