<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomUserFieldReq StructType
 * @subpackage Structs
 */
class UpdateCustomUserFieldReq extends APIRequest
{
    /**
     * The field
     * Meta information extracted from the WSDL
     * - choice: uuid | field
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $field;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | field
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newField
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newField;
    /**
     * Constructor method for UpdateCustomUserFieldReq
     * @uses UpdateCustomUserFieldReq::setField()
     * @uses UpdateCustomUserFieldReq::setUuid()
     * @uses UpdateCustomUserFieldReq::setNewField()
     * @param string $field
     * @param string $uuid
     * @param string $newField
     */
    public function __construct($field = null, $uuid = null, $newField = null)
    {
        $this
            ->setField($field)
            ->setUuid($uuid)
            ->setNewField($newField);
    }
    /**
     * Get field value
     * @return string
     */
    public function getField()
    {
        return isset($this->field) ? $this->field : null;
    }
    /**
     * Set field value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $field
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCustomUserFieldReq
     */
    public function setField($field = null)
    {
        if (is_null($field) || (is_array($field) && empty($field))) {
            unset($this->field);
        } else {
            $this->field = $field;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCustomUserFieldReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newField value
     * @return string|null
     */
    public function getNewField()
    {
        return $this->newField;
    }
    /**
     * Set newField value
     * @param string $newField
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCustomUserFieldReq
     */
    public function setNewField($newField = null)
    {
        $this->newField = $newField;
        return $this;
    }
}
