<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateApplicationServerReq StructType
 * @subpackage Structs
 */
class UpdateApplicationServerReq extends APIRequest
{
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The removeAppUsers
     * Meta information extracted from the WSDL
     * - choice: removeAppUsers | addAppUsers | appUsers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppUsers
     */
    public $removeAppUsers;
    /**
     * The addAppUsers
     * Meta information extracted from the WSDL
     * - choice: removeAppUsers | addAppUsers | appUsers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddAppUsers
     */
    public $addAppUsers;
    /**
     * The appUsers
     * Meta information extracted from the WSDL
     * - choice: removeAppUsers | addAppUsers | appUsers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers
     */
    public $appUsers;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $url;
    /**
     * The endUserUrl
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server, CER Location Management
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endUserUrl;
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - documentation: Applicable Only for Cisco Web dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The removeEndUsers
     * Meta information extracted from the WSDL
     * - choice: removeEndUsers | addEndUsers | endUsers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RemoveEndUsers
     */
    public $removeEndUsers;
    /**
     * The addEndUsers
     * Meta information extracted from the WSDL
     * - choice: removeEndUsers | addEndUsers | endUsers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddEndUsers
     */
    public $addEndUsers;
    /**
     * The endUsers
     * Meta information extracted from the WSDL
     * - choice: removeEndUsers | addEndUsers | endUsers
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers
     */
    public $endUsers;
    /**
     * Constructor method for UpdateApplicationServerReq
     * @uses UpdateApplicationServerReq::setUuid()
     * @uses UpdateApplicationServerReq::setNewName()
     * @uses UpdateApplicationServerReq::setIpAddress()
     * @uses UpdateApplicationServerReq::setRemoveAppUsers()
     * @uses UpdateApplicationServerReq::setAddAppUsers()
     * @uses UpdateApplicationServerReq::setAppUsers()
     * @uses UpdateApplicationServerReq::setUrl()
     * @uses UpdateApplicationServerReq::setEndUserUrl()
     * @uses UpdateApplicationServerReq::setProcessNodeName()
     * @uses UpdateApplicationServerReq::setRemoveEndUsers()
     * @uses UpdateApplicationServerReq::setAddEndUsers()
     * @uses UpdateApplicationServerReq::setEndUsers()
     * @param string $uuid
     * @param string $newName
     * @param string $ipAddress
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppUsers $removeAppUsers
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddAppUsers $addAppUsers
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers
     * @param string $url
     * @param string $endUserUrl
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveEndUsers $removeEndUsers
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddEndUsers $addEndUsers
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers
     */
    public function __construct($uuid = null, $newName = null, $ipAddress = null, \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppUsers $removeAppUsers = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddAppUsers $addAppUsers = null, \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers = null, $url = null, $endUserUrl = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, \\Losc\CucmBundle\Model\Webservice\StructType\RemoveEndUsers $removeEndUsers = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddEndUsers $addEndUsers = null, \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers = null)
    {
        $this
            ->setUuid($uuid)
            ->setNewName($newName)
            ->setIpAddress($ipAddress)
            ->setRemoveAppUsers($removeAppUsers)
            ->setAddAppUsers($addAppUsers)
            ->setAppUsers($appUsers)
            ->setUrl($url)
            ->setEndUserUrl($endUserUrl)
            ->setProcessNodeName($processNodeName)
            ->setRemoveEndUsers($removeEndUsers)
            ->setAddEndUsers($addEndUsers)
            ->setEndUsers($endUsers);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get removeAppUsers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppUsers|null
     */
    public function getRemoveAppUsers()
    {
        return isset($this->removeAppUsers) ? $this->removeAppUsers : null;
    }
    /**
     * Set removeAppUsers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppUsers $removeAppUsers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setRemoveAppUsers(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppUsers $removeAppUsers = null)
    {
        if (is_null($removeAppUsers) || (is_array($removeAppUsers) && empty($removeAppUsers))) {
            unset($this->removeAppUsers);
        } else {
            $this->removeAppUsers = $removeAppUsers;
        }
        return $this;
    }
    /**
     * Get addAppUsers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddAppUsers|null
     */
    public function getAddAppUsers()
    {
        return isset($this->addAppUsers) ? $this->addAppUsers : null;
    }
    /**
     * Set addAppUsers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddAppUsers $addAppUsers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setAddAppUsers(\\Losc\CucmBundle\Model\Webservice\StructType\AddAppUsers $addAppUsers = null)
    {
        if (is_null($addAppUsers) || (is_array($addAppUsers) && empty($addAppUsers))) {
            unset($this->addAppUsers);
        } else {
            $this->addAppUsers = $addAppUsers;
        }
        return $this;
    }
    /**
     * Get appUsers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers|null
     */
    public function getAppUsers()
    {
        return isset($this->appUsers) ? $this->appUsers : null;
    }
    /**
     * Set appUsers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setAppUsers(\\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers = null)
    {
        if (is_null($appUsers) || (is_array($appUsers) && empty($appUsers))) {
            unset($this->appUsers);
        } else {
            $this->appUsers = $appUsers;
        }
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setUrl($url = null)
    {
        $this->url = $url;
        return $this;
    }
    /**
     * Get endUserUrl value
     * @return string|null
     */
    public function getEndUserUrl()
    {
        return $this->endUserUrl;
    }
    /**
     * Set endUserUrl value
     * @param string $endUserUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setEndUserUrl($endUserUrl = null)
    {
        $this->endUserUrl = $endUserUrl;
        return $this;
    }
    /**
     * Get processNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * Set processNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setProcessNodeName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get removeEndUsers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveEndUsers|null
     */
    public function getRemoveEndUsers()
    {
        return isset($this->removeEndUsers) ? $this->removeEndUsers : null;
    }
    /**
     * Set removeEndUsers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveEndUsers $removeEndUsers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setRemoveEndUsers(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveEndUsers $removeEndUsers = null)
    {
        if (is_null($removeEndUsers) || (is_array($removeEndUsers) && empty($removeEndUsers))) {
            unset($this->removeEndUsers);
        } else {
            $this->removeEndUsers = $removeEndUsers;
        }
        return $this;
    }
    /**
     * Get addEndUsers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddEndUsers|null
     */
    public function getAddEndUsers()
    {
        return isset($this->addEndUsers) ? $this->addEndUsers : null;
    }
    /**
     * Set addEndUsers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddEndUsers $addEndUsers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setAddEndUsers(\\Losc\CucmBundle\Model\Webservice\StructType\AddEndUsers $addEndUsers = null)
    {
        if (is_null($addEndUsers) || (is_array($addEndUsers) && empty($addEndUsers))) {
            unset($this->addEndUsers);
        } else {
            $this->addEndUsers = $addEndUsers;
        }
        return $this;
    }
    /**
     * Get endUsers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers|null
     */
    public function getEndUsers()
    {
        return isset($this->endUsers) ? $this->endUsers : null;
    }
    /**
     * Set endUsers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq
     */
    public function setEndUsers(\\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers = null)
    {
        if (is_null($endUsers) || (is_array($endUsers) && empty($endUsers))) {
            unset($this->endUsers);
        } else {
            $this->endUsers = $endUsers;
        }
        return $this;
    }
}
