<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAdvertisedPatternsReq StructType
 * @subpackage Structs
 */
class UpdateAdvertisedPatternsReq extends APIRequest
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The patternType
     * Meta information extracted from the WSDL
     * - default: Enterprise Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternType;
    /**
     * The hostedRoutePSTNRule
     * Meta information extracted from the WSDL
     * - default: Specify
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostedRoutePSTNRule;
    /**
     * The pstnFailStrip
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailStrip;
    /**
     * The pstnFailPrepend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailPrepend;
    /**
     * Constructor method for UpdateAdvertisedPatternsReq
     * @uses UpdateAdvertisedPatternsReq::setPattern()
     * @uses UpdateAdvertisedPatternsReq::setUuid()
     * @uses UpdateAdvertisedPatternsReq::setDescription()
     * @uses UpdateAdvertisedPatternsReq::setNewPattern()
     * @uses UpdateAdvertisedPatternsReq::setPatternType()
     * @uses UpdateAdvertisedPatternsReq::setHostedRoutePSTNRule()
     * @uses UpdateAdvertisedPatternsReq::setPstnFailStrip()
     * @uses UpdateAdvertisedPatternsReq::setPstnFailPrepend()
     * @param string $pattern
     * @param string $uuid
     * @param string $description
     * @param string $newPattern
     * @param string $patternType
     * @param string $hostedRoutePSTNRule
     * @param string $pstnFailStrip
     * @param string $pstnFailPrepend
     */
    public function __construct($pattern = null, $uuid = null, $description = null, $newPattern = null, $patternType = 'Enterprise Number', $hostedRoutePSTNRule = 'Specify', $pstnFailStrip = '0', $pstnFailPrepend = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setDescription($description)
            ->setNewPattern($newPattern)
            ->setPatternType($patternType)
            ->setHostedRoutePSTNRule($hostedRoutePSTNRule)
            ->setPstnFailStrip($pstnFailStrip)
            ->setPstnFailPrepend($pstnFailPrepend);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq
     */
    public function setPattern($pattern = null)
    {
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq
     */
    public function setNewPattern($newPattern = null)
    {
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get patternType value
     * @return string|null
     */
    public function getPatternType()
    {
        return $this->patternType;
    }
    /**
     * Set patternType value
     * @param string $patternType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq
     */
    public function setPatternType($patternType = 'Enterprise Number')
    {
        $this->patternType = $patternType;
        return $this;
    }
    /**
     * Get hostedRoutePSTNRule value
     * @return string|null
     */
    public function getHostedRoutePSTNRule()
    {
        return $this->hostedRoutePSTNRule;
    }
    /**
     * Set hostedRoutePSTNRule value
     * @param string $hostedRoutePSTNRule
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq
     */
    public function setHostedRoutePSTNRule($hostedRoutePSTNRule = 'Specify')
    {
        $this->hostedRoutePSTNRule = $hostedRoutePSTNRule;
        return $this;
    }
    /**
     * Get pstnFailStrip value
     * @return string|null
     */
    public function getPstnFailStrip()
    {
        return $this->pstnFailStrip;
    }
    /**
     * Set pstnFailStrip value
     * @param string $pstnFailStrip
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq
     */
    public function setPstnFailStrip($pstnFailStrip = '0')
    {
        $this->pstnFailStrip = $pstnFailStrip;
        return $this;
    }
    /**
     * Get pstnFailPrepend value
     * @return string|null
     */
    public function getPstnFailPrepend()
    {
        return $this->pstnFailPrepend;
    }
    /**
     * Set pstnFailPrepend value
     * @param string $pstnFailPrepend
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq
     */
    public function setPstnFailPrepend($pstnFailPrepend = null)
    {
        $this->pstnFailPrepend = $pstnFailPrepend;
        return $this;
    }
}
