<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchCriteria StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify Search Criterion | At least one element under searchCriteria has to be mentioned
 * @subpackage Structs
 */
class SearchCriteria extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters | The template's name | From Device Table | Actually called "tag" in database. | From Device table. | Should not be modified for Cisco Media Termination Point (WS-SVC-CMM). | Not
     * nullable. | The primary hostname of the process node.
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device | From Device Table | From Device table.
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The ownerIdName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ownerIdName;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dirn;
    /**
     * The cssName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cssName;
    /**
     * The processNodeRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $processNodeRole;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callManagerGroupName;
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regionName;
    /**
     * The namespace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $namespace;
    /**
     * The subNet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subNet;
    /**
     * The subNetMaskSz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subNetMaskSz;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The authorizationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authorizationLevel;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The recordingCssName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recordingCssName;
    /**
     * The recorderDestination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recorderDestination;
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - documentation: The process Node that this the service parameter belongs to. Not nullable.
     * - minOccurs: 0
     * @var string
     */
    public $processNodeName;
    /**
     * The sourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceId;
    /**
     * The primaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $primaryDnsIpAddress;
    /**
     * The secondaryDnsIpAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $secondaryDnsIpAddress;
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The dhcpServerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dhcpServerName;
    /**
     * The subnetIpAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subnetIpAddress;
    /**
     * The primaryStartIpAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $primaryStartIpAddress;
    /**
     * The primaryEndIpAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $primaryEndIpAddress;
    /**
     * The secondaryStartIpAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $secondaryStartIpAddress;
    /**
     * The secondaryEndIpAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $secondaryEndIpAddress;
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $routePartitionName;
    /**
     * The callManagerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callManagerName;
    /**
     * The reversionPattern
     * Meta information extracted from the WSDL
     * - documentation: The pattern used to revert the call when the parked call is not retrieved within retrieval timer.
     * - minOccurs: 0
     * @var string
     */
    public $reversionPattern;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The realm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $realm;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
     * - minOccurs: 0
     * @var string
     */
    public $ipAddress;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applicationUser;
    /**
     * The instanceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $instanceId;
    /**
     * The endUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endUserId;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - documentation: The service that this service parameter belongs to.
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - documentation: UUID changed each time device is updated
     * - minOccurs: 0
     * @var string
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $devicePoolName;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $securityProfileName;
    /**
     * The dnPattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dnPattern;
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceName;
    /**
     * The serviceDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceDescription;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanName;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $routeFilterName;
    /**
     * The dnOrPatternIpv6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dnOrPatternIpv6;
    /**
     * The numberBeginWith
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberBeginWith;
    /**
     * The dialPattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dialPattern;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The remoteDestinationProfileName
     * Meta information extracted from the WSDL
     * - documentation: If you are giving value to dualModeDeviceName then you can't give value to remoteDestinationProfileName,viceversa
     * - minOccurs: 0
     * @var string
     */
    public $remoteDestinationProfileName;
    /**
     * The ctiRemoteDeviceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ctiRemoteDeviceName;
    /**
     * The dualModeDeviceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dualModeDeviceName;
    /**
     * The dnOrPattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dnOrPattern;
    /**
     * The partition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $partition;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The hostedPattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hostedPattern;
    /**
     * The clusterId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $clusterId;
    /**
     * The ldapDn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ldapDn;
    /**
     * The userSearchBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userSearchBase;
    /**
     * The learnedPattern
     * Meta information extracted from the WSDL
     * - documentation: Either learnedPattern or learnedPatternPrefix has to be set
     * - minOccurs: 0
     * @var string
     */
    public $learnedPattern;
    /**
     * The learnedPatternPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The callControlIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callControlIdentity;
    /**
     * The domain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The imeEnrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imeEnrolledPatternGroupName;
    /**
     * The imeExclusionNumberGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imeExclusionNumberGroupName;
    /**
     * The filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filter;
    /**
     * The subjectName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subjectName;
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumber;
    /**
     * The timeToLive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeToLive;
    /**
     * The directorynumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $directorynumber;
    /**
     * The field
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $field;
    /**
     * The hostName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hostName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The routeString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $routeString;
    /**
     * The defaultVideoStreamId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $defaultVideoStreamId;
    /**
     * The ldapConfigName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ldapConfigName;
    /**
     * The ldapManagerDisgName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ldapManagerDisgName;
    /**
     * The ldapUserSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ldapUserSearch;
    /**
     * The ccaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccaId;
    /**
     * The primarySoftSwitchId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $primarySoftSwitchId;
    /**
     * The deviceDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deviceDescription;
    /**
     * The server
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $server;
    /**
     * The presenceRedundancyGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $presenceRedundancyGroup;
    /**
     * The ssidPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ssidPrefix;
    /**
     * The authenticationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMethod;
    /**
     * The ssid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ssid;
    /**
     * The networkAccessProfile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $networkAccessProfile;
    /**
     * The lineDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lineDescription;
    /**
     * The ldapConfigurationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ldapConfigurationName;
    /**
     * Constructor method for searchCriteria
     * @uses SearchCriteria::setName()
     * @uses SearchCriteria::setDescription()
     * @uses SearchCriteria::setOwnerIdName()
     * @uses SearchCriteria::setDirn()
     * @uses SearchCriteria::setCssName()
     * @uses SearchCriteria::setProcessNodeRole()
     * @uses SearchCriteria::setCallManagerGroupName()
     * @uses SearchCriteria::setRegionName()
     * @uses SearchCriteria::setNamespace()
     * @uses SearchCriteria::setSubNet()
     * @uses SearchCriteria::setSubNetMaskSz()
     * @uses SearchCriteria::setCode()
     * @uses SearchCriteria::setAuthorizationLevel()
     * @uses SearchCriteria::setUserLocale()
     * @uses SearchCriteria::setRecordingCssName()
     * @uses SearchCriteria::setRecorderDestination()
     * @uses SearchCriteria::setProcessNodeName()
     * @uses SearchCriteria::setSourceId()
     * @uses SearchCriteria::setPrimaryDnsIpAddress()
     * @uses SearchCriteria::setSecondaryDnsIpAddress()
     * @uses SearchCriteria::setDomainName()
     * @uses SearchCriteria::setDhcpServerName()
     * @uses SearchCriteria::setSubnetIpAddress()
     * @uses SearchCriteria::setPrimaryStartIpAddress()
     * @uses SearchCriteria::setPrimaryEndIpAddress()
     * @uses SearchCriteria::setSecondaryStartIpAddress()
     * @uses SearchCriteria::setSecondaryEndIpAddress()
     * @uses SearchCriteria::setPattern()
     * @uses SearchCriteria::setRoutePartitionName()
     * @uses SearchCriteria::setCallManagerName()
     * @uses SearchCriteria::setReversionPattern()
     * @uses SearchCriteria::setFirstName()
     * @uses SearchCriteria::setLastName()
     * @uses SearchCriteria::setUserid()
     * @uses SearchCriteria::setDepartment()
     * @uses SearchCriteria::setRealm()
     * @uses SearchCriteria::setIpAddress()
     * @uses SearchCriteria::setTimeZone()
     * @uses SearchCriteria::setApplicationUser()
     * @uses SearchCriteria::setInstanceId()
     * @uses SearchCriteria::setEndUserId()
     * @uses SearchCriteria::setService()
     * @uses SearchCriteria::setCallingSearchSpaceName()
     * @uses SearchCriteria::setDevicePoolName()
     * @uses SearchCriteria::setSecurityProfileName()
     * @uses SearchCriteria::setDnPattern()
     * @uses SearchCriteria::setServiceName()
     * @uses SearchCriteria::setServiceDescription()
     * @uses SearchCriteria::setDialPlanName()
     * @uses SearchCriteria::setRouteFilterName()
     * @uses SearchCriteria::setDnOrPatternIpv6()
     * @uses SearchCriteria::setNumberBeginWith()
     * @uses SearchCriteria::setDialPattern()
     * @uses SearchCriteria::setUsage()
     * @uses SearchCriteria::setProtocol()
     * @uses SearchCriteria::setRemoteDestinationProfileName()
     * @uses SearchCriteria::setCtiRemoteDeviceName()
     * @uses SearchCriteria::setDualModeDeviceName()
     * @uses SearchCriteria::setDnOrPattern()
     * @uses SearchCriteria::setPartition()
     * @uses SearchCriteria::setType()
     * @uses SearchCriteria::setHostedPattern()
     * @uses SearchCriteria::setClusterId()
     * @uses SearchCriteria::setLdapDn()
     * @uses SearchCriteria::setUserSearchBase()
     * @uses SearchCriteria::setLearnedPattern()
     * @uses SearchCriteria::setLearnedPatternPrefix()
     * @uses SearchCriteria::setCallControlIdentity()
     * @uses SearchCriteria::setDomain()
     * @uses SearchCriteria::setImeEnrolledPatternGroupName()
     * @uses SearchCriteria::setImeExclusionNumberGroupName()
     * @uses SearchCriteria::setFilter()
     * @uses SearchCriteria::setSubjectName()
     * @uses SearchCriteria::setIssuerName()
     * @uses SearchCriteria::setSerialNumber()
     * @uses SearchCriteria::setTimeToLive()
     * @uses SearchCriteria::setDirectorynumber()
     * @uses SearchCriteria::setField()
     * @uses SearchCriteria::setHostName()
     * @uses SearchCriteria::setDescription_1()
     * @uses SearchCriteria::setRouteString()
     * @uses SearchCriteria::setDefaultVideoStreamId()
     * @uses SearchCriteria::setLdapConfigName()
     * @uses SearchCriteria::setLdapManagerDisgName()
     * @uses SearchCriteria::setLdapUserSearch()
     * @uses SearchCriteria::setCcaId()
     * @uses SearchCriteria::setPrimarySoftSwitchId()
     * @uses SearchCriteria::setDeviceDescription()
     * @uses SearchCriteria::setServer()
     * @uses SearchCriteria::setPresenceRedundancyGroup()
     * @uses SearchCriteria::setSsidPrefix()
     * @uses SearchCriteria::setAuthenticationMethod()
     * @uses SearchCriteria::setSsid()
     * @uses SearchCriteria::setNetworkAccessProfile()
     * @uses SearchCriteria::setLineDescription()
     * @uses SearchCriteria::setLdapConfigurationName()
     * @param string $name
     * @param string $description
     * @param string $ownerIdName
     * @param string $dirn
     * @param string $cssName
     * @param string $processNodeRole
     * @param string $callManagerGroupName
     * @param string $regionName
     * @param string $namespace
     * @param string $subNet
     * @param string $subNetMaskSz
     * @param string $code
     * @param string $authorizationLevel
     * @param string $userLocale
     * @param string $recordingCssName
     * @param string $recorderDestination
     * @param string $processNodeName
     * @param string $sourceId
     * @param string $primaryDnsIpAddress
     * @param string $secondaryDnsIpAddress
     * @param string $domainName
     * @param string $dhcpServerName
     * @param string $subnetIpAddress
     * @param string $primaryStartIpAddress
     * @param string $primaryEndIpAddress
     * @param string $secondaryStartIpAddress
     * @param string $secondaryEndIpAddress
     * @param string $pattern
     * @param string $routePartitionName
     * @param string $callManagerName
     * @param string $reversionPattern
     * @param string $firstName
     * @param string $lastName
     * @param string $userid
     * @param string $department
     * @param string $realm
     * @param string $ipAddress
     * @param string $timeZone
     * @param string $applicationUser
     * @param string $instanceId
     * @param string $endUserId
     * @param string $service
     * @param string $callingSearchSpaceName
     * @param string $devicePoolName
     * @param string $securityProfileName
     * @param string $dnPattern
     * @param string $serviceName
     * @param string $serviceDescription
     * @param string $dialPlanName
     * @param string $routeFilterName
     * @param string $dnOrPatternIpv6
     * @param string $numberBeginWith
     * @param string $dialPattern
     * @param string $usage
     * @param string $protocol
     * @param string $remoteDestinationProfileName
     * @param string $ctiRemoteDeviceName
     * @param string $dualModeDeviceName
     * @param string $dnOrPattern
     * @param string $partition
     * @param string $type
     * @param string $hostedPattern
     * @param string $clusterId
     * @param string $ldapDn
     * @param string $userSearchBase
     * @param string $learnedPattern
     * @param string $learnedPatternPrefix
     * @param string $callControlIdentity
     * @param string $domain
     * @param string $imeEnrolledPatternGroupName
     * @param string $imeExclusionNumberGroupName
     * @param string $filter
     * @param string $subjectName
     * @param string $issuerName
     * @param string $serialNumber
     * @param string $timeToLive
     * @param string $directorynumber
     * @param string $field
     * @param string $hostName
     * @param string $description
     * @param string $routeString
     * @param string $defaultVideoStreamId
     * @param string $ldapConfigName
     * @param string $ldapManagerDisgName
     * @param string $ldapUserSearch
     * @param string $ccaId
     * @param string $primarySoftSwitchId
     * @param string $deviceDescription
     * @param string $server
     * @param string $presenceRedundancyGroup
     * @param string $ssidPrefix
     * @param string $authenticationMethod
     * @param string $ssid
     * @param string $networkAccessProfile
     * @param string $lineDescription
     * @param string $ldapConfigurationName
     */
    public function __construct($name = null, $description = null, $ownerIdName = null, $dirn = null, $cssName = null, $processNodeRole = null, $callManagerGroupName = null, $regionName = null, $namespace = null, $subNet = null, $subNetMaskSz = null, $code = null, $authorizationLevel = null, $userLocale = null, $recordingCssName = null, $recorderDestination = null, $processNodeName = null, $sourceId = null, $primaryDnsIpAddress = null, $secondaryDnsIpAddress = null, $domainName = null, $dhcpServerName = null, $subnetIpAddress = null, $primaryStartIpAddress = null, $primaryEndIpAddress = null, $secondaryStartIpAddress = null, $secondaryEndIpAddress = null, $pattern = null, $routePartitionName = null, $callManagerName = null, $reversionPattern = null, $firstName = null, $lastName = null, $userid = null, $department = null, $realm = null, $ipAddress = null, $timeZone = null, $applicationUser = null, $instanceId = null, $endUserId = null, $service = null, $callingSearchSpaceName = null, $devicePoolName = null, $securityProfileName = null, $dnPattern = null, $serviceName = null, $serviceDescription = null, $dialPlanName = null, $routeFilterName = null, $dnOrPatternIpv6 = null, $numberBeginWith = null, $dialPattern = null, $usage = null, $protocol = null, $remoteDestinationProfileName = null, $ctiRemoteDeviceName = null, $dualModeDeviceName = null, $dnOrPattern = null, $partition = null, $type = null, $hostedPattern = null, $clusterId = null, $ldapDn = null, $userSearchBase = null, $learnedPattern = null, $learnedPatternPrefix = null, $callControlIdentity = null, $domain = null, $imeEnrolledPatternGroupName = null, $imeExclusionNumberGroupName = null, $filter = null, $subjectName = null, $issuerName = null, $serialNumber = null, $timeToLive = null, $directorynumber = null, $field = null, $hostName = null, $description_1 = null, $routeString = null, $defaultVideoStreamId = null, $ldapConfigName = null, $ldapManagerDisgName = null, $ldapUserSearch = null, $ccaId = null, $primarySoftSwitchId = null, $deviceDescription = null, $server = null, $presenceRedundancyGroup = null, $ssidPrefix = null, $authenticationMethod = null, $ssid = null, $networkAccessProfile = null, $lineDescription = null, $ldapConfigurationName = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setOwnerIdName($ownerIdName)
            ->setDirn($dirn)
            ->setCssName($cssName)
            ->setProcessNodeRole($processNodeRole)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setRegionName($regionName)
            ->setNamespace($namespace)
            ->setSubNet($subNet)
            ->setSubNetMaskSz($subNetMaskSz)
            ->setCode($code)
            ->setAuthorizationLevel($authorizationLevel)
            ->setUserLocale($userLocale)
            ->setRecordingCssName($recordingCssName)
            ->setRecorderDestination($recorderDestination)
            ->setProcessNodeName($processNodeName)
            ->setSourceId($sourceId)
            ->setPrimaryDnsIpAddress($primaryDnsIpAddress)
            ->setSecondaryDnsIpAddress($secondaryDnsIpAddress)
            ->setDomainName($domainName)
            ->setDhcpServerName($dhcpServerName)
            ->setSubnetIpAddress($subnetIpAddress)
            ->setPrimaryStartIpAddress($primaryStartIpAddress)
            ->setPrimaryEndIpAddress($primaryEndIpAddress)
            ->setSecondaryStartIpAddress($secondaryStartIpAddress)
            ->setSecondaryEndIpAddress($secondaryEndIpAddress)
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setCallManagerName($callManagerName)
            ->setReversionPattern($reversionPattern)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setUserid($userid)
            ->setDepartment($department)
            ->setRealm($realm)
            ->setIpAddress($ipAddress)
            ->setTimeZone($timeZone)
            ->setApplicationUser($applicationUser)
            ->setInstanceId($instanceId)
            ->setEndUserId($endUserId)
            ->setService($service)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setSecurityProfileName($securityProfileName)
            ->setDnPattern($dnPattern)
            ->setServiceName($serviceName)
            ->setServiceDescription($serviceDescription)
            ->setDialPlanName($dialPlanName)
            ->setRouteFilterName($routeFilterName)
            ->setDnOrPatternIpv6($dnOrPatternIpv6)
            ->setNumberBeginWith($numberBeginWith)
            ->setDialPattern($dialPattern)
            ->setUsage($usage)
            ->setProtocol($protocol)
            ->setRemoteDestinationProfileName($remoteDestinationProfileName)
            ->setCtiRemoteDeviceName($ctiRemoteDeviceName)
            ->setDualModeDeviceName($dualModeDeviceName)
            ->setDnOrPattern($dnOrPattern)
            ->setPartition($partition)
            ->setType($type)
            ->setHostedPattern($hostedPattern)
            ->setClusterId($clusterId)
            ->setLdapDn($ldapDn)
            ->setUserSearchBase($userSearchBase)
            ->setLearnedPattern($learnedPattern)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setCallControlIdentity($callControlIdentity)
            ->setDomain($domain)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName)
            ->setImeExclusionNumberGroupName($imeExclusionNumberGroupName)
            ->setFilter($filter)
            ->setSubjectName($subjectName)
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setTimeToLive($timeToLive)
            ->setDirectorynumber($directorynumber)
            ->setField($field)
            ->setHostName($hostName)
            ->setDescription_1($description_1)
            ->setRouteString($routeString)
            ->setDefaultVideoStreamId($defaultVideoStreamId)
            ->setLdapConfigName($ldapConfigName)
            ->setLdapManagerDisgName($ldapManagerDisgName)
            ->setLdapUserSearch($ldapUserSearch)
            ->setCcaId($ccaId)
            ->setPrimarySoftSwitchId($primarySoftSwitchId)
            ->setDeviceDescription($deviceDescription)
            ->setServer($server)
            ->setPresenceRedundancyGroup($presenceRedundancyGroup)
            ->setSsidPrefix($ssidPrefix)
            ->setAuthenticationMethod($authenticationMethod)
            ->setSsid($ssid)
            ->setNetworkAccessProfile($networkAccessProfile)
            ->setLineDescription($lineDescription)
            ->setLdapConfigurationName($ldapConfigurationName);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get ownerIdName value
     * @return string|null
     */
    public function getOwnerIdName()
    {
        return $this->ownerIdName;
    }
    /**
     * Set ownerIdName value
     * @param string $ownerIdName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setOwnerIdName($ownerIdName = null)
    {
        $this->ownerIdName = $ownerIdName;
        return $this;
    }
    /**
     * Get dirn value
     * @return string|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDirn($dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get cssName value
     * @return string|null
     */
    public function getCssName()
    {
        return $this->cssName;
    }
    /**
     * Set cssName value
     * @param string $cssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setCssName($cssName = null)
    {
        $this->cssName = $cssName;
        return $this;
    }
    /**
     * Get processNodeRole value
     * @return string|null
     */
    public function getProcessNodeRole()
    {
        return $this->processNodeRole;
    }
    /**
     * Set processNodeRole value
     * @param string $processNodeRole
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setProcessNodeRole($processNodeRole = null)
    {
        $this->processNodeRole = $processNodeRole;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return string|null
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param string $callManagerGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setCallManagerGroupName($callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get regionName value
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param string $regionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setRegionName($regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get namespace value
     * @return string|null
     */
    public function getNamespace()
    {
        return $this->namespace;
    }
    /**
     * Set namespace value
     * @param string $namespace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setNamespace($namespace = null)
    {
        $this->namespace = $namespace;
        return $this;
    }
    /**
     * Get subNet value
     * @return string|null
     */
    public function getSubNet()
    {
        return $this->subNet;
    }
    /**
     * Set subNet value
     * @param string $subNet
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSubNet($subNet = null)
    {
        $this->subNet = $subNet;
        return $this;
    }
    /**
     * Get subNetMaskSz value
     * @return string|null
     */
    public function getSubNetMaskSz()
    {
        return $this->subNetMaskSz;
    }
    /**
     * Set subNetMaskSz value
     * @param string $subNetMaskSz
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSubNetMaskSz($subNetMaskSz = null)
    {
        $this->subNetMaskSz = $subNetMaskSz;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get authorizationLevel value
     * @return string|null
     */
    public function getAuthorizationLevel()
    {
        return $this->authorizationLevel;
    }
    /**
     * Set authorizationLevel value
     * @param string $authorizationLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setAuthorizationLevel($authorizationLevel = null)
    {
        $this->authorizationLevel = $authorizationLevel;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setUserLocale($userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get recordingCssName value
     * @return string|null
     */
    public function getRecordingCssName()
    {
        return $this->recordingCssName;
    }
    /**
     * Set recordingCssName value
     * @param string $recordingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setRecordingCssName($recordingCssName = null)
    {
        $this->recordingCssName = $recordingCssName;
        return $this;
    }
    /**
     * Get recorderDestination value
     * @return string|null
     */
    public function getRecorderDestination()
    {
        return $this->recorderDestination;
    }
    /**
     * Set recorderDestination value
     * @param string $recorderDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setRecorderDestination($recorderDestination = null)
    {
        $this->recorderDestination = $recorderDestination;
        return $this;
    }
    /**
     * Get processNodeName value
     * @return string|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param string $processNodeName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setProcessNodeName($processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get sourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @param string $sourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSourceId($sourceId = null)
    {
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Get primaryDnsIpAddress value
     * @return string|null
     */
    public function getPrimaryDnsIpAddress()
    {
        return $this->primaryDnsIpAddress;
    }
    /**
     * Set primaryDnsIpAddress value
     * @param string $primaryDnsIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setPrimaryDnsIpAddress($primaryDnsIpAddress = null)
    {
        $this->primaryDnsIpAddress = $primaryDnsIpAddress;
        return $this;
    }
    /**
     * Get secondaryDnsIpAddress value
     * @return string|null
     */
    public function getSecondaryDnsIpAddress()
    {
        return $this->secondaryDnsIpAddress;
    }
    /**
     * Set secondaryDnsIpAddress value
     * @param string $secondaryDnsIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSecondaryDnsIpAddress($secondaryDnsIpAddress = null)
    {
        $this->secondaryDnsIpAddress = $secondaryDnsIpAddress;
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDomainName($domainName = null)
    {
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get dhcpServerName value
     * @return string|null
     */
    public function getDhcpServerName()
    {
        return $this->dhcpServerName;
    }
    /**
     * Set dhcpServerName value
     * @param string $dhcpServerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDhcpServerName($dhcpServerName = null)
    {
        $this->dhcpServerName = $dhcpServerName;
        return $this;
    }
    /**
     * Get subnetIpAddress value
     * @return string|null
     */
    public function getSubnetIpAddress()
    {
        return $this->subnetIpAddress;
    }
    /**
     * Set subnetIpAddress value
     * @param string $subnetIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSubnetIpAddress($subnetIpAddress = null)
    {
        $this->subnetIpAddress = $subnetIpAddress;
        return $this;
    }
    /**
     * Get primaryStartIpAddress value
     * @return string|null
     */
    public function getPrimaryStartIpAddress()
    {
        return $this->primaryStartIpAddress;
    }
    /**
     * Set primaryStartIpAddress value
     * @param string $primaryStartIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setPrimaryStartIpAddress($primaryStartIpAddress = null)
    {
        $this->primaryStartIpAddress = $primaryStartIpAddress;
        return $this;
    }
    /**
     * Get primaryEndIpAddress value
     * @return string|null
     */
    public function getPrimaryEndIpAddress()
    {
        return $this->primaryEndIpAddress;
    }
    /**
     * Set primaryEndIpAddress value
     * @param string $primaryEndIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setPrimaryEndIpAddress($primaryEndIpAddress = null)
    {
        $this->primaryEndIpAddress = $primaryEndIpAddress;
        return $this;
    }
    /**
     * Get secondaryStartIpAddress value
     * @return string|null
     */
    public function getSecondaryStartIpAddress()
    {
        return $this->secondaryStartIpAddress;
    }
    /**
     * Set secondaryStartIpAddress value
     * @param string $secondaryStartIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSecondaryStartIpAddress($secondaryStartIpAddress = null)
    {
        $this->secondaryStartIpAddress = $secondaryStartIpAddress;
        return $this;
    }
    /**
     * Get secondaryEndIpAddress value
     * @return string|null
     */
    public function getSecondaryEndIpAddress()
    {
        return $this->secondaryEndIpAddress;
    }
    /**
     * Set secondaryEndIpAddress value
     * @param string $secondaryEndIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSecondaryEndIpAddress($secondaryEndIpAddress = null)
    {
        $this->secondaryEndIpAddress = $secondaryEndIpAddress;
        return $this;
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return string|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param string $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setRoutePartitionName($routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get callManagerName value
     * @return string|null
     */
    public function getCallManagerName()
    {
        return $this->callManagerName;
    }
    /**
     * Set callManagerName value
     * @param string $callManagerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setCallManagerName($callManagerName = null)
    {
        $this->callManagerName = $callManagerName;
        return $this;
    }
    /**
     * Get reversionPattern value
     * @return string|null
     */
    public function getReversionPattern()
    {
        return $this->reversionPattern;
    }
    /**
     * Set reversionPattern value
     * @param string $reversionPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setReversionPattern($reversionPattern = null)
    {
        $this->reversionPattern = $reversionPattern;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setFirstName($firstName = null)
    {
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLastName($lastName = null)
    {
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setUserid($userid = null)
    {
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDepartment($department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get realm value
     * @return string|null
     */
    public function getRealm()
    {
        return $this->realm;
    }
    /**
     * Set realm value
     * @param string $realm
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setRealm($realm = null)
    {
        $this->realm = $realm;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @param string $timeZone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setTimeZone($timeZone = null)
    {
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get applicationUser value
     * @return string|null
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param string $applicationUser
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setApplicationUser($applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get instanceId value
     * @return string|null
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setInstanceId($instanceId = null)
    {
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get endUserId value
     * @return string|null
     */
    public function getEndUserId()
    {
        return $this->endUserId;
    }
    /**
     * Set endUserId value
     * @param string $endUserId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setEndUserId($endUserId = null)
    {
        $this->endUserId = $endUserId;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setService($service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return string|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param string $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setCallingSearchSpaceName($callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return string|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param string $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDevicePoolName($devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return string|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param string $securityProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSecurityProfileName($securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get dnPattern value
     * @return string|null
     */
    public function getDnPattern()
    {
        return $this->dnPattern;
    }
    /**
     * Set dnPattern value
     * @param string $dnPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDnPattern($dnPattern = null)
    {
        $this->dnPattern = $dnPattern;
        return $this;
    }
    /**
     * Get serviceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setServiceName($serviceName = null)
    {
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get serviceDescription value
     * @return string|null
     */
    public function getServiceDescription()
    {
        return $this->serviceDescription;
    }
    /**
     * Set serviceDescription value
     * @param string $serviceDescription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setServiceDescription($serviceDescription = null)
    {
        $this->serviceDescription = $serviceDescription;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return string|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param string $dialPlanName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDialPlanName($dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return string|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param string $routeFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setRouteFilterName($routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get dnOrPatternIpv6 value
     * @return string|null
     */
    public function getDnOrPatternIpv6()
    {
        return $this->dnOrPatternIpv6;
    }
    /**
     * Set dnOrPatternIpv6 value
     * @param string $dnOrPatternIpv6
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDnOrPatternIpv6($dnOrPatternIpv6 = null)
    {
        $this->dnOrPatternIpv6 = $dnOrPatternIpv6;
        return $this;
    }
    /**
     * Get numberBeginWith value
     * @return string|null
     */
    public function getNumberBeginWith()
    {
        return $this->numberBeginWith;
    }
    /**
     * Set numberBeginWith value
     * @param string $numberBeginWith
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setNumberBeginWith($numberBeginWith = null)
    {
        $this->numberBeginWith = $numberBeginWith;
        return $this;
    }
    /**
     * Get dialPattern value
     * @return string|null
     */
    public function getDialPattern()
    {
        return $this->dialPattern;
    }
    /**
     * Set dialPattern value
     * @param string $dialPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDialPattern($dialPattern = null)
    {
        $this->dialPattern = $dialPattern;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param string $usage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setUsage($usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get remoteDestinationProfileName value
     * @return string|null
     */
    public function getRemoteDestinationProfileName()
    {
        return $this->remoteDestinationProfileName;
    }
    /**
     * Set remoteDestinationProfileName value
     * @param string $remoteDestinationProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setRemoteDestinationProfileName($remoteDestinationProfileName = null)
    {
        $this->remoteDestinationProfileName = $remoteDestinationProfileName;
        return $this;
    }
    /**
     * Get ctiRemoteDeviceName value
     * @return string|null
     */
    public function getCtiRemoteDeviceName()
    {
        return $this->ctiRemoteDeviceName;
    }
    /**
     * Set ctiRemoteDeviceName value
     * @param string $ctiRemoteDeviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setCtiRemoteDeviceName($ctiRemoteDeviceName = null)
    {
        $this->ctiRemoteDeviceName = $ctiRemoteDeviceName;
        return $this;
    }
    /**
     * Get dualModeDeviceName value
     * @return string|null
     */
    public function getDualModeDeviceName()
    {
        return $this->dualModeDeviceName;
    }
    /**
     * Set dualModeDeviceName value
     * @param string $dualModeDeviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDualModeDeviceName($dualModeDeviceName = null)
    {
        $this->dualModeDeviceName = $dualModeDeviceName;
        return $this;
    }
    /**
     * Get dnOrPattern value
     * @return string|null
     */
    public function getDnOrPattern()
    {
        return $this->dnOrPattern;
    }
    /**
     * Set dnOrPattern value
     * @param string $dnOrPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDnOrPattern($dnOrPattern = null)
    {
        $this->dnOrPattern = $dnOrPattern;
        return $this;
    }
    /**
     * Get partition value
     * @return string|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param string $partition
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setPartition($partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get hostedPattern value
     * @return string|null
     */
    public function getHostedPattern()
    {
        return $this->hostedPattern;
    }
    /**
     * Set hostedPattern value
     * @param string $hostedPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setHostedPattern($hostedPattern = null)
    {
        $this->hostedPattern = $hostedPattern;
        return $this;
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setClusterId($clusterId = null)
    {
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string|null
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLdapDn($ldapDn = null)
    {
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get learnedPattern value
     * @return string|null
     */
    public function getLearnedPattern()
    {
        return $this->learnedPattern;
    }
    /**
     * Set learnedPattern value
     * @param string $learnedPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLearnedPattern($learnedPattern = null)
    {
        $this->learnedPattern = $learnedPattern;
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get callControlIdentity value
     * @return string|null
     */
    public function getCallControlIdentity()
    {
        return $this->callControlIdentity;
    }
    /**
     * Set callControlIdentity value
     * @param string $callControlIdentity
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setCallControlIdentity($callControlIdentity = null)
    {
        $this->callControlIdentity = $callControlIdentity;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDomain($domain = null)
    {
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * @return string|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return $this->imeEnrolledPatternGroupName;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * @param string $imeEnrolledPatternGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName = null)
    {
        $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        return $this;
    }
    /**
     * Get imeExclusionNumberGroupName value
     * @return string|null
     */
    public function getImeExclusionNumberGroupName()
    {
        return $this->imeExclusionNumberGroupName;
    }
    /**
     * Set imeExclusionNumberGroupName value
     * @param string $imeExclusionNumberGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setImeExclusionNumberGroupName($imeExclusionNumberGroupName = null)
    {
        $this->imeExclusionNumberGroupName = $imeExclusionNumberGroupName;
        return $this;
    }
    /**
     * Get filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param string $filter
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setFilter($filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get subjectName value
     * @return string|null
     */
    public function getSubjectName()
    {
        return $this->subjectName;
    }
    /**
     * Set subjectName value
     * @param string $subjectName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSubjectName($subjectName = null)
    {
        $this->subjectName = $subjectName;
        return $this;
    }
    /**
     * Get issuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setIssuerName($issuerName = null)
    {
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSerialNumber($serialNumber = null)
    {
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get timeToLive value
     * @return string|null
     */
    public function getTimeToLive()
    {
        return $this->timeToLive;
    }
    /**
     * Set timeToLive value
     * @param string $timeToLive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setTimeToLive($timeToLive = null)
    {
        $this->timeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get directorynumber value
     * @return string|null
     */
    public function getDirectorynumber()
    {
        return $this->directorynumber;
    }
    /**
     * Set directorynumber value
     * @param string $directorynumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDirectorynumber($directorynumber = null)
    {
        $this->directorynumber = $directorynumber;
        return $this;
    }
    /**
     * Get field value
     * @return string|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setField($field = null)
    {
        $this->field = $field;
        return $this;
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setHostName($hostName = null)
    {
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription_1()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDescription_1($description_1 = null)
    {
        $this->Description = $description_1;
        return $this;
    }
    /**
     * Get routeString value
     * @return string|null
     */
    public function getRouteString()
    {
        return $this->routeString;
    }
    /**
     * Set routeString value
     * @param string $routeString
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setRouteString($routeString = null)
    {
        $this->routeString = $routeString;
        return $this;
    }
    /**
     * Get defaultVideoStreamId value
     * @return string|null
     */
    public function getDefaultVideoStreamId()
    {
        return $this->defaultVideoStreamId;
    }
    /**
     * Set defaultVideoStreamId value
     * @param string $defaultVideoStreamId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDefaultVideoStreamId($defaultVideoStreamId = null)
    {
        $this->defaultVideoStreamId = $defaultVideoStreamId;
        return $this;
    }
    /**
     * Get ldapConfigName value
     * @return string|null
     */
    public function getLdapConfigName()
    {
        return $this->ldapConfigName;
    }
    /**
     * Set ldapConfigName value
     * @param string $ldapConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLdapConfigName($ldapConfigName = null)
    {
        $this->ldapConfigName = $ldapConfigName;
        return $this;
    }
    /**
     * Get ldapManagerDisgName value
     * @return string|null
     */
    public function getLdapManagerDisgName()
    {
        return $this->ldapManagerDisgName;
    }
    /**
     * Set ldapManagerDisgName value
     * @param string $ldapManagerDisgName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLdapManagerDisgName($ldapManagerDisgName = null)
    {
        $this->ldapManagerDisgName = $ldapManagerDisgName;
        return $this;
    }
    /**
     * Get ldapUserSearch value
     * @return string|null
     */
    public function getLdapUserSearch()
    {
        return $this->ldapUserSearch;
    }
    /**
     * Set ldapUserSearch value
     * @param string $ldapUserSearch
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLdapUserSearch($ldapUserSearch = null)
    {
        $this->ldapUserSearch = $ldapUserSearch;
        return $this;
    }
    /**
     * Get ccaId value
     * @return string|null
     */
    public function getCcaId()
    {
        return $this->ccaId;
    }
    /**
     * Set ccaId value
     * @param string $ccaId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setCcaId($ccaId = null)
    {
        $this->ccaId = $ccaId;
        return $this;
    }
    /**
     * Get primarySoftSwitchId value
     * @return string|null
     */
    public function getPrimarySoftSwitchId()
    {
        return $this->primarySoftSwitchId;
    }
    /**
     * Set primarySoftSwitchId value
     * @param string $primarySoftSwitchId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setPrimarySoftSwitchId($primarySoftSwitchId = null)
    {
        $this->primarySoftSwitchId = $primarySoftSwitchId;
        return $this;
    }
    /**
     * Get deviceDescription value
     * @return string|null
     */
    public function getDeviceDescription()
    {
        return $this->deviceDescription;
    }
    /**
     * Set deviceDescription value
     * @param string $deviceDescription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setDeviceDescription($deviceDescription = null)
    {
        $this->deviceDescription = $deviceDescription;
        return $this;
    }
    /**
     * Get server value
     * @return string|null
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * Set server value
     * @param string $server
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setServer($server = null)
    {
        $this->server = $server;
        return $this;
    }
    /**
     * Get presenceRedundancyGroup value
     * @return string|null
     */
    public function getPresenceRedundancyGroup()
    {
        return $this->presenceRedundancyGroup;
    }
    /**
     * Set presenceRedundancyGroup value
     * @param string $presenceRedundancyGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setPresenceRedundancyGroup($presenceRedundancyGroup = null)
    {
        $this->presenceRedundancyGroup = $presenceRedundancyGroup;
        return $this;
    }
    /**
     * Get ssidPrefix value
     * @return string|null
     */
    public function getSsidPrefix()
    {
        return $this->ssidPrefix;
    }
    /**
     * Set ssidPrefix value
     * @param string $ssidPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSsidPrefix($ssidPrefix = null)
    {
        $this->ssidPrefix = $ssidPrefix;
        return $this;
    }
    /**
     * Get authenticationMethod value
     * @return string|null
     */
    public function getAuthenticationMethod()
    {
        return $this->authenticationMethod;
    }
    /**
     * Set authenticationMethod value
     * @param string $authenticationMethod
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setAuthenticationMethod($authenticationMethod = null)
    {
        $this->authenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get ssid value
     * @return string|null
     */
    public function getSsid()
    {
        return $this->ssid;
    }
    /**
     * Set ssid value
     * @param string $ssid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setSsid($ssid = null)
    {
        $this->ssid = $ssid;
        return $this;
    }
    /**
     * Get networkAccessProfile value
     * @return string|null
     */
    public function getNetworkAccessProfile()
    {
        return $this->networkAccessProfile;
    }
    /**
     * Set networkAccessProfile value
     * @param string $networkAccessProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setNetworkAccessProfile($networkAccessProfile = null)
    {
        $this->networkAccessProfile = $networkAccessProfile;
        return $this;
    }
    /**
     * Get lineDescription value
     * @return string|null
     */
    public function getLineDescription()
    {
        return $this->lineDescription;
    }
    /**
     * Set lineDescription value
     * @param string $lineDescription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLineDescription($lineDescription = null)
    {
        $this->lineDescription = $lineDescription;
        return $this;
    }
    /**
     * Get ldapConfigurationName value
     * @return string|null
     */
    public function getLdapConfigurationName()
    {
        return $this->ldapConfigurationName;
    }
    /**
     * Set ldapConfigurationName value
     * @param string $ldapConfigurationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SearchCriteria
     */
    public function setLdapConfigurationName($ldapConfigurationName = null)
    {
        $this->ldapConfigurationName = $ldapConfigurationName;
        return $this;
    }
}
