<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveSipRealmReq StructType
 * @subpackage Structs
 */
class RemoveSipRealmReq extends AbstractStructBase
{
    /**
     * The realm
     * Meta information extracted from the WSDL
     * - choice: realm | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $realm;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: realm | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveSipRealmReq
     * @uses RemoveSipRealmReq::setRealm()
     * @uses RemoveSipRealmReq::setUuid()
     * @uses RemoveSipRealmReq::setSequence()
     * @param string $realm
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($realm = null, $uuid = null, $sequence = null)
    {
        $this
            ->setRealm($realm)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get realm value
     * @return string
     */
    public function getRealm()
    {
        return isset($this->realm) ? $this->realm : null;
    }
    /**
     * Set realm value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $realm
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSipRealmReq
     */
    public function setRealm($realm = null)
    {
        if (is_null($realm) || (is_array($realm) && empty($realm))) {
            unset($this->realm);
        } else {
            $this->realm = $realm;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSipRealmReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSipRealmReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
