<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveIvrUserLocaleReq StructType
 * @subpackage Structs
 */
class RemoveIvrUserLocaleReq extends AbstractStructBase
{
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - choice: userLocale | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userLocale;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: userLocale | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveIvrUserLocaleReq
     * @uses RemoveIvrUserLocaleReq::setUserLocale()
     * @uses RemoveIvrUserLocaleReq::setUuid()
     * @uses RemoveIvrUserLocaleReq::setSequence()
     * @param string $userLocale
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($userLocale = null, $uuid = null, $sequence = null)
    {
        $this
            ->setUserLocale($userLocale)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get userLocale value
     * @return string
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveIvrUserLocaleReq
     */
    public function setUserLocale($userLocale = null)
    {
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveIvrUserLocaleReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveIvrUserLocaleReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
