<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveIpPhoneServicesReq StructType
 * @subpackage Structs
 */
class RemoveIpPhoneServicesReq extends AbstractStructBase
{
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: serviceName | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: serviceName | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveIpPhoneServicesReq
     * @uses RemoveIpPhoneServicesReq::setServiceName()
     * @uses RemoveIpPhoneServicesReq::setUuid()
     * @uses RemoveIpPhoneServicesReq::setSequence()
     * @param string $serviceName
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($serviceName = null, $uuid = null, $sequence = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get serviceName value
     * @return string
     */
    public function getServiceName()
    {
        return isset($this->serviceName) ? $this->serviceName : null;
    }
    /**
     * Set serviceName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $serviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveIpPhoneServicesReq
     */
    public function setServiceName($serviceName = null)
    {
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->serviceName);
        } else {
            $this->serviceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveIpPhoneServicesReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveIpPhoneServicesReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
