<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveGatewaySubunitsReq StructType
 * @subpackage Structs
 */
class RemoveGatewaySubunitsReq extends AbstractStructBase
{
    /**
     * The gatewayUuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: gatewayUuid | domainName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: gatewayUuid | domainName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $unit;
    /**
     * The subunits
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Subunits
     */
    public $subunits;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveGatewaySubunitsReq
     * @uses RemoveGatewaySubunitsReq::setGatewayUuid()
     * @uses RemoveGatewaySubunitsReq::setDomainName()
     * @uses RemoveGatewaySubunitsReq::setUnit()
     * @uses RemoveGatewaySubunitsReq::setSubunits()
     * @uses RemoveGatewaySubunitsReq::setSequence()
     * @param string $gatewayUuid
     * @param string $domainName
     * @param int $unit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits
     * @param int $sequence
     */
    public function __construct($gatewayUuid = null, $domainName = null, $unit = null, \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits = null, $sequence = null)
    {
        $this
            ->setGatewayUuid($gatewayUuid)
            ->setDomainName($domainName)
            ->setUnit($unit)
            ->setSubunits($subunits)
            ->setSequence($sequence);
    }
    /**
     * Get gatewayUuid value
     * @return string|null
     */
    public function getGatewayUuid()
    {
        return isset($this->gatewayUuid) ? $this->gatewayUuid : null;
    }
    /**
     * Set gatewayUuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $gatewayUuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewaySubunitsReq
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        if (is_null($gatewayUuid) || (is_array($gatewayUuid) && empty($gatewayUuid))) {
            unset($this->gatewayUuid);
        } else {
            $this->gatewayUuid = $gatewayUuid;
        }
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewaySubunitsReq
     */
    public function setDomainName($domainName = null)
    {
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get unit value
     * @return int|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param int $unit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewaySubunitsReq
     */
    public function setUnit($unit = null)
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get subunits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Subunits|null
     */
    public function getSubunits()
    {
        return $this->subunits;
    }
    /**
     * Set subunits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewaySubunitsReq
     */
    public function setSubunits(\\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits = null)
    {
        $this->subunits = $subunits;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewaySubunitsReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
