<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveDhcpSubnetReq StructType
 * @subpackage Structs
 */
class RemoveDhcpSubnetReq extends AbstractStructBase
{
    /**
     * The dhcpServerName
     * Meta information extracted from the WSDL
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dhcpServerName;
    /**
     * The subnetIpAddress
     * Meta information extracted from the WSDL
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subnetIpAddress;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveDhcpSubnetReq
     * @uses RemoveDhcpSubnetReq::setDhcpServerName()
     * @uses RemoveDhcpSubnetReq::setSubnetIpAddress()
     * @uses RemoveDhcpSubnetReq::setUuid()
     * @uses RemoveDhcpSubnetReq::setSequence()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dhcpServerName
     * @param string $subnetIpAddress
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dhcpServerName = null, $subnetIpAddress = null, $uuid = null, $sequence = null)
    {
        $this
            ->setDhcpServerName($dhcpServerName)
            ->setSubnetIpAddress($subnetIpAddress)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get dhcpServerName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDhcpServerName()
    {
        return isset($this->dhcpServerName) ? $this->dhcpServerName : null;
    }
    /**
     * Set dhcpServerName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dhcpServerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveDhcpSubnetReq
     */
    public function setDhcpServerName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dhcpServerName = null)
    {
        if (is_null($dhcpServerName) || (is_array($dhcpServerName) && empty($dhcpServerName))) {
            unset($this->dhcpServerName);
        } else {
            $this->dhcpServerName = $dhcpServerName;
        }
        return $this;
    }
    /**
     * Get subnetIpAddress value
     * @return string
     */
    public function getSubnetIpAddress()
    {
        return isset($this->subnetIpAddress) ? $this->subnetIpAddress : null;
    }
    /**
     * Set subnetIpAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $subnetIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveDhcpSubnetReq
     */
    public function setSubnetIpAddress($subnetIpAddress = null)
    {
        if (is_null($subnetIpAddress) || (is_array($subnetIpAddress) && empty($subnetIpAddress))) {
            unset($this->subnetIpAddress);
        } else {
            $this->subnetIpAddress = $subnetIpAddress;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveDhcpSubnetReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveDhcpSubnetReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
