<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUnitsToGateway StructType
 * @subpackage Structs
 */
class RUnitsToGateway extends AbstractStructBase
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta information extracted from the WSDL
     * - documentation: pkid of the Gateway
     * - base: xsd:string
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Units
     */
    public $units;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUnitsToGateway
     * @uses RUnitsToGateway::setDomainName()
     * @uses RUnitsToGateway::setGatewayUuid()
     * @uses RUnitsToGateway::setUnits()
     * @uses RUnitsToGateway::setUuid()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @param string $uuid
     */
    public function __construct($domainName = null, $gatewayUuid = null, \\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null, $uuid = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUnits($units)
            ->setUuid($uuid);
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RUnitsToGateway
     */
    public function setDomainName($domainName = null)
    {
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string|null
     */
    public function getGatewayUuid()
    {
        return isset($this->gatewayUuid) ? $this->gatewayUuid : null;
    }
    /**
     * Set gatewayUuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $gatewayUuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RUnitsToGateway
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        if (is_null($gatewayUuid) || (is_array($gatewayUuid) && empty($gatewayUuid))) {
            unset($this->gatewayUuid);
        } else {
            $this->gatewayUuid = $gatewayUuid;
        }
        return $this;
    }
    /**
     * Get units value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Units|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RUnitsToGateway
     */
    public function setUnits(\\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RUnitsToGateway
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
