<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTransPattern StructType
 * @subpackage Structs
 */
class RTransPattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The patternUrgency
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The provideOutsideDialtone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The resourcePriorityNamespaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeNextHopByCgpn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeNextHopByCgpn;
    /**
     * The routeClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeClass;
    /**
     * The callInterceptProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callInterceptProfileName;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The useOriginatorCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOriginatorCss;
    /**
     * The dontWaitForIDTOnSubsequentHops
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dontWaitForIDTOnSubsequentHops;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTransPattern
     * @uses RTransPattern::setPattern()
     * @uses RTransPattern::setDescription()
     * @uses RTransPattern::setUsage()
     * @uses RTransPattern::setRoutePartitionName()
     * @uses RTransPattern::setBlockEnable()
     * @uses RTransPattern::setCalledPartyTransformationMask()
     * @uses RTransPattern::setCallingPartyTransformationMask()
     * @uses RTransPattern::setUseCallingPartyPhoneMask()
     * @uses RTransPattern::setCallingPartyPrefixDigits()
     * @uses RTransPattern::setDialPlanName()
     * @uses RTransPattern::setDigitDiscardInstructionName()
     * @uses RTransPattern::setPatternUrgency()
     * @uses RTransPattern::setPrefixDigitsOut()
     * @uses RTransPattern::setRouteFilterName()
     * @uses RTransPattern::setCallingLinePresentationBit()
     * @uses RTransPattern::setCallingNamePresentationBit()
     * @uses RTransPattern::setConnectedLinePresentationBit()
     * @uses RTransPattern::setConnectedNamePresentationBit()
     * @uses RTransPattern::setPatternPrecedence()
     * @uses RTransPattern::setProvideOutsideDialtone()
     * @uses RTransPattern::setCallingPartyNumberingPlan()
     * @uses RTransPattern::setCallingPartyNumberType()
     * @uses RTransPattern::setCalledPartyNumberingPlan()
     * @uses RTransPattern::setCalledPartyNumberType()
     * @uses RTransPattern::setCallingSearchSpaceName()
     * @uses RTransPattern::setResourcePriorityNamespaceName()
     * @uses RTransPattern::setRouteNextHopByCgpn()
     * @uses RTransPattern::setRouteClass()
     * @uses RTransPattern::setCallInterceptProfileName()
     * @uses RTransPattern::setReleaseClause()
     * @uses RTransPattern::setUseOriginatorCss()
     * @uses RTransPattern::setDontWaitForIDTOnSubsequentHops()
     * @uses RTransPattern::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param string $callingPartyPrefixDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $patternUrgency
     * @param string $prefixDigitsOut
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $patternPrecedence
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName
     * @param string $routeNextHopByCgpn
     * @param string $routeClass
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callInterceptProfileName
     * @param string $releaseClause
     * @param string $useOriginatorCss
     * @param string $dontWaitForIDTOnSubsequentHops
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $blockEnable = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = null, $callingPartyPrefixDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $patternUrgency = null, $prefixDigitsOut = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, $callingLinePresentationBit = null, $callingNamePresentationBit = null, $connectedLinePresentationBit = null, $connectedNamePresentationBit = null, $patternPrecedence = null, $provideOutsideDialtone = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName = null, $routeNextHopByCgpn = null, $routeClass = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callInterceptProfileName = null, $releaseClause = null, $useOriginatorCss = null, $dontWaitForIDTOnSubsequentHops = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setPatternUrgency($patternUrgency)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteNextHopByCgpn($routeNextHopByCgpn)
            ->setRouteClass($routeClass)
            ->setCallInterceptProfileName($callInterceptProfileName)
            ->setReleaseClause($releaseClause)
            ->setUseOriginatorCss($useOriginatorCss)
            ->setDontWaitForIDTOnSubsequentHops($dontWaitForIDTOnSubsequentHops)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param string $usage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setUsage($usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setBlockEnable($blockEnable = null)
    {
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param string $useCallingPartyPhoneMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = null)
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setDialPlanName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setDigitDiscardInstructionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setRouteFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param string $callingLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param string $callingNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = null)
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param string $connectedLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = null)
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param string $connectedNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = null)
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param string $patternPrecedence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = null)
    {
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param string $callingPartyNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param string $callingPartyNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param string $calledPartyNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param string $calledPartyNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setResourcePriorityNamespaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeNextHopByCgpn value
     * @return string|null
     */
    public function getRouteNextHopByCgpn()
    {
        return $this->routeNextHopByCgpn;
    }
    /**
     * Set routeNextHopByCgpn value
     * @param string $routeNextHopByCgpn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setRouteNextHopByCgpn($routeNextHopByCgpn = null)
    {
        $this->routeNextHopByCgpn = $routeNextHopByCgpn;
        return $this;
    }
    /**
     * Get routeClass value
     * @return string|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @param string $routeClass
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setRouteClass($routeClass = null)
    {
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get callInterceptProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallInterceptProfileName()
    {
        return $this->callInterceptProfileName;
    }
    /**
     * Set callInterceptProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callInterceptProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setCallInterceptProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callInterceptProfileName = null)
    {
        $this->callInterceptProfileName = $callInterceptProfileName;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param string $releaseClause
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setReleaseClause($releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get useOriginatorCss value
     * @return string|null
     */
    public function getUseOriginatorCss()
    {
        return $this->useOriginatorCss;
    }
    /**
     * Set useOriginatorCss value
     * @param string $useOriginatorCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setUseOriginatorCss($useOriginatorCss = null)
    {
        $this->useOriginatorCss = $useOriginatorCss;
        return $this;
    }
    /**
     * Get dontWaitForIDTOnSubsequentHops value
     * @return string|null
     */
    public function getDontWaitForIDTOnSubsequentHops()
    {
        return $this->dontWaitForIDTOnSubsequentHops;
    }
    /**
     * Set dontWaitForIDTOnSubsequentHops value
     * @param string $dontWaitForIDTOnSubsequentHops
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setDontWaitForIDTOnSubsequentHops($dontWaitForIDTOnSubsequentHops = null)
    {
        $this->dontWaitForIDTOnSubsequentHops = $dontWaitForIDTOnSubsequentHops;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTransPattern
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
