<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRoutePattern StructType
 * @subpackage Structs
 */
class RRoutePattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - documentation: dialPlan is mandatory for patterns with @ in it.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The dialPlanWizardGenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The patternUrgency
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The supportOverlapSending
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for a translation pattern.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $supportOverlapSending;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The allowDeviceOverride
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowDeviceOverride;
    /**
     * The provideOutsideDialtone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Destination
     */
    public $destination;
    /**
     * The authorizationCodeRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $authorizationCodeRequired;
    /**
     * The authorizationLevelRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authorizationLevelRequired;
    /**
     * The clientCodeRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $clientCodeRequired;
    /**
     * The withTag
     * Meta information extracted from the WSDL
     * - documentation: Read Only
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withTag;
    /**
     * The withValueClause
     * Meta information extracted from the WSDL
     * - documentation: Read Only
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withValueClause;
    /**
     * The isdnNsfInfoElement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement
     */
    public $isdnNsfInfoElement;
    /**
     * The resourcePriorityNamespaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeClass;
    /**
     * The enableDccEnforcement
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDccEnforcement;
    /**
     * The blockedCallPercentage
     * Meta information extracted from the WSDL
     * - documentation: This tag is only valid when value of enabledccenforcement is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blockedCallPercentage;
    /**
     * The externalCallControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $externalCallControl;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRoutePattern
     * @uses RRoutePattern::setPattern()
     * @uses RRoutePattern::setDescription()
     * @uses RRoutePattern::setUsage()
     * @uses RRoutePattern::setRoutePartitionName()
     * @uses RRoutePattern::setBlockEnable()
     * @uses RRoutePattern::setCalledPartyTransformationMask()
     * @uses RRoutePattern::setCallingPartyTransformationMask()
     * @uses RRoutePattern::setUseCallingPartyPhoneMask()
     * @uses RRoutePattern::setCallingPartyPrefixDigits()
     * @uses RRoutePattern::setDialPlanName()
     * @uses RRoutePattern::setDialPlanWizardGenId()
     * @uses RRoutePattern::setDigitDiscardInstructionName()
     * @uses RRoutePattern::setNetworkLocation()
     * @uses RRoutePattern::setPatternUrgency()
     * @uses RRoutePattern::setPrefixDigitsOut()
     * @uses RRoutePattern::setRouteFilterName()
     * @uses RRoutePattern::setCallingLinePresentationBit()
     * @uses RRoutePattern::setCallingNamePresentationBit()
     * @uses RRoutePattern::setConnectedLinePresentationBit()
     * @uses RRoutePattern::setConnectedNamePresentationBit()
     * @uses RRoutePattern::setSupportOverlapSending()
     * @uses RRoutePattern::setPatternPrecedence()
     * @uses RRoutePattern::setReleaseClause()
     * @uses RRoutePattern::setAllowDeviceOverride()
     * @uses RRoutePattern::setProvideOutsideDialtone()
     * @uses RRoutePattern::setCallingPartyNumberingPlan()
     * @uses RRoutePattern::setCallingPartyNumberType()
     * @uses RRoutePattern::setCalledPartyNumberingPlan()
     * @uses RRoutePattern::setCalledPartyNumberType()
     * @uses RRoutePattern::setDestination()
     * @uses RRoutePattern::setAuthorizationCodeRequired()
     * @uses RRoutePattern::setAuthorizationLevelRequired()
     * @uses RRoutePattern::setClientCodeRequired()
     * @uses RRoutePattern::setWithTag()
     * @uses RRoutePattern::setWithValueClause()
     * @uses RRoutePattern::setIsdnNsfInfoElement()
     * @uses RRoutePattern::setResourcePriorityNamespaceName()
     * @uses RRoutePattern::setRouteClass()
     * @uses RRoutePattern::setEnableDccEnforcement()
     * @uses RRoutePattern::setBlockedCallPercentage()
     * @uses RRoutePattern::setExternalCallControl()
     * @uses RRoutePattern::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param string $callingPartyPrefixDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param string $dialPlanWizardGenId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $networkLocation
     * @param string $patternUrgency
     * @param string $prefixDigitsOut
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $supportOverlapSending
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $allowDeviceOverride
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Destination $destination
     * @param string $authorizationCodeRequired
     * @param string $authorizationLevelRequired
     * @param string $clientCodeRequired
     * @param string $withTag
     * @param string $withValueClause
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName
     * @param string $routeClass
     * @param string $enableDccEnforcement
     * @param string $blockedCallPercentage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $blockEnable = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = null, $callingPartyPrefixDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, $dialPlanWizardGenId = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $networkLocation = null, $patternUrgency = null, $prefixDigitsOut = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, $callingLinePresentationBit = null, $callingNamePresentationBit = null, $connectedLinePresentationBit = null, $connectedNamePresentationBit = null, $supportOverlapSending = null, $patternPrecedence = null, $releaseClause = null, $allowDeviceOverride = null, $provideOutsideDialtone = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, \\Losc\CucmBundle\Model\Webservice\StructType\Destination $destination = null, $authorizationCodeRequired = null, $authorizationLevelRequired = null, $clientCodeRequired = null, $withTag = null, $withValueClause = null, \\Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName = null, $routeClass = null, $enableDccEnforcement = null, $blockedCallPercentage = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setDialPlanName($dialPlanName)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setNetworkLocation($networkLocation)
            ->setPatternUrgency($patternUrgency)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setSupportOverlapSending($supportOverlapSending)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setAllowDeviceOverride($allowDeviceOverride)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setDestination($destination)
            ->setAuthorizationCodeRequired($authorizationCodeRequired)
            ->setAuthorizationLevelRequired($authorizationLevelRequired)
            ->setClientCodeRequired($clientCodeRequired)
            ->setWithTag($withTag)
            ->setWithValueClause($withValueClause)
            ->setIsdnNsfInfoElement($isdnNsfInfoElement)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setEnableDccEnforcement($enableDccEnforcement)
            ->setBlockedCallPercentage($blockedCallPercentage)
            ->setExternalCallControl($externalCallControl)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param string $usage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setUsage($usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setBlockEnable($blockEnable = null)
    {
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param string $useCallingPartyPhoneMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = null)
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDialPlanName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @param string $dialPlanWizardGenId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDigitDiscardInstructionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setNetworkLocation($networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setRouteFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param string $callingLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param string $callingNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = null)
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param string $connectedLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = null)
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param string $connectedNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = null)
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get supportOverlapSending value
     * @return string|null
     */
    public function getSupportOverlapSending()
    {
        return $this->supportOverlapSending;
    }
    /**
     * Set supportOverlapSending value
     * @param string $supportOverlapSending
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setSupportOverlapSending($supportOverlapSending = null)
    {
        $this->supportOverlapSending = $supportOverlapSending;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param string $patternPrecedence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param string $releaseClause
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setReleaseClause($releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get allowDeviceOverride value
     * @return string|null
     */
    public function getAllowDeviceOverride()
    {
        return $this->allowDeviceOverride;
    }
    /**
     * Set allowDeviceOverride value
     * @param string $allowDeviceOverride
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setAllowDeviceOverride($allowDeviceOverride = null)
    {
        $this->allowDeviceOverride = $allowDeviceOverride;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = null)
    {
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param string $callingPartyNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param string $callingPartyNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param string $calledPartyNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param string $calledPartyNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get destination value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Destination|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Destination $destination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setDestination(\\Losc\CucmBundle\Model\Webservice\StructType\Destination $destination = null)
    {
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get authorizationCodeRequired value
     * @return string|null
     */
    public function getAuthorizationCodeRequired()
    {
        return $this->authorizationCodeRequired;
    }
    /**
     * Set authorizationCodeRequired value
     * @param string $authorizationCodeRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setAuthorizationCodeRequired($authorizationCodeRequired = null)
    {
        $this->authorizationCodeRequired = $authorizationCodeRequired;
        return $this;
    }
    /**
     * Get authorizationLevelRequired value
     * @return string|null
     */
    public function getAuthorizationLevelRequired()
    {
        return $this->authorizationLevelRequired;
    }
    /**
     * Set authorizationLevelRequired value
     * @param string $authorizationLevelRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setAuthorizationLevelRequired($authorizationLevelRequired = null)
    {
        $this->authorizationLevelRequired = $authorizationLevelRequired;
        return $this;
    }
    /**
     * Get clientCodeRequired value
     * @return string|null
     */
    public function getClientCodeRequired()
    {
        return $this->clientCodeRequired;
    }
    /**
     * Set clientCodeRequired value
     * @param string $clientCodeRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setClientCodeRequired($clientCodeRequired = null)
    {
        $this->clientCodeRequired = $clientCodeRequired;
        return $this;
    }
    /**
     * Get withTag value
     * @return string|null
     */
    public function getWithTag()
    {
        return $this->withTag;
    }
    /**
     * Set withTag value
     * @param string $withTag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setWithTag($withTag = null)
    {
        $this->withTag = $withTag;
        return $this;
    }
    /**
     * Get withValueClause value
     * @return string|null
     */
    public function getWithValueClause()
    {
        return $this->withValueClause;
    }
    /**
     * Set withValueClause value
     * @param string $withValueClause
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setWithValueClause($withValueClause = null)
    {
        $this->withValueClause = $withValueClause;
        return $this;
    }
    /**
     * Get isdnNsfInfoElement value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement|null
     */
    public function getIsdnNsfInfoElement()
    {
        return $this->isdnNsfInfoElement;
    }
    /**
     * Set isdnNsfInfoElement value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setIsdnNsfInfoElement(\\Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement = null)
    {
        $this->isdnNsfInfoElement = $isdnNsfInfoElement;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setResourcePriorityNamespaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeClass value
     * @return string|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @param string $routeClass
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setRouteClass($routeClass = null)
    {
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get enableDccEnforcement value
     * @return string|null
     */
    public function getEnableDccEnforcement()
    {
        return $this->enableDccEnforcement;
    }
    /**
     * Set enableDccEnforcement value
     * @param string $enableDccEnforcement
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setEnableDccEnforcement($enableDccEnforcement = null)
    {
        $this->enableDccEnforcement = $enableDccEnforcement;
        return $this;
    }
    /**
     * Get blockedCallPercentage value
     * @return string|null
     */
    public function getBlockedCallPercentage()
    {
        return $this->blockedCallPercentage;
    }
    /**
     * Set blockedCallPercentage value
     * @param string $blockedCallPercentage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setBlockedCallPercentage($blockedCallPercentage = null)
    {
        $this->blockedCallPercentage = $blockedCallPercentage;
        return $this;
    }
    /**
     * Get externalCallControl value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExternalCallControl()
    {
        return $this->externalCallControl;
    }
    /**
     * Set externalCallControl value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setExternalCallControl(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl = null)
    {
        $this->externalCallControl = $externalCallControl;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
