<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPhoneSecurityProfile StructType
 * @subpackage Structs
 */
class RPhoneSecurityProfile extends AbstractStructBase
{
    /**
     * The phoneType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneType;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The tftpEncryptedConfig
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpEncryptedConfig;
    /**
     * The nonceValidityTime
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nonceValidityTime;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transportType;
    /**
     * The sipPhonePort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipPhonePort;
    /**
     * The enableDigestAuthentication
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDigestAuthentication;
    /**
     * The excludeDigestCredentials
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $excludeDigestCredentials;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPhoneSecurityProfile
     * @uses RPhoneSecurityProfile::setPhoneType()
     * @uses RPhoneSecurityProfile::setProtocol()
     * @uses RPhoneSecurityProfile::setName()
     * @uses RPhoneSecurityProfile::setDescription()
     * @uses RPhoneSecurityProfile::setDeviceSecurityMode()
     * @uses RPhoneSecurityProfile::setAuthenticationMode()
     * @uses RPhoneSecurityProfile::setKeySize()
     * @uses RPhoneSecurityProfile::setTftpEncryptedConfig()
     * @uses RPhoneSecurityProfile::setNonceValidityTime()
     * @uses RPhoneSecurityProfile::setTransportType()
     * @uses RPhoneSecurityProfile::setSipPhonePort()
     * @uses RPhoneSecurityProfile::setEnableDigestAuthentication()
     * @uses RPhoneSecurityProfile::setExcludeDigestCredentials()
     * @uses RPhoneSecurityProfile::setUuid()
     * @param string $phoneType
     * @param string $protocol
     * @param string $name
     * @param string $description
     * @param string $deviceSecurityMode
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $tftpEncryptedConfig
     * @param string $nonceValidityTime
     * @param string $transportType
     * @param string $sipPhonePort
     * @param string $enableDigestAuthentication
     * @param string $excludeDigestCredentials
     * @param string $uuid
     */
    public function __construct($phoneType = null, $protocol = null, $name = null, $description = null, $deviceSecurityMode = null, $authenticationMode = null, $keySize = null, $tftpEncryptedConfig = null, $nonceValidityTime = null, $transportType = null, $sipPhonePort = null, $enableDigestAuthentication = null, $excludeDigestCredentials = null, $uuid = null)
    {
        $this
            ->setPhoneType($phoneType)
            ->setProtocol($protocol)
            ->setName($name)
            ->setDescription($description)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setTftpEncryptedConfig($tftpEncryptedConfig)
            ->setNonceValidityTime($nonceValidityTime)
            ->setTransportType($transportType)
            ->setSipPhonePort($sipPhonePort)
            ->setEnableDigestAuthentication($enableDigestAuthentication)
            ->setExcludeDigestCredentials($excludeDigestCredentials)
            ->setUuid($uuid);
    }
    /**
     * Get phoneType value
     * @return string|null
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @param string $phoneType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setPhoneType($phoneType = null)
    {
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @param string $deviceSecurityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param string $authenticationMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param string $keySize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setKeySize($keySize = null)
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get tftpEncryptedConfig value
     * @return string|null
     */
    public function getTftpEncryptedConfig()
    {
        return $this->tftpEncryptedConfig;
    }
    /**
     * Set tftpEncryptedConfig value
     * @param string $tftpEncryptedConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setTftpEncryptedConfig($tftpEncryptedConfig = null)
    {
        $this->tftpEncryptedConfig = $tftpEncryptedConfig;
        return $this;
    }
    /**
     * Get nonceValidityTime value
     * @return string|null
     */
    public function getNonceValidityTime()
    {
        return $this->nonceValidityTime;
    }
    /**
     * Set nonceValidityTime value
     * @param string $nonceValidityTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setNonceValidityTime($nonceValidityTime = null)
    {
        $this->nonceValidityTime = $nonceValidityTime;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @param string $transportType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setTransportType($transportType = null)
    {
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @param string $sipPhonePort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setSipPhonePort($sipPhonePort = null)
    {
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get enableDigestAuthentication value
     * @return string|null
     */
    public function getEnableDigestAuthentication()
    {
        return $this->enableDigestAuthentication;
    }
    /**
     * Set enableDigestAuthentication value
     * @param string $enableDigestAuthentication
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setEnableDigestAuthentication($enableDigestAuthentication = null)
    {
        $this->enableDigestAuthentication = $enableDigestAuthentication;
        return $this;
    }
    /**
     * Get excludeDigestCredentials value
     * @return string|null
     */
    public function getExcludeDigestCredentials()
    {
        return $this->excludeDigestCredentials;
    }
    /**
     * Set excludeDigestCredentials value
     * @param string $excludeDigestCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setExcludeDigestCredentials($excludeDigestCredentials = null)
    {
        $this->excludeDigestCredentials = $excludeDigestCredentials;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhoneSecurityProfile
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
