<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RParameterMember StructType
 * @subpackage Structs
 */
class RParameterMember extends AbstractStructBase
{
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameter;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for RParameterMember
     * @uses RParameterMember::setParameter()
     * @uses RParameterMember::setValue()
     * @uses RParameterMember::setSelectionOrder()
     * @param string $parameter
     * @param string $value
     * @param string $selectionOrder
     */
    public function __construct($parameter = null, $value = null, $selectionOrder = null)
    {
        $this
            ->setParameter($parameter)
            ->setValue($value)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @param string $parameter
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RParameterMember
     */
    public function setParameter($parameter = null)
    {
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RParameterMember
     */
    public function setValue($value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @param string $selectionOrder
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RParameterMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
}
