<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFallbackProfile StructType
 * @subpackage Structs
 */
class RFallbackProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The advertisedFallbackDirectoryE164Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $advertisedFallbackDirectoryE164Number;
    /**
     * The qosSensistivityLevel
     * Meta information extracted from the WSDL
     * - documentation: The Fallback QOS Sensitivity should be in range 1 to 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The callCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callCss;
    /**
     * The callAnswerTimer
     * Meta information extracted from the WSDL
     * - documentation: The Fallback Call Answer Timer should be in range 1 to 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The directoryNumberPartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $directoryNumberPartition;
    /**
     * The directoryNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryNumber;
    /**
     * The numberOfDigitsForCallerIDPartialMatch
     * Meta information extracted from the WSDL
     * - documentation: The number of digits for Caller ID partial match should be in range 4 to 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfDigitsForCallerIDPartialMatch;
    /**
     * The numberOfCorrelationDtmfDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfCorrelationDtmfDigits;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RFallbackProfile
     * @uses RFallbackProfile::setName()
     * @uses RFallbackProfile::setDescription()
     * @uses RFallbackProfile::setAdvertisedFallbackDirectoryE164Number()
     * @uses RFallbackProfile::setQosSensistivityLevel()
     * @uses RFallbackProfile::setCallCss()
     * @uses RFallbackProfile::setCallAnswerTimer()
     * @uses RFallbackProfile::setDirectoryNumberPartition()
     * @uses RFallbackProfile::setDirectoryNumber()
     * @uses RFallbackProfile::setNumberOfDigitsForCallerIDPartialMatch()
     * @uses RFallbackProfile::setNumberOfCorrelationDtmfDigits()
     * @uses RFallbackProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $advertisedFallbackDirectoryE164Number
     * @param string $qosSensistivityLevel
     * @param string $callCss
     * @param string $callAnswerTimer
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition
     * @param string $directoryNumber
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @param string $numberOfCorrelationDtmfDigits
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $advertisedFallbackDirectoryE164Number = null, $qosSensistivityLevel = null, $callCss = null, $callAnswerTimer = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition = null, $directoryNumber = null, $numberOfDigitsForCallerIDPartialMatch = null, $numberOfCorrelationDtmfDigits = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setCallCss($callCss)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setDirectoryNumberPartition($directoryNumberPartition)
            ->setDirectoryNumber($directoryNumber)
            ->setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch)
            ->setNumberOfCorrelationDtmfDigits($numberOfCorrelationDtmfDigits)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get advertisedFallbackDirectoryE164Number value
     * @return string|null
     */
    public function getAdvertisedFallbackDirectoryE164Number()
    {
        return $this->advertisedFallbackDirectoryE164Number;
    }
    /**
     * Set advertisedFallbackDirectoryE164Number value
     * @param string $advertisedFallbackDirectoryE164Number
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number = null)
    {
        $this->advertisedFallbackDirectoryE164Number = $advertisedFallbackDirectoryE164Number;
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return $this->qosSensistivityLevel;
    }
    /**
     * Set qosSensistivityLevel value
     * @param string $qosSensistivityLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = null)
    {
        $this->qosSensistivityLevel = $qosSensistivityLevel;
        return $this;
    }
    /**
     * Get callCss value
     * @return string|null
     */
    public function getCallCss()
    {
        return $this->callCss;
    }
    /**
     * Set callCss value
     * @param string $callCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setCallCss($callCss = null)
    {
        $this->callCss = $callCss;
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return $this->callAnswerTimer;
    }
    /**
     * Set callAnswerTimer value
     * @param string $callAnswerTimer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setCallAnswerTimer($callAnswerTimer = null)
    {
        $this->callAnswerTimer = $callAnswerTimer;
        return $this;
    }
    /**
     * Get directoryNumberPartition value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDirectoryNumberPartition()
    {
        return $this->directoryNumberPartition;
    }
    /**
     * Set directoryNumberPartition value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setDirectoryNumberPartition(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition = null)
    {
        $this->directoryNumberPartition = $directoryNumberPartition;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return string|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param string $directoryNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setDirectoryNumber($directoryNumber = null)
    {
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get numberOfDigitsForCallerIDPartialMatch value
     * @return string|null
     */
    public function getNumberOfDigitsForCallerIDPartialMatch()
    {
        return $this->numberOfDigitsForCallerIDPartialMatch;
    }
    /**
     * Set numberOfDigitsForCallerIDPartialMatch value
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch = null)
    {
        $this->numberOfDigitsForCallerIDPartialMatch = $numberOfDigitsForCallerIDPartialMatch;
        return $this;
    }
    /**
     * Get numberOfCorrelationDtmfDigits value
     * @return string|null
     */
    public function getNumberOfCorrelationDtmfDigits()
    {
        return $this->numberOfCorrelationDtmfDigits;
    }
    /**
     * Set numberOfCorrelationDtmfDigits value
     * @param string $numberOfCorrelationDtmfDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setNumberOfCorrelationDtmfDigits($numberOfCorrelationDtmfDigits = null)
    {
        $this->numberOfCorrelationDtmfDigits = $numberOfCorrelationDtmfDigits;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
