<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCredentialPolicy StructType
 * @subpackage Structs
 */
class RCredentialPolicy extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The failedLogon
     * Meta information extracted from the WSDL
     * - documentation: Failed logon must be a number in the range 0 to 100. If 0 is entered, NoLimitForFailedLogon is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $failedLogon;
    /**
     * The resetFailedLogonAttempts
     * Meta information extracted from the WSDL
     * - documentation: Reset Failed logon attempts must be a number in the range 1 to 120. (minutes)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $resetFailedLogonAttempts;
    /**
     * The lockoutDuration
     * Meta information extracted from the WSDL
     * - documentation: Lockout duration must be a number in the range 0 to 1440. (minutes), If 0 is entered then Administrator Must Unlock is true.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lockoutDuration;
    /**
     * The credChangeDuration
     * Meta information extracted from the WSDL
     * - documentation: Credential change duration must be a number in the range 0 to 129600. (minutes)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credChangeDuration;
    /**
     * The credExpiresAfter
     * Meta information extracted from the WSDL
     * - documentation: Credential expires after must be a number in the range 0 to 365. (Days). If 0 is entered, then neverExpires is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credExpiresAfter;
    /**
     * The minCredLength
     * Meta information extracted from the WSDL
     * - documentation: Minimum credential length must be a number in the range 0 to 64.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $minCredLength;
    /**
     * The prevCredStoredNum
     * Meta information extracted from the WSDL
     * - documentation: Stored number of previous credentials must be a number in the range 0 to 25.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prevCredStoredNum;
    /**
     * The inactiveDaysAllowed
     * Meta information extracted from the WSDL
     * - documentation: Inactive days allowed must be a number in the range 0 to 5000.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $inactiveDaysAllowed;
    /**
     * The expiryWarningDays
     * Meta information extracted from the WSDL
     * - documentation: Expiry warning days must be a number in the range 0 to 90.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $expiryWarningDays;
    /**
     * The trivialCredCheck
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trivialCredCheck;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCredentialPolicy
     * @uses RCredentialPolicy::setName()
     * @uses RCredentialPolicy::setFailedLogon()
     * @uses RCredentialPolicy::setResetFailedLogonAttempts()
     * @uses RCredentialPolicy::setLockoutDuration()
     * @uses RCredentialPolicy::setCredChangeDuration()
     * @uses RCredentialPolicy::setCredExpiresAfter()
     * @uses RCredentialPolicy::setMinCredLength()
     * @uses RCredentialPolicy::setPrevCredStoredNum()
     * @uses RCredentialPolicy::setInactiveDaysAllowed()
     * @uses RCredentialPolicy::setExpiryWarningDays()
     * @uses RCredentialPolicy::setTrivialCredCheck()
     * @uses RCredentialPolicy::setUuid()
     * @param string $name
     * @param string $failedLogon
     * @param string $resetFailedLogonAttempts
     * @param string $lockoutDuration
     * @param string $credChangeDuration
     * @param string $credExpiresAfter
     * @param string $minCredLength
     * @param string $prevCredStoredNum
     * @param string $inactiveDaysAllowed
     * @param string $expiryWarningDays
     * @param string $trivialCredCheck
     * @param string $uuid
     */
    public function __construct($name = null, $failedLogon = null, $resetFailedLogonAttempts = null, $lockoutDuration = null, $credChangeDuration = null, $credExpiresAfter = null, $minCredLength = null, $prevCredStoredNum = null, $inactiveDaysAllowed = null, $expiryWarningDays = null, $trivialCredCheck = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setFailedLogon($failedLogon)
            ->setResetFailedLogonAttempts($resetFailedLogonAttempts)
            ->setLockoutDuration($lockoutDuration)
            ->setCredChangeDuration($credChangeDuration)
            ->setCredExpiresAfter($credExpiresAfter)
            ->setMinCredLength($minCredLength)
            ->setPrevCredStoredNum($prevCredStoredNum)
            ->setInactiveDaysAllowed($inactiveDaysAllowed)
            ->setExpiryWarningDays($expiryWarningDays)
            ->setTrivialCredCheck($trivialCredCheck)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get failedLogon value
     * @return string|null
     */
    public function getFailedLogon()
    {
        return $this->failedLogon;
    }
    /**
     * Set failedLogon value
     * @param string $failedLogon
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setFailedLogon($failedLogon = null)
    {
        $this->failedLogon = $failedLogon;
        return $this;
    }
    /**
     * Get resetFailedLogonAttempts value
     * @return string|null
     */
    public function getResetFailedLogonAttempts()
    {
        return $this->resetFailedLogonAttempts;
    }
    /**
     * Set resetFailedLogonAttempts value
     * @param string $resetFailedLogonAttempts
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setResetFailedLogonAttempts($resetFailedLogonAttempts = null)
    {
        $this->resetFailedLogonAttempts = $resetFailedLogonAttempts;
        return $this;
    }
    /**
     * Get lockoutDuration value
     * @return string|null
     */
    public function getLockoutDuration()
    {
        return $this->lockoutDuration;
    }
    /**
     * Set lockoutDuration value
     * @param string $lockoutDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setLockoutDuration($lockoutDuration = null)
    {
        $this->lockoutDuration = $lockoutDuration;
        return $this;
    }
    /**
     * Get credChangeDuration value
     * @return string|null
     */
    public function getCredChangeDuration()
    {
        return $this->credChangeDuration;
    }
    /**
     * Set credChangeDuration value
     * @param string $credChangeDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setCredChangeDuration($credChangeDuration = null)
    {
        $this->credChangeDuration = $credChangeDuration;
        return $this;
    }
    /**
     * Get credExpiresAfter value
     * @return string|null
     */
    public function getCredExpiresAfter()
    {
        return $this->credExpiresAfter;
    }
    /**
     * Set credExpiresAfter value
     * @param string $credExpiresAfter
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setCredExpiresAfter($credExpiresAfter = null)
    {
        $this->credExpiresAfter = $credExpiresAfter;
        return $this;
    }
    /**
     * Get minCredLength value
     * @return string|null
     */
    public function getMinCredLength()
    {
        return $this->minCredLength;
    }
    /**
     * Set minCredLength value
     * @param string $minCredLength
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setMinCredLength($minCredLength = null)
    {
        $this->minCredLength = $minCredLength;
        return $this;
    }
    /**
     * Get prevCredStoredNum value
     * @return string|null
     */
    public function getPrevCredStoredNum()
    {
        return $this->prevCredStoredNum;
    }
    /**
     * Set prevCredStoredNum value
     * @param string $prevCredStoredNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setPrevCredStoredNum($prevCredStoredNum = null)
    {
        $this->prevCredStoredNum = $prevCredStoredNum;
        return $this;
    }
    /**
     * Get inactiveDaysAllowed value
     * @return string|null
     */
    public function getInactiveDaysAllowed()
    {
        return $this->inactiveDaysAllowed;
    }
    /**
     * Set inactiveDaysAllowed value
     * @param string $inactiveDaysAllowed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setInactiveDaysAllowed($inactiveDaysAllowed = null)
    {
        $this->inactiveDaysAllowed = $inactiveDaysAllowed;
        return $this;
    }
    /**
     * Get expiryWarningDays value
     * @return string|null
     */
    public function getExpiryWarningDays()
    {
        return $this->expiryWarningDays;
    }
    /**
     * Set expiryWarningDays value
     * @param string $expiryWarningDays
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setExpiryWarningDays($expiryWarningDays = null)
    {
        $this->expiryWarningDays = $expiryWarningDays;
        return $this;
    }
    /**
     * Get trivialCredCheck value
     * @return string|null
     */
    public function getTrivialCredCheck()
    {
        return $this->trivialCredCheck;
    }
    /**
     * Set trivialCredCheck value
     * @param string $trivialCredCheck
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setTrivialCredCheck($trivialCredCheck = null)
    {
        $this->trivialCredCheck = $trivialCredCheck;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCredentialPolicy
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
