<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RButton StructType
 * @subpackage Structs
 */
class RButton extends AbstractStructBase
{
    /**
     * The feature
     * Meta information extracted from the WSDL
     * - documentation: The feature invoked by this button.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $feature;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - documentation: The label invoked by this button.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The buttonNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $buttonNumber;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RButton
     * @uses RButton::setFeature()
     * @uses RButton::setLabel()
     * @uses RButton::setButtonNumber()
     * @uses RButton::setUuid()
     * @param string $feature
     * @param string $label
     * @param string $buttonNumber
     * @param string $uuid
     */
    public function __construct($feature = null, $label = null, $buttonNumber = null, $uuid = null)
    {
        $this
            ->setFeature($feature)
            ->setLabel($label)
            ->setButtonNumber($buttonNumber)
            ->setUuid($uuid);
    }
    /**
     * Get feature value
     * @return string|null
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * Set feature value
     * @param string $feature
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RButton
     */
    public function setFeature($feature = null)
    {
        $this->feature = $feature;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RButton
     */
    public function setLabel($label = null)
    {
        $this->label = $label;
        return $this;
    }
    /**
     * Get buttonNumber value
     * @return string|null
     */
    public function getButtonNumber()
    {
        return $this->buttonNumber;
    }
    /**
     * Set buttonNumber value
     * @param string $buttonNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RButton
     */
    public function setButtonNumber($buttonNumber = null)
    {
        $this->buttonNumber = $buttonNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RButton
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
