<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAppUser StructType
 * @subpackage Structs
 */
class RAppUser extends AbstractStructBase
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: Valid range is 1-127 characters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The passwordCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - documentation: Valid range is 1-42 characters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestCredentials;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The acceptPresenceSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The isStandard
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isStandard;
    /**
     * The associatedDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The associatedGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The associatedCapfProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles
     */
    public $associatedCapfProfiles;
    /**
     * The ctiControlledDeviceProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAppUser
     * @uses RAppUser::setUserid()
     * @uses RAppUser::setPassword()
     * @uses RAppUser::setPasswordCredentials()
     * @uses RAppUser::setDigestCredentials()
     * @uses RAppUser::setPresenceGroupName()
     * @uses RAppUser::setAcceptPresenceSubscription()
     * @uses RAppUser::setAcceptOutOfDialogRefer()
     * @uses RAppUser::setAcceptUnsolicitedNotification()
     * @uses RAppUser::setAllowReplaceHeader()
     * @uses RAppUser::setIsStandard()
     * @uses RAppUser::setAssociatedDevices()
     * @uses RAppUser::setAssociatedGroups()
     * @uses RAppUser::setAssociatedCapfProfiles()
     * @uses RAppUser::setCtiControlledDeviceProfiles()
     * @uses RAppUser::setUuid()
     * @param string $userid
     * @param string $password
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @param string $digestCredentials
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $isStandard
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $uuid
     */
    public function __construct($userid = null, $password = null, \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null, $digestCredentials = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $acceptPresenceSubscription = null, $acceptOutOfDialogRefer = null, $acceptUnsolicitedNotification = null, $allowReplaceHeader = null, $isStandard = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null, \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $uuid = null)
    {
        $this
            ->setUserid($userid)
            ->setPassword($password)
            ->setPasswordCredentials($passwordCredentials)
            ->setDigestCredentials($digestCredentials)
            ->setPresenceGroupName($presenceGroupName)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setIsStandard($isStandard)
            ->setAssociatedDevices($associatedDevices)
            ->setAssociatedGroups($associatedGroups)
            ->setAssociatedCapfProfiles($associatedCapfProfiles)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setUuid($uuid);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setUserid($userid = null)
    {
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setPasswordCredentials(\\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = null)
    {
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = null)
    {
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = null)
    {
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setAllowReplaceHeader($allowReplaceHeader = null)
    {
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get isStandard value
     * @return string|null
     */
    public function getIsStandard()
    {
        return $this->isStandard;
    }
    /**
     * Set isStandard value
     * @param string $isStandard
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setIsStandard($isStandard = null)
    {
        $this->isStandard = $isStandard;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setAssociatedDevices(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setAssociatedGroups(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get associatedCapfProfiles value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles|null
     */
    public function getAssociatedCapfProfiles()
    {
        return $this->associatedCapfProfiles;
    }
    /**
     * Set associatedCapfProfiles value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setAssociatedCapfProfiles(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null)
    {
        $this->associatedCapfProfiles = $associatedCapfProfiles;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setCtiControlledDeviceProfiles(\\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAppUser
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
