<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAnalogPort StructType
 * @subpackage Structs
 */
class RAnalogPort extends AbstractStructBase
{
    /**
     * The portNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $portNumber;
    /**
     * The attendantDn
     * Meta information extracted from the WSDL
     * - documentation: Mandatory for ground start and loop start
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $attendantDn;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The callerIdEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callerIdEnable;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The digitSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitSending;
    /**
     * The expectedDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $expectedDigits;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Lines
     */
    public $lines;
    /**
     * The prefixDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDn;
    /**
     * The presentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $presentationBit;
    /**
     * The silenceSuppressionThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $silenceSuppressionThreshold;
    /**
     * The smdiPortNumber
     * Meta information extracted from the WSDL
     * - documentation: Not used by T1 Ports
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $smdiPortNumber;
    /**
     * The startDialProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startDialProtocol;
    /**
     * The trunk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunk;
    /**
     * The trunkDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkDirection;
    /**
     * The trunkLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkLevel;
    /**
     * The trunkPadRx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkPadRx;
    /**
     * The trunkPadTx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkPadTx;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - documentation: Arbitrary XML defined by 3rd party vendors.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The timer1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer1;
    /**
     * The timer2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer2;
    /**
     * The timer3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer3;
    /**
     * The timer4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer4;
    /**
     * The timer5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer5;
    /**
     * The timer6
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer6;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAnalogPort
     * @uses RAnalogPort::setPortNumber()
     * @uses RAnalogPort::setAttendantDn()
     * @uses RAnalogPort::setUnattendedPort()
     * @uses RAnalogPort::setCallerIdDn()
     * @uses RAnalogPort::setCallerIdEnable()
     * @uses RAnalogPort::setCallingPartySelection()
     * @uses RAnalogPort::setDigitSending()
     * @uses RAnalogPort::setExpectedDigits()
     * @uses RAnalogPort::setSigDigits()
     * @uses RAnalogPort::setLines()
     * @uses RAnalogPort::setPrefixDn()
     * @uses RAnalogPort::setPresentationBit()
     * @uses RAnalogPort::setSilenceSuppressionThreshold()
     * @uses RAnalogPort::setSmdiPortNumber()
     * @uses RAnalogPort::setStartDialProtocol()
     * @uses RAnalogPort::setTrunk()
     * @uses RAnalogPort::setTrunkDirection()
     * @uses RAnalogPort::setTrunkLevel()
     * @uses RAnalogPort::setTrunkPadRx()
     * @uses RAnalogPort::setTrunkPadTx()
     * @uses RAnalogPort::setVendorConfig()
     * @uses RAnalogPort::setTimer1()
     * @uses RAnalogPort::setTimer2()
     * @uses RAnalogPort::setTimer3()
     * @uses RAnalogPort::setTimer4()
     * @uses RAnalogPort::setTimer5()
     * @uses RAnalogPort::setTimer6()
     * @uses RAnalogPort::setUuid()
     * @param string $portNumber
     * @param string $attendantDn
     * @param string $unattendedPort
     * @param string $callerIdDn
     * @param string $callerIdEnable
     * @param string $callingPartySelection
     * @param string $digitSending
     * @param string $expectedDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @param string $prefixDn
     * @param string $presentationBit
     * @param string $silenceSuppressionThreshold
     * @param string $smdiPortNumber
     * @param string $startDialProtocol
     * @param string $trunk
     * @param string $trunkDirection
     * @param string $trunkLevel
     * @param string $trunkPadRx
     * @param string $trunkPadTx
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $timer1
     * @param string $timer2
     * @param string $timer3
     * @param string $timer4
     * @param string $timer5
     * @param string $timer6
     * @param string $uuid
     */
    public function __construct($portNumber = null, $attendantDn = null, $unattendedPort = null, $callerIdDn = null, $callerIdEnable = null, $callingPartySelection = null, $digitSending = null, $expectedDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null, $prefixDn = null, $presentationBit = null, $silenceSuppressionThreshold = null, $smdiPortNumber = null, $startDialProtocol = null, $trunk = null, $trunkDirection = null, $trunkLevel = null, $trunkPadRx = null, $trunkPadTx = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $timer1 = null, $timer2 = null, $timer3 = null, $timer4 = null, $timer5 = null, $timer6 = null, $uuid = null)
    {
        $this
            ->setPortNumber($portNumber)
            ->setAttendantDn($attendantDn)
            ->setUnattendedPort($unattendedPort)
            ->setCallerIdDn($callerIdDn)
            ->setCallerIdEnable($callerIdEnable)
            ->setCallingPartySelection($callingPartySelection)
            ->setDigitSending($digitSending)
            ->setExpectedDigits($expectedDigits)
            ->setSigDigits($sigDigits)
            ->setLines($lines)
            ->setPrefixDn($prefixDn)
            ->setPresentationBit($presentationBit)
            ->setSilenceSuppressionThreshold($silenceSuppressionThreshold)
            ->setSmdiPortNumber($smdiPortNumber)
            ->setStartDialProtocol($startDialProtocol)
            ->setTrunk($trunk)
            ->setTrunkDirection($trunkDirection)
            ->setTrunkLevel($trunkLevel)
            ->setTrunkPadRx($trunkPadRx)
            ->setTrunkPadTx($trunkPadTx)
            ->setVendorConfig($vendorConfig)
            ->setTimer1($timer1)
            ->setTimer2($timer2)
            ->setTimer3($timer3)
            ->setTimer4($timer4)
            ->setTimer5($timer5)
            ->setTimer6($timer6)
            ->setUuid($uuid);
    }
    /**
     * Get portNumber value
     * @return string|null
     */
    public function getPortNumber()
    {
        return $this->portNumber;
    }
    /**
     * Set portNumber value
     * @param string $portNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setPortNumber($portNumber = null)
    {
        $this->portNumber = $portNumber;
        return $this;
    }
    /**
     * Get attendantDn value
     * @return string|null
     */
    public function getAttendantDn()
    {
        return $this->attendantDn;
    }
    /**
     * Set attendantDn value
     * @param string $attendantDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setAttendantDn($attendantDn = null)
    {
        $this->attendantDn = $attendantDn;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callerIdEnable value
     * @return string|null
     */
    public function getCallerIdEnable()
    {
        return $this->callerIdEnable;
    }
    /**
     * Set callerIdEnable value
     * @param string $callerIdEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setCallerIdEnable($callerIdEnable = null)
    {
        $this->callerIdEnable = $callerIdEnable;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @param string $callingPartySelection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string|null
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @param string $digitSending
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setDigitSending($digitSending = null)
    {
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get expectedDigits value
     * @return string|null
     */
    public function getExpectedDigits()
    {
        return $this->expectedDigits;
    }
    /**
     * Set expectedDigits value
     * @param string $expectedDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setExpectedDigits($expectedDigits = null)
    {
        $this->expectedDigits = $expectedDigits;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setSigDigits(\\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get lines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setLines(\\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get prefixDn value
     * @return string|null
     */
    public function getPrefixDn()
    {
        return $this->prefixDn;
    }
    /**
     * Set prefixDn value
     * @param string $prefixDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setPrefixDn($prefixDn = null)
    {
        $this->prefixDn = $prefixDn;
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string|null
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @param string $presentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setPresentationBit($presentationBit = null)
    {
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get silenceSuppressionThreshold value
     * @return string|null
     */
    public function getSilenceSuppressionThreshold()
    {
        return $this->silenceSuppressionThreshold;
    }
    /**
     * Set silenceSuppressionThreshold value
     * @param string $silenceSuppressionThreshold
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setSilenceSuppressionThreshold($silenceSuppressionThreshold = null)
    {
        $this->silenceSuppressionThreshold = $silenceSuppressionThreshold;
        return $this;
    }
    /**
     * Get smdiPortNumber value
     * @return string|null
     */
    public function getSmdiPortNumber()
    {
        return $this->smdiPortNumber;
    }
    /**
     * Set smdiPortNumber value
     * @param string $smdiPortNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setSmdiPortNumber($smdiPortNumber = null)
    {
        $this->smdiPortNumber = $smdiPortNumber;
        return $this;
    }
    /**
     * Get startDialProtocol value
     * @return string|null
     */
    public function getStartDialProtocol()
    {
        return $this->startDialProtocol;
    }
    /**
     * Set startDialProtocol value
     * @param string $startDialProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setStartDialProtocol($startDialProtocol = null)
    {
        $this->startDialProtocol = $startDialProtocol;
        return $this;
    }
    /**
     * Get trunk value
     * @return string|null
     */
    public function getTrunk()
    {
        return $this->trunk;
    }
    /**
     * Set trunk value
     * @param string $trunk
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTrunk($trunk = null)
    {
        $this->trunk = $trunk;
        return $this;
    }
    /**
     * Get trunkDirection value
     * @return string|null
     */
    public function getTrunkDirection()
    {
        return $this->trunkDirection;
    }
    /**
     * Set trunkDirection value
     * @param string $trunkDirection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTrunkDirection($trunkDirection = null)
    {
        $this->trunkDirection = $trunkDirection;
        return $this;
    }
    /**
     * Get trunkLevel value
     * @return string|null
     */
    public function getTrunkLevel()
    {
        return $this->trunkLevel;
    }
    /**
     * Set trunkLevel value
     * @param string $trunkLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTrunkLevel($trunkLevel = null)
    {
        $this->trunkLevel = $trunkLevel;
        return $this;
    }
    /**
     * Get trunkPadRx value
     * @return string|null
     */
    public function getTrunkPadRx()
    {
        return $this->trunkPadRx;
    }
    /**
     * Set trunkPadRx value
     * @param string $trunkPadRx
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTrunkPadRx($trunkPadRx = null)
    {
        $this->trunkPadRx = $trunkPadRx;
        return $this;
    }
    /**
     * Get trunkPadTx value
     * @return string|null
     */
    public function getTrunkPadTx()
    {
        return $this->trunkPadTx;
    }
    /**
     * Set trunkPadTx value
     * @param string $trunkPadTx
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTrunkPadTx($trunkPadTx = null)
    {
        $this->trunkPadTx = $trunkPadTx;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get timer1 value
     * @return string|null
     */
    public function getTimer1()
    {
        return $this->timer1;
    }
    /**
     * Set timer1 value
     * @param string $timer1
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTimer1($timer1 = null)
    {
        $this->timer1 = $timer1;
        return $this;
    }
    /**
     * Get timer2 value
     * @return string|null
     */
    public function getTimer2()
    {
        return $this->timer2;
    }
    /**
     * Set timer2 value
     * @param string $timer2
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTimer2($timer2 = null)
    {
        $this->timer2 = $timer2;
        return $this;
    }
    /**
     * Get timer3 value
     * @return string|null
     */
    public function getTimer3()
    {
        return $this->timer3;
    }
    /**
     * Set timer3 value
     * @param string $timer3
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTimer3($timer3 = null)
    {
        $this->timer3 = $timer3;
        return $this;
    }
    /**
     * Get timer4 value
     * @return string|null
     */
    public function getTimer4()
    {
        return $this->timer4;
    }
    /**
     * Set timer4 value
     * @param string $timer4
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTimer4($timer4 = null)
    {
        $this->timer4 = $timer4;
        return $this;
    }
    /**
     * Get timer5 value
     * @return string|null
     */
    public function getTimer5()
    {
        return $this->timer5;
    }
    /**
     * Set timer5 value
     * @param string $timer5
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTimer5($timer5 = null)
    {
        $this->timer5 = $timer5;
        return $this;
    }
    /**
     * Get timer6 value
     * @return string|null
     */
    public function getTimer6()
    {
        return $this->timer6;
    }
    /**
     * Set timer6 value
     * @param string $timer6
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setTimer6($timer6 = null)
    {
        $this->timer6 = $timer6;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RAnalogPort
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
