<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for primaryExtension StructType
 * Meta information extracted from the WSDL
 * - documentation: Only DNs associated with the associatedDevices of the User can be used as primary extension.
 * @subpackage Structs
 */
class PrimaryExtension extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - documentation: DN or Pattern
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - documentation: Route Partition to which the DN is associated.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartitionName;
    /**
     * Constructor method for primaryExtension
     * @uses PrimaryExtension::setPattern()
     * @uses PrimaryExtension::setRoutePartitionName()
     * @param string $pattern
     * @param string $routePartitionName
     */
    public function __construct($pattern = null, $routePartitionName = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return string|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param string $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension
     */
    public function setRoutePartitionName($routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
}
