<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXPhone StructType
 * @subpackage Structs
 */
class OXPhone extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $commonPhoneConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $aarNeighborhoodName;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta information extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $geoLocationFilterName;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $phoneTemplateName;
    /**
     * The primaryPhoneName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $primaryPhoneName;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct
     */
    public $networkLocale;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $softkeyTemplateName;
    /**
     * The defaultProfileName
     * Meta information extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol
     */
    public $defaultProfileName;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $joinAcrossLines;
    /**
     * The builtInBridgeStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $builtInBridgeStatus;
    /**
     * The callInfoPrivacyStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The ownerUserName
     * Meta information extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct
     */
    public $ownerUserName;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $packetCaptureMode;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $presenceGroupName;
    /**
     * The certificateOperation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $keySize;
    /**
     * The deviceMobilityMode
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $deviceMobilityMode;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $dndRingSetting;
    /**
     * The mobilityUserIdName
     * Meta information extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta information extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $phoneServiceDisplay;
    /**
     * The mtpPreferedCodec
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct
     */
    public $dialRulesName;
    /**
     * The outboundCallRollover
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $outboundCallRollover;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $deviceTrustMode;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The cgpnIngressDN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $cgpnIngressDN;
    /**
     * The wifiHotspotProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $wifiHotspotProfile;
    /**
     * The wirelessLanProfileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXPhone
     * @uses OXPhone::setProduct()
     * @uses OXPhone::setClass()
     * @uses OXPhone::setProtocol()
     * @uses OXPhone::setProtocolSide()
     * @uses OXPhone::setCallingSearchSpaceName()
     * @uses OXPhone::setDevicePoolName()
     * @uses OXPhone::setCommonDeviceConfigName()
     * @uses OXPhone::setCommonPhoneConfigName()
     * @uses OXPhone::setNetworkLocation()
     * @uses OXPhone::setLocationName()
     * @uses OXPhone::setMediaResourceListName()
     * @uses OXPhone::setNetworkHoldMohAudioSourceId()
     * @uses OXPhone::setUserHoldMohAudioSourceId()
     * @uses OXPhone::setAutomatedAlternateRoutingCssName()
     * @uses OXPhone::setAarNeighborhoodName()
     * @uses OXPhone::setMlppIndicationStatus()
     * @uses OXPhone::setPreemption()
     * @uses OXPhone::setUseTrustedRelayPoint()
     * @uses OXPhone::setSecurityProfileName()
     * @uses OXPhone::setSipProfileName()
     * @uses OXPhone::setCgpnTransformationCssName()
     * @uses OXPhone::setGeoLocationName()
     * @uses OXPhone::setGeoLocationFilterName()
     * @uses OXPhone::setLines()
     * @uses OXPhone::setPhoneTemplateName()
     * @uses OXPhone::setPrimaryPhoneName()
     * @uses OXPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses OXPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses OXPhone::setBlfDirectedCallParks()
     * @uses OXPhone::setAddOnModules()
     * @uses OXPhone::setUserLocale()
     * @uses OXPhone::setNetworkLocale()
     * @uses OXPhone::setServices()
     * @uses OXPhone::setSoftkeyTemplateName()
     * @uses OXPhone::setDefaultProfileName()
     * @uses OXPhone::setSingleButtonBarge()
     * @uses OXPhone::setJoinAcrossLines()
     * @uses OXPhone::setBuiltInBridgeStatus()
     * @uses OXPhone::setCallInfoPrivacyStatus()
     * @uses OXPhone::setOwnerUserName()
     * @uses OXPhone::setPacketCaptureMode()
     * @uses OXPhone::setSubscribeCallingSearchSpaceName()
     * @uses OXPhone::setRerouteCallingSearchSpaceName()
     * @uses OXPhone::setPresenceGroupName()
     * @uses OXPhone::setCertificateOperation()
     * @uses OXPhone::setAuthenticationMode()
     * @uses OXPhone::setKeySize()
     * @uses OXPhone::setDeviceMobilityMode()
     * @uses OXPhone::setDndOption()
     * @uses OXPhone::setDndRingSetting()
     * @uses OXPhone::setMobilityUserIdName()
     * @uses OXPhone::setPhoneSuite()
     * @uses OXPhone::setPhoneServiceDisplay()
     * @uses OXPhone::setMtpPreferedCodec()
     * @uses OXPhone::setDialRulesName()
     * @uses OXPhone::setOutboundCallRollover()
     * @uses OXPhone::setAlwaysUsePrimeLine()
     * @uses OXPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses OXPhone::setFeatureControlPolicy()
     * @uses OXPhone::setDeviceTrustMode()
     * @uses OXPhone::setConfidentialAccess()
     * @uses OXPhone::setCgpnIngressDN()
     * @uses OXPhone::setWifiHotspotProfile()
     * @uses OXPhone::setWirelessLanProfileGroup()
     * @uses OXPhone::setCtiid()
     * @uses OXPhone::setUuid()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $product
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $class
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $protocol
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $commonDeviceConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $commonPhoneConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $networkLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mediaResourceListName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $networkHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mlppIndicationStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $preemption
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $useTrustedRelayPoint
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $securityProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cgpnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $geoLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $geoLocationFilterName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneTemplateName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $primaryPhoneName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $ringSettingIdleBlfAudibleAlert
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $ringSettingBusyBlfAudibleAlert
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $networkLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $softkeyTemplateName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $defaultProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $singleButtonBarge
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $joinAcrossLines
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $builtInBridgeStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInfoPrivacyStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $ownerUserName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $packetCaptureMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $subscribeCallingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rerouteCallingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $presenceGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $certificateOperation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $authenticationMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $keySize
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $deviceMobilityMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $dndOption
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndRingSetting
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mobilityUserIdName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneSuite
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneServiceDisplay
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mtpPreferedCodec
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $dialRulesName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $outboundCallRollover
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLine
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $featureControlPolicy
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $deviceTrustMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cgpnIngressDN
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $wifiHotspotProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $wirelessLanProfileGroup
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $product = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $class = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $protocol = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $protocolSide = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $commonDeviceConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $commonPhoneConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $networkLocation = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mediaResourceListName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $networkHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mlppIndicationStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $preemption = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $useTrustedRelayPoint = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $securityProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cgpnTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $geoLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $geoLocationFilterName = null, \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneTemplateName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $primaryPhoneName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $ringSettingIdleBlfAudibleAlert = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $ringSettingBusyBlfAudibleAlert = null, \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $networkLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $softkeyTemplateName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $defaultProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $singleButtonBarge = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $joinAcrossLines = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $builtInBridgeStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInfoPrivacyStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $ownerUserName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $packetCaptureMode = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $subscribeCallingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rerouteCallingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $presenceGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $certificateOperation = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $authenticationMode = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $keySize = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $deviceMobilityMode = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $dndOption = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndRingSetting = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mobilityUserIdName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneSuite = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneServiceDisplay = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mtpPreferedCodec = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $dialRulesName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $outboundCallRollover = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLine = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $featureControlPolicy = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $deviceTrustMode = null, \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cgpnIngressDN = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $wifiHotspotProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $wirelessLanProfileGroup = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setDefaultProfileName($defaultProfileName)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setOwnerUserName($ownerUserName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setPresenceGroupName($presenceGroupName)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setConfidentialAccess($confidentialAccess)
            ->setCgpnIngressDN($cgpnIngressDN)
            ->setWifiHotspotProfile($wifiHotspotProfile)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setProduct(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setClass(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setProtocol(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setProtocolSide(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $commonPhoneConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setCommonPhoneConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setNetworkLocation(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setNetworkHoldMohAudioSourceId(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setUserHoldMohAudioSourceId(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setMlppIndicationStatus(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $preemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setPreemption(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setUseTrustedRelayPoint(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $securityProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setSecurityProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setSipProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get lines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setLines(\\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setPhoneTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $primaryPhoneName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setPrimaryPhoneName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $ringSettingIdleBlfAudibleAlert
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setRingSettingIdleBlfAudibleAlert(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $ringSettingIdleBlfAudibleAlert = null)
    {
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $ringSettingBusyBlfAudibleAlert
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setRingSettingBusyBlfAudibleAlert(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $ringSettingBusyBlfAudibleAlert = null)
    {
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setBlfDirectedCallParks(\\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setAddOnModules(\\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setUserLocale(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setNetworkLocale(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get services value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setServices(\\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $softkeyTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setSoftkeyTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $defaultProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setDefaultProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $defaultProfileName = null)
    {
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $singleButtonBarge
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setSingleButtonBarge(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $joinAcrossLines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setJoinAcrossLines(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $builtInBridgeStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setBuiltInBridgeStatus(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $builtInBridgeStatus = null)
    {
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInfoPrivacyStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setCallInfoPrivacyStatus(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $ownerUserName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setOwnerUserName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setPacketCaptureMode(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $packetCaptureMode = null)
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $subscribeCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setSubscribeCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rerouteCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setRerouteCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $certificateOperation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setCertificateOperation(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $certificateOperation = null)
    {
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $authenticationMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setAuthenticationMode(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $authenticationMode = null)
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $keySize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setKeySize(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $keySize = null)
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $deviceMobilityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setDeviceMobilityMode(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $deviceMobilityMode = null)
    {
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get dndOption value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $dndOption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setDndOption(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndRingSetting
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setDndRingSetting(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getMobilityUserIdName()
    {
        return $this->mobilityUserIdName;
    }
    /**
     * Set mobilityUserIdName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mobilityUserIdName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setMobilityUserIdName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mobilityUserIdName = null)
    {
        $this->mobilityUserIdName = $mobilityUserIdName;
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneSuite
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setPhoneSuite(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneSuite = null)
    {
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneServiceDisplay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setPhoneServiceDisplay(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $phoneServiceDisplay = null)
    {
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mtpPreferedCodec
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setMtpPreferedCodec(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mtpPreferedCodec = null)
    {
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct|null
     */
    public function getDialRulesName()
    {
        return $this->dialRulesName;
    }
    /**
     * Set dialRulesName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $dialRulesName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setDialRulesName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $dialRulesName = null)
    {
        $this->dialRulesName = $dialRulesName;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $outboundCallRollover
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setOutboundCallRollover(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $outboundCallRollover = null)
    {
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLine
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setAlwaysUsePrimeLine(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $featureControlPolicy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setFeatureControlPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $deviceTrustMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setDeviceTrustMode(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $deviceTrustMode = null)
    {
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get cgpnIngressDN value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCgpnIngressDN()
    {
        return $this->cgpnIngressDN;
    }
    /**
     * Set cgpnIngressDN value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cgpnIngressDN
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setCgpnIngressDN(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cgpnIngressDN = null)
    {
        $this->cgpnIngressDN = $cgpnIngressDN;
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return $this->wifiHotspotProfile;
    }
    /**
     * Set wifiHotspotProfile value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $wifiHotspotProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setWifiHotspotProfile(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $wifiHotspotProfile = null)
    {
        $this->wifiHotspotProfile = $wifiHotspotProfile;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $wirelessLanProfileGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setWirelessLanProfileGroup(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXPhone
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
