<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXDeviceProfile StructType
 * @subpackage Structs
 */
class OXDeviceProfile extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $protocolSide;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $preemption;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol
     */
    public $phoneTemplateName;
    /**
     * The blfDirectedCallParks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $userLocale;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $joinAcrossLines;
    /**
     * The loginUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $loginUserId;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $dndRingSetting;
    /**
     * The emccCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $emccCallingSearchSpace;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $softkeyTemplateName;
    /**
     * The callInfoPrivacyStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Services
     */
    public $services;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $featureControlPolicy;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXDeviceProfile
     * @uses OXDeviceProfile::setProduct()
     * @uses OXDeviceProfile::setClass()
     * @uses OXDeviceProfile::setProtocol()
     * @uses OXDeviceProfile::setProtocolSide()
     * @uses OXDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses OXDeviceProfile::setMlppIndicationStatus()
     * @uses OXDeviceProfile::setPreemption()
     * @uses OXDeviceProfile::setLines()
     * @uses OXDeviceProfile::setPhoneTemplateName()
     * @uses OXDeviceProfile::setBlfDirectedCallParks()
     * @uses OXDeviceProfile::setAddOnModules()
     * @uses OXDeviceProfile::setUserLocale()
     * @uses OXDeviceProfile::setSingleButtonBarge()
     * @uses OXDeviceProfile::setJoinAcrossLines()
     * @uses OXDeviceProfile::setLoginUserId()
     * @uses OXDeviceProfile::setDndOption()
     * @uses OXDeviceProfile::setDndRingSetting()
     * @uses OXDeviceProfile::setEmccCallingSearchSpace()
     * @uses OXDeviceProfile::setAlwaysUsePrimeLine()
     * @uses OXDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses OXDeviceProfile::setSoftkeyTemplateName()
     * @uses OXDeviceProfile::setCallInfoPrivacyStatus()
     * @uses OXDeviceProfile::setServices()
     * @uses OXDeviceProfile::setFeatureControlPolicy()
     * @uses OXDeviceProfile::setCtiid()
     * @uses OXDeviceProfile::setUuid()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $product
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $class
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $protocol
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mlppIndicationStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $preemption
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $phoneTemplateName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $singleButtonBarge
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $joinAcrossLines
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $loginUserId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndOption
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndRingSetting
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $emccCallingSearchSpace
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLine
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $softkeyTemplateName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInfoPrivacyStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $featureControlPolicy
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $product = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $class = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $protocol = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $protocolSide = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mlppIndicationStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $preemption = null, \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $phoneTemplateName = null, \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $singleButtonBarge = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $joinAcrossLines = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $loginUserId = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndOption = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndRingSetting = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $emccCallingSearchSpace = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLine = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $softkeyTemplateName = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInfoPrivacyStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null, \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $featureControlPolicy = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setLoginUserId($loginUserId)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setServices($services)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setProduct(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setClass(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setProtocol(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setProtocolSide(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setUserHoldMohAudioSourceId(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setMlppIndicationStatus(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $preemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setPreemption(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get lines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setLines(\\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $phoneTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setPhoneTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setBlfDirectedCallParks(\\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setAddOnModules(\\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setUserLocale(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $singleButtonBarge
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setSingleButtonBarge(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $joinAcrossLines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setJoinAcrossLines(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $loginUserId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setLoginUserId(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $loginUserId = null)
    {
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get dndOption value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndOption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setDndOption(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndRingSetting
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setDndRingSetting(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return $this->emccCallingSearchSpace;
    }
    /**
     * Set emccCallingSearchSpace value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $emccCallingSearchSpace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setEmccCallingSearchSpace(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $emccCallingSearchSpace = null)
    {
        $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLine
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setAlwaysUsePrimeLine(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $softkeyTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setSoftkeyTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInfoPrivacyStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setCallInfoPrivacyStatus(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get services value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setServices(\\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $featureControlPolicy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setFeatureControlPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXDeviceProfile
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
