<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORLine StructType
 * @subpackage Structs
 */
class ORLine extends AbstractStructBase
{
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $aarNeighborhoodName;
    /**
     * The callForwardAll
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAll
     */
    public $callForwardAll;
    /**
     * The callForwardBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusy
     */
    public $callForwardBusy;
    /**
     * The callForwardBusyInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusyInt
     */
    public $callForwardBusyInt;
    /**
     * The callForwardNoAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswer
     */
    public $callForwardNoAnswer;
    /**
     * The callForwardNoAnswerInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswerInt
     */
    public $callForwardNoAnswerInt;
    /**
     * The callForwardNoCoverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverage
     */
    public $callForwardNoCoverage;
    /**
     * The callForwardNoCoverageInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverageInt
     */
    public $callForwardNoCoverageInt;
    /**
     * The callForwardOnFailure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardOnFailure
     */
    public $callForwardOnFailure;
    /**
     * The callForwardAlternateParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAlternateParty
     */
    public $callForwardAlternateParty;
    /**
     * The callForwardNotRegistered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegistered
     */
    public $callForwardNotRegistered;
    /**
     * The callForwardNotRegisteredInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegisteredInt
     */
    public $callForwardNotRegisteredInt;
    /**
     * The callPickupGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta information extracted from the WSDL
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $releaseClause;
    /**
     * The cfaCssPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The partyEntranceTone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $partyEntranceTone;
    /**
     * The directoryURIs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs
     */
    public $directoryURIs;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The externalCallControlProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $externalCallControlProfile;
    /**
     * The enterpriseAltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum
     */
    public $e164AltNum;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORLine
     * @uses ORLine::setUsage()
     * @uses ORLine::setRoutePartitionName()
     * @uses ORLine::setAarNeighborhoodName()
     * @uses ORLine::setCallForwardAll()
     * @uses ORLine::setCallForwardBusy()
     * @uses ORLine::setCallForwardBusyInt()
     * @uses ORLine::setCallForwardNoAnswer()
     * @uses ORLine::setCallForwardNoAnswerInt()
     * @uses ORLine::setCallForwardNoCoverage()
     * @uses ORLine::setCallForwardNoCoverageInt()
     * @uses ORLine::setCallForwardOnFailure()
     * @uses ORLine::setCallForwardAlternateParty()
     * @uses ORLine::setCallForwardNotRegistered()
     * @uses ORLine::setCallForwardNotRegisteredInt()
     * @uses ORLine::setCallPickupGroupName()
     * @uses ORLine::setAutoAnswer()
     * @uses ORLine::setNetworkHoldMohAudioSourceId()
     * @uses ORLine::setUserHoldMohAudioSourceId()
     * @uses ORLine::setPresenceGroupName()
     * @uses ORLine::setShareLineAppearanceCssName()
     * @uses ORLine::setVoiceMailProfileName()
     * @uses ORLine::setPatternPrecedence()
     * @uses ORLine::setReleaseClause()
     * @uses ORLine::setCfaCssPolicy()
     * @uses ORLine::setDefaultActivatedDeviceName()
     * @uses ORLine::setParkMonForwardNoRetrieveCssName()
     * @uses ORLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses ORLine::setPartyEntranceTone()
     * @uses ORLine::setDirectoryURIs()
     * @uses ORLine::setConfidentialAccess()
     * @uses ORLine::setExternalCallControlProfile()
     * @uses ORLine::setEnterpriseAltNum()
     * @uses ORLine::setE164AltNum()
     * @uses ORLine::setUuid()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $usage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routePartitionName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAll $callForwardAll
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusy $callForwardBusy
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusyInt $callForwardBusyInt
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswer $callForwardNoAnswer
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverage $callForwardNoCoverage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardOnFailure $callForwardOnFailure
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAlternateParty $callForwardAlternateParty
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegistered $callForwardNotRegistered
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callPickupGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $autoAnswer
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $networkHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $presenceGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $shareLineAppearanceCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $voiceMailProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $patternPrecedence
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $releaseClause
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $cfaCssPolicy
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $defaultActivatedDeviceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $parkMonForwardNoRetrieveCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $parkMonForwardNoRetrieveIntCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $partyEntranceTone
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $externalCallControlProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @param string $uuid
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $usage = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routePartitionName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAll $callForwardAll = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusy $callForwardBusy = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusyInt $callForwardBusyInt = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswer $callForwardNoAnswer = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswerInt $callForwardNoAnswerInt = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverage $callForwardNoCoverage = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverageInt $callForwardNoCoverageInt = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardOnFailure $callForwardOnFailure = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAlternateParty $callForwardAlternateParty = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegistered $callForwardNotRegistered = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callPickupGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $autoAnswer = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $networkHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $presenceGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $shareLineAppearanceCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $voiceMailProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $patternPrecedence = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $releaseClause = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $cfaCssPolicy = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $defaultActivatedDeviceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $parkMonForwardNoRetrieveCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $parkMonForwardNoRetrieveIntCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $partyEntranceTone = null, \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs = null, \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $externalCallControlProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null, \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCallForwardAll($callForwardAll)
            ->setCallForwardBusy($callForwardBusy)
            ->setCallForwardBusyInt($callForwardBusyInt)
            ->setCallForwardNoAnswer($callForwardNoAnswer)
            ->setCallForwardNoAnswerInt($callForwardNoAnswerInt)
            ->setCallForwardNoCoverage($callForwardNoCoverage)
            ->setCallForwardNoCoverageInt($callForwardNoCoverageInt)
            ->setCallForwardOnFailure($callForwardOnFailure)
            ->setCallForwardAlternateParty($callForwardAlternateParty)
            ->setCallForwardNotRegistered($callForwardNotRegistered)
            ->setCallForwardNotRegisteredInt($callForwardNotRegisteredInt)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setDirectoryURIs($directoryURIs)
            ->setConfidentialAccess($confidentialAccess)
            ->setExternalCallControlProfile($externalCallControlProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $usage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setUsage(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get callForwardAll value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAll|null
     */
    public function getCallForwardAll()
    {
        return $this->callForwardAll;
    }
    /**
     * Set callForwardAll value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAll $callForwardAll
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardAll(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAll $callForwardAll = null)
    {
        $this->callForwardAll = $callForwardAll;
        return $this;
    }
    /**
     * Get callForwardBusy value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusy|null
     */
    public function getCallForwardBusy()
    {
        return $this->callForwardBusy;
    }
    /**
     * Set callForwardBusy value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusy $callForwardBusy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardBusy(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusy $callForwardBusy = null)
    {
        $this->callForwardBusy = $callForwardBusy;
        return $this;
    }
    /**
     * Get callForwardBusyInt value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusyInt|null
     */
    public function getCallForwardBusyInt()
    {
        return $this->callForwardBusyInt;
    }
    /**
     * Set callForwardBusyInt value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusyInt $callForwardBusyInt
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardBusyInt(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardBusyInt $callForwardBusyInt = null)
    {
        $this->callForwardBusyInt = $callForwardBusyInt;
        return $this;
    }
    /**
     * Get callForwardNoAnswer value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswer|null
     */
    public function getCallForwardNoAnswer()
    {
        return $this->callForwardNoAnswer;
    }
    /**
     * Set callForwardNoAnswer value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswer $callForwardNoAnswer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardNoAnswer(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswer $callForwardNoAnswer = null)
    {
        $this->callForwardNoAnswer = $callForwardNoAnswer;
        return $this;
    }
    /**
     * Get callForwardNoAnswerInt value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswerInt|null
     */
    public function getCallForwardNoAnswerInt()
    {
        return $this->callForwardNoAnswerInt;
    }
    /**
     * Set callForwardNoAnswerInt value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardNoAnswerInt(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoAnswerInt $callForwardNoAnswerInt = null)
    {
        $this->callForwardNoAnswerInt = $callForwardNoAnswerInt;
        return $this;
    }
    /**
     * Get callForwardNoCoverage value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverage|null
     */
    public function getCallForwardNoCoverage()
    {
        return $this->callForwardNoCoverage;
    }
    /**
     * Set callForwardNoCoverage value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverage $callForwardNoCoverage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardNoCoverage(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverage $callForwardNoCoverage = null)
    {
        $this->callForwardNoCoverage = $callForwardNoCoverage;
        return $this;
    }
    /**
     * Get callForwardNoCoverageInt value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverageInt|null
     */
    public function getCallForwardNoCoverageInt()
    {
        return $this->callForwardNoCoverageInt;
    }
    /**
     * Set callForwardNoCoverageInt value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardNoCoverageInt(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNoCoverageInt $callForwardNoCoverageInt = null)
    {
        $this->callForwardNoCoverageInt = $callForwardNoCoverageInt;
        return $this;
    }
    /**
     * Get callForwardOnFailure value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardOnFailure|null
     */
    public function getCallForwardOnFailure()
    {
        return $this->callForwardOnFailure;
    }
    /**
     * Set callForwardOnFailure value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardOnFailure $callForwardOnFailure
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardOnFailure(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardOnFailure $callForwardOnFailure = null)
    {
        $this->callForwardOnFailure = $callForwardOnFailure;
        return $this;
    }
    /**
     * Get callForwardAlternateParty value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAlternateParty|null
     */
    public function getCallForwardAlternateParty()
    {
        return $this->callForwardAlternateParty;
    }
    /**
     * Set callForwardAlternateParty value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAlternateParty $callForwardAlternateParty
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardAlternateParty(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardAlternateParty $callForwardAlternateParty = null)
    {
        $this->callForwardAlternateParty = $callForwardAlternateParty;
        return $this;
    }
    /**
     * Get callForwardNotRegistered value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegistered|null
     */
    public function getCallForwardNotRegistered()
    {
        return $this->callForwardNotRegistered;
    }
    /**
     * Set callForwardNotRegistered value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegistered $callForwardNotRegistered
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardNotRegistered(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegistered $callForwardNotRegistered = null)
    {
        $this->callForwardNotRegistered = $callForwardNotRegistered;
        return $this;
    }
    /**
     * Get callForwardNotRegisteredInt value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegisteredInt|null
     */
    public function getCallForwardNotRegisteredInt()
    {
        return $this->callForwardNotRegisteredInt;
    }
    /**
     * Set callForwardNotRegisteredInt value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallForwardNotRegisteredInt(\\Losc\CucmBundle\Model\Webservice\StructType\ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null)
    {
        $this->callForwardNotRegisteredInt = $callForwardNotRegisteredInt;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callPickupGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCallPickupGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $autoAnswer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setAutoAnswer(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $autoAnswer = null)
    {
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setNetworkHoldMohAudioSourceId(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setUserHoldMohAudioSourceId(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return $this->shareLineAppearanceCssName;
    }
    /**
     * Set shareLineAppearanceCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $shareLineAppearanceCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setShareLineAppearanceCssName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $shareLineAppearanceCssName = null)
    {
        $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $voiceMailProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setVoiceMailProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $patternPrecedence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setPatternPrecedence(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $releaseClause
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setReleaseClause(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $cfaCssPolicy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setCfaCssPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $cfaCssPolicy = null)
    {
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return $this->defaultActivatedDeviceName;
    }
    /**
     * Set defaultActivatedDeviceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $defaultActivatedDeviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setDefaultActivatedDeviceName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $defaultActivatedDeviceName = null)
    {
        $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return $this->parkMonForwardNoRetrieveCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $parkMonForwardNoRetrieveCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setParkMonForwardNoRetrieveCssName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $parkMonForwardNoRetrieveCssName = null)
    {
        $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return $this->parkMonForwardNoRetrieveIntCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $parkMonForwardNoRetrieveIntCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $partyEntranceTone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setPartyEntranceTone(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $partyEntranceTone = null)
    {
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get directoryURIs value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs|null
     */
    public function getDirectoryURIs()
    {
        return $this->directoryURIs;
    }
    /**
     * Set directoryURIs value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setDirectoryURIs(\\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs = null)
    {
        $this->directoryURIs = $directoryURIs;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get externalCallControlProfile value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getExternalCallControlProfile()
    {
        return $this->externalCallControlProfile;
    }
    /**
     * Set externalCallControlProfile value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $externalCallControlProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setExternalCallControlProfile(\\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $externalCallControlProfile = null)
    {
        $this->externalCallControlProfile = $externalCallControlProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setEnterpriseAltNum(\\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setE164AltNum(\\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ORLine
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
