<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LUcService StructType
 * @subpackage Structs
 */
class LUcService extends AbstractStructBase
{
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The hostnameorip
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hostnameorip;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence) and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence),CTI and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LUcService
     * @uses LUcService::setServiceType()
     * @uses LUcService::setProductType()
     * @uses LUcService::setName()
     * @uses LUcService::setDescription()
     * @uses LUcService::setHostnameorip()
     * @uses LUcService::setPort()
     * @uses LUcService::setProtocol()
     * @uses LUcService::setUuid()
     * @param string $serviceType
     * @param string $productType
     * @param string $name
     * @param string $description
     * @param string $hostnameorip
     * @param string $port
     * @param string $protocol
     * @param string $uuid
     */
    public function __construct($serviceType = null, $productType = null, $name = null, $description = null, $hostnameorip = null, $port = null, $protocol = null, $uuid = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setProductType($productType)
            ->setName($name)
            ->setDescription($description)
            ->setHostnameorip($hostnameorip)
            ->setPort($port)
            ->setProtocol($protocol)
            ->setUuid($uuid);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LUcService
     */
    public function setServiceType($serviceType = null)
    {
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LUcService
     */
    public function setProductType($productType = null)
    {
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LUcService
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LUcService
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get hostnameorip value
     * @return string|null
     */
    public function getHostnameorip()
    {
        return $this->hostnameorip;
    }
    /**
     * Set hostnameorip value
     * @param string $hostnameorip
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LUcService
     */
    public function setHostnameorip($hostnameorip = null)
    {
        $this->hostnameorip = $hostnameorip;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LUcService
     */
    public function setPort($port = null)
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LUcService
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LUcService
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
