<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LTimeSchedule StructType
 * @subpackage Structs
 */
class LTimeSchedule extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta information extracted from the WSDL
     * - documentation: TimeSchedule cannot be published if it has a todOwnerId assigned to it. Only Administrative Time Schedule can be published.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The timeScheduleCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeScheduleCategory;
    /**
     * The todOwnerIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LTimeSchedule
     * @uses LTimeSchedule::setName()
     * @uses LTimeSchedule::setDescription()
     * @uses LTimeSchedule::setIsPublished()
     * @uses LTimeSchedule::setTimeScheduleCategory()
     * @uses LTimeSchedule::setTodOwnerIdName()
     * @uses LTimeSchedule::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isPublished
     * @param string $timeScheduleCategory
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isPublished = null, $timeScheduleCategory = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTimeScheduleCategory($timeScheduleCategory)
            ->setTodOwnerIdName($todOwnerIdName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTimeSchedule
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTimeSchedule
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTimeSchedule
     */
    public function setIsPublished($isPublished = null)
    {
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get timeScheduleCategory value
     * @return string|null
     */
    public function getTimeScheduleCategory()
    {
        return $this->timeScheduleCategory;
    }
    /**
     * Set timeScheduleCategory value
     * @param string $timeScheduleCategory
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTimeSchedule
     */
    public function setTimeScheduleCategory($timeScheduleCategory = null)
    {
        $this->timeScheduleCategory = $timeScheduleCategory;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return $this->todOwnerIdName;
    }
    /**
     * Set todOwnerIdName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTimeSchedule
     */
    public function setTodOwnerIdName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName = null)
    {
        $this->todOwnerIdName = $todOwnerIdName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTimeSchedule
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
