<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSyslogConfiguration StructType
 * @subpackage Structs
 */
class LSyslogConfiguration extends AbstractStructBase
{
    /**
     * The alarmConfigs
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig[]
     */
    public $alarmConfigs;
    /**
     * The serverName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serverName;
    /**
     * The serviceGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceGroup;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The EndPointAlarm
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $EndPointAlarm;
    /**
     * Constructor method for LSyslogConfiguration
     * @uses LSyslogConfiguration::setAlarmConfigs()
     * @uses LSyslogConfiguration::setServerName()
     * @uses LSyslogConfiguration::setServiceGroup()
     * @uses LSyslogConfiguration::setService()
     * @uses LSyslogConfiguration::setEndPointAlarm()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig[] $alarmConfigs
     * @param string $serverName
     * @param string $serviceGroup
     * @param string $service
     * @param string $endPointAlarm
     */
    public function __construct(array $alarmConfigs = array(), $serverName = null, $serviceGroup = null, $service = null, $endPointAlarm = null)
    {
        $this
            ->setAlarmConfigs($alarmConfigs)
            ->setServerName($serverName)
            ->setServiceGroup($serviceGroup)
            ->setService($service)
            ->setEndPointAlarm($endPointAlarm);
    }
    /**
     * Get alarmConfigs value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig[]
     */
    public function getAlarmConfigs()
    {
        return $this->alarmConfigs;
    }
    /**
     * Set alarmConfigs value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig[] $alarmConfigs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfiguration
     */
    public function setAlarmConfigs(array $alarmConfigs = array())
    {
        $this->alarmConfigs = $alarmConfigs;
        return $this;
    }
    /**
     * Add item to alarmConfigs value
     * @throws \InvalidArgumentException
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig $item
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfiguration
     */
    public function addToAlarmConfigs(\\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig $item)
    {
        $this->alarmConfigs[] = $item;
        return $this;
    }
    /**
     * Get serverName value
     * @return string|null
     */
    public function getServerName()
    {
        return $this->serverName;
    }
    /**
     * Set serverName value
     * @param string $serverName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfiguration
     */
    public function setServerName($serverName = null)
    {
        $this->serverName = $serverName;
        return $this;
    }
    /**
     * Get serviceGroup value
     * @return string|null
     */
    public function getServiceGroup()
    {
        return $this->serviceGroup;
    }
    /**
     * Set serviceGroup value
     * @param string $serviceGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfiguration
     */
    public function setServiceGroup($serviceGroup = null)
    {
        $this->serviceGroup = $serviceGroup;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfiguration
     */
    public function setService($service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get EndPointAlarm value
     * @return string|null
     */
    public function getEndPointAlarm()
    {
        return $this->EndPointAlarm;
    }
    /**
     * Set EndPointAlarm value
     * @param string $endPointAlarm
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfiguration
     */
    public function setEndPointAlarm($endPointAlarm = null)
    {
        $this->EndPointAlarm = $endPointAlarm;
        return $this;
    }
}
