<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipRealm StructType
 * @subpackage Structs
 */
class LSipRealm extends AbstractStructBase
{
    /**
     * The realm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $realm;
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestCredentials;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipRealm
     * @uses LSipRealm::setRealm()
     * @uses LSipRealm::setUserid()
     * @uses LSipRealm::setDigestCredentials()
     * @uses LSipRealm::setUuid()
     * @param string $realm
     * @param string $userid
     * @param string $digestCredentials
     * @param string $uuid
     */
    public function __construct($realm = null, $userid = null, $digestCredentials = null, $uuid = null)
    {
        $this
            ->setRealm($realm)
            ->setUserid($userid)
            ->setDigestCredentials($digestCredentials)
            ->setUuid($uuid);
    }
    /**
     * Get realm value
     * @return string|null
     */
    public function getRealm()
    {
        return $this->realm;
    }
    /**
     * Set realm value
     * @param string $realm
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipRealm
     */
    public function setRealm($realm = null)
    {
        $this->realm = $realm;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipRealm
     */
    public function setUserid($userid = null)
    {
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipRealm
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipRealm
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
