<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LServiceParameter StructType
 * @subpackage Structs
 */
class LServiceParameter extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - documentation: The process Node that this the service parameter belongs to. Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Name of the service parameter. Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - documentation: The service that this service parameter belongs to.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The valueType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $valueType;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LServiceParameter
     * @uses LServiceParameter::setProcessNodeName()
     * @uses LServiceParameter::setName()
     * @uses LServiceParameter::setService()
     * @uses LServiceParameter::setValue()
     * @uses LServiceParameter::setValueType()
     * @uses LServiceParameter::setUuid()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param string $name
     * @param string $service
     * @param string $value
     * @param string $valueType
     * @param string $uuid
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, $name = null, $service = null, $value = null, $valueType = null, $uuid = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setName($name)
            ->setService($service)
            ->setValue($value)
            ->setValueType($valueType)
            ->setUuid($uuid);
    }
    /**
     * Get processNodeName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LServiceParameter
     */
    public function setProcessNodeName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LServiceParameter
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LServiceParameter
     */
    public function setService($service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LServiceParameter
     */
    public function setValue($value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Get valueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->valueType;
    }
    /**
     * Set valueType value
     * @param string $valueType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LServiceParameter
     */
    public function setValueType($valueType = null)
    {
        $this->valueType = $valueType;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LServiceParameter
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
