<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LGatewayEndpointDigitalBri StructType
 * @subpackage Structs
 */
class LGatewayEndpointDigitalBri extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The briProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $briProtocol;
    /**
     * The calledPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPlan;
    /**
     * The calledPri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPri;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPlan;
    /**
     * The callingPri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPri;
    /**
     * The clockReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clockReference;
    /**
     * The csuParam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csuParam;
    /**
     * The dChannelEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dChannelEnable;
    /**
     * The channelSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $channelSelectionOrder;
    /**
     * The pcmType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pcmType;
    /**
     * The firstDelay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstDelay;
    /**
     * The intraDelay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $intraDelay;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The numDigitsToStrip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numDigitsToStrip;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The presentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $presentationBit;
    /**
     * The sendRestart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRestart;
    /**
     * The setupNonIsdnPi
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $setupNonIsdnPi;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The statusPoll
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $statusPoll;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The nationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The nationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $nationalTransformationCssName;
    /**
     * The internationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $internationalTransformationCssName;
    /**
     * The unknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $unknownTransformationCssName;
    /**
     * The subscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscriberTransformationCssName;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The GClearEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $GClearEnable;
    /**
     * The calledPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The useDevicePoolCalledCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssNatl;
    /**
     * The useDevicePoolCalledCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssIntl;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The useDevicePoolCalledCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssSubs;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LGatewayEndpointDigitalBri
     * @uses LGatewayEndpointDigitalBri::setIndex()
     * @uses LGatewayEndpointDigitalBri::setName()
     * @uses LGatewayEndpointDigitalBri::setDescription()
     * @uses LGatewayEndpointDigitalBri::setProduct()
     * @uses LGatewayEndpointDigitalBri::setModel()
     * @uses LGatewayEndpointDigitalBri::setClass()
     * @uses LGatewayEndpointDigitalBri::setProtocol()
     * @uses LGatewayEndpointDigitalBri::setProtocolSide()
     * @uses LGatewayEndpointDigitalBri::setCallingSearchSpaceName()
     * @uses LGatewayEndpointDigitalBri::setDevicePoolName()
     * @uses LGatewayEndpointDigitalBri::setCommonDeviceConfigName()
     * @uses LGatewayEndpointDigitalBri::setNetworkLocation()
     * @uses LGatewayEndpointDigitalBri::setLocationName()
     * @uses LGatewayEndpointDigitalBri::setMediaResourceListName()
     * @uses LGatewayEndpointDigitalBri::setNetworkLocale()
     * @uses LGatewayEndpointDigitalBri::setAutomatedAlternateRoutingCssName()
     * @uses LGatewayEndpointDigitalBri::setAarNeighborhoodName()
     * @uses LGatewayEndpointDigitalBri::setVendorConfig()
     * @uses LGatewayEndpointDigitalBri::setCgpnTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCss()
     * @uses LGatewayEndpointDigitalBri::setGeoLocationName()
     * @uses LGatewayEndpointDigitalBri::setRedirectInboundNumberIe()
     * @uses LGatewayEndpointDigitalBri::setBriProtocol()
     * @uses LGatewayEndpointDigitalBri::setCalledPlan()
     * @uses LGatewayEndpointDigitalBri::setCalledPri()
     * @uses LGatewayEndpointDigitalBri::setCallerIdDn()
     * @uses LGatewayEndpointDigitalBri::setCallingPartySelection()
     * @uses LGatewayEndpointDigitalBri::setCallingPlan()
     * @uses LGatewayEndpointDigitalBri::setCallingPri()
     * @uses LGatewayEndpointDigitalBri::setClockReference()
     * @uses LGatewayEndpointDigitalBri::setCsuParam()
     * @uses LGatewayEndpointDigitalBri::setDChannelEnable()
     * @uses LGatewayEndpointDigitalBri::setChannelSelectionOrder()
     * @uses LGatewayEndpointDigitalBri::setPcmType()
     * @uses LGatewayEndpointDigitalBri::setFirstDelay()
     * @uses LGatewayEndpointDigitalBri::setIntraDelay()
     * @uses LGatewayEndpointDigitalBri::setRedirectOutboundNumberIe()
     * @uses LGatewayEndpointDigitalBri::setNumDigitsToStrip()
     * @uses LGatewayEndpointDigitalBri::setPrefix()
     * @uses LGatewayEndpointDigitalBri::setPresentationBit()
     * @uses LGatewayEndpointDigitalBri::setSendRestart()
     * @uses LGatewayEndpointDigitalBri::setSetupNonIsdnPi()
     * @uses LGatewayEndpointDigitalBri::setSigDigits()
     * @uses LGatewayEndpointDigitalBri::setStatusPoll()
     * @uses LGatewayEndpointDigitalBri::setPacketCaptureMode()
     * @uses LGatewayEndpointDigitalBri::setPacketCaptureDuration()
     * @uses LGatewayEndpointDigitalBri::setCdpnTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCdpnTransformCss()
     * @uses LGatewayEndpointDigitalBri::setGeoLocationFilterName()
     * @uses LGatewayEndpointDigitalBri::setNationalPrefix()
     * @uses LGatewayEndpointDigitalBri::setInternationalPrefix()
     * @uses LGatewayEndpointDigitalBri::setUnknownPrefix()
     * @uses LGatewayEndpointDigitalBri::setSubscriberPrefix()
     * @uses LGatewayEndpointDigitalBri::setNationalStripDigits()
     * @uses LGatewayEndpointDigitalBri::setInternationalStripDigits()
     * @uses LGatewayEndpointDigitalBri::setUnknownStripDigits()
     * @uses LGatewayEndpointDigitalBri::setSubscriberStripDigits()
     * @uses LGatewayEndpointDigitalBri::setNationalTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setInternationalTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setUnknownTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setSubscriberTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setPstnAccess()
     * @uses LGatewayEndpointDigitalBri::setImeE164TransformationName()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssNatl()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssIntl()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssSubs()
     * @uses LGatewayEndpointDigitalBri::setGClearEnable()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyNationalPrefix()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyInternationalPrefix()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyUnknownPrefix()
     * @uses LGatewayEndpointDigitalBri::setCalledPartySubscriberPrefix()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyNationalStripDigits()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyInternationalStripDigits()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyUnknownStripDigits()
     * @uses LGatewayEndpointDigitalBri::setCalledPartySubscriberStripDigits()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyNationalTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyInternationalTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setCalledPartyUnknownTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setCalledPartySubscriberTransformationCssName()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCalledCssNatl()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCalledCssIntl()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCalledCssUnkn()
     * @uses LGatewayEndpointDigitalBri::setUseDevicePoolCalledCssSubs()
     * @uses LGatewayEndpointDigitalBri::setCtiid()
     * @uses LGatewayEndpointDigitalBri::setUuid()
     * @param string $index
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param string $networkLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param string $redirectInboundNumberIe
     * @param string $briProtocol
     * @param string $calledPlan
     * @param string $calledPri
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingPlan
     * @param string $callingPri
     * @param string $clockReference
     * @param string $csuParam
     * @param string $dChannelEnable
     * @param string $channelSelectionOrder
     * @param string $pcmType
     * @param string $firstDelay
     * @param string $intraDelay
     * @param string $redirectOutboundNumberIe
     * @param string $numDigitsToStrip
     * @param string $prefix
     * @param string $presentationBit
     * @param string $sendRestart
     * @param string $setupNonIsdnPi
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $statusPoll
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @param string $pstnAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $gClearEnable
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param string $useDevicePoolCalledCssNatl
     * @param string $useDevicePoolCalledCssIntl
     * @param string $useDevicePoolCalledCssUnkn
     * @param string $useDevicePoolCalledCssSubs
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, $networkLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, $redirectInboundNumberIe = null, $briProtocol = null, $calledPlan = null, $calledPri = null, $callerIdDn = null, $callingPartySelection = null, $callingPlan = null, $callingPri = null, $clockReference = null, $csuParam = null, $dChannelEnable = null, $channelSelectionOrder = null, $pcmType = null, $firstDelay = null, $intraDelay = null, $redirectOutboundNumberIe = null, $numDigitsToStrip = null, $prefix = null, $presentationBit = null, $sendRestart = null, $setupNonIsdnPi = null, \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null, $statusPoll = null, $packetCaptureMode = null, $packetCaptureDuration = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null, $pstnAccess = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null, $useDevicePoolCgpnTransformCssNatl = null, $useDevicePoolCgpnTransformCssIntl = null, $useDevicePoolCgpnTransformCssUnkn = null, $useDevicePoolCgpnTransformCssSubs = null, $gClearEnable = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null, $useDevicePoolCalledCssNatl = null, $useDevicePoolCalledCssIntl = null, $useDevicePoolCalledCssUnkn = null, $useDevicePoolCalledCssSubs = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkLocale($networkLocale)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setVendorConfig($vendorConfig)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setBriProtocol($briProtocol)
            ->setCalledPlan($calledPlan)
            ->setCalledPri($calledPri)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingPlan($callingPlan)
            ->setCallingPri($callingPri)
            ->setClockReference($clockReference)
            ->setCsuParam($csuParam)
            ->setDChannelEnable($dChannelEnable)
            ->setChannelSelectionOrder($channelSelectionOrder)
            ->setPcmType($pcmType)
            ->setFirstDelay($firstDelay)
            ->setIntraDelay($intraDelay)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setNumDigitsToStrip($numDigitsToStrip)
            ->setPrefix($prefix)
            ->setPresentationBit($presentationBit)
            ->setSendRestart($sendRestart)
            ->setSetupNonIsdnPi($setupNonIsdnPi)
            ->setSigDigits($sigDigits)
            ->setStatusPoll($statusPoll)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalTransformationCssName($nationalTransformationCssName)
            ->setInternationalTransformationCssName($internationalTransformationCssName)
            ->setUnknownTransformationCssName($unknownTransformationCssName)
            ->setSubscriberTransformationCssName($subscriberTransformationCssName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setGClearEnable($gClearEnable)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl)
            ->setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param string $index
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setIndex($index = null)
    {
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setModel($model = null)
    {
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setProtocolSide($protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setNetworkLocation($networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setNetworkLocale($networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get briProtocol value
     * @return string|null
     */
    public function getBriProtocol()
    {
        return $this->briProtocol;
    }
    /**
     * Set briProtocol value
     * @param string $briProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setBriProtocol($briProtocol = null)
    {
        $this->briProtocol = $briProtocol;
        return $this;
    }
    /**
     * Get calledPlan value
     * @return string|null
     */
    public function getCalledPlan()
    {
        return $this->calledPlan;
    }
    /**
     * Set calledPlan value
     * @param string $calledPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPlan($calledPlan = null)
    {
        $this->calledPlan = $calledPlan;
        return $this;
    }
    /**
     * Get calledPri value
     * @return string|null
     */
    public function getCalledPri()
    {
        return $this->calledPri;
    }
    /**
     * Set calledPri value
     * @param string $calledPri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPri($calledPri = null)
    {
        $this->calledPri = $calledPri;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @param string $callingPartySelection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingPlan value
     * @return string|null
     */
    public function getCallingPlan()
    {
        return $this->callingPlan;
    }
    /**
     * Set callingPlan value
     * @param string $callingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCallingPlan($callingPlan = null)
    {
        $this->callingPlan = $callingPlan;
        return $this;
    }
    /**
     * Get callingPri value
     * @return string|null
     */
    public function getCallingPri()
    {
        return $this->callingPri;
    }
    /**
     * Set callingPri value
     * @param string $callingPri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCallingPri($callingPri = null)
    {
        $this->callingPri = $callingPri;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string|null
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @param string $clockReference
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setClockReference($clockReference = null)
    {
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string|null
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @param string $csuParam
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCsuParam($csuParam = null)
    {
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get dChannelEnable value
     * @return string|null
     */
    public function getDChannelEnable()
    {
        return $this->dChannelEnable;
    }
    /**
     * Set dChannelEnable value
     * @param string $dChannelEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setDChannelEnable($dChannelEnable = null)
    {
        $this->dChannelEnable = $dChannelEnable;
        return $this;
    }
    /**
     * Get channelSelectionOrder value
     * @return string|null
     */
    public function getChannelSelectionOrder()
    {
        return $this->channelSelectionOrder;
    }
    /**
     * Set channelSelectionOrder value
     * @param string $channelSelectionOrder
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setChannelSelectionOrder($channelSelectionOrder = null)
    {
        $this->channelSelectionOrder = $channelSelectionOrder;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string|null
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @param string $pcmType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setPcmType($pcmType = null)
    {
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get firstDelay value
     * @return string|null
     */
    public function getFirstDelay()
    {
        return $this->firstDelay;
    }
    /**
     * Set firstDelay value
     * @param string $firstDelay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setFirstDelay($firstDelay = null)
    {
        $this->firstDelay = $firstDelay;
        return $this;
    }
    /**
     * Get intraDelay value
     * @return string|null
     */
    public function getIntraDelay()
    {
        return $this->intraDelay;
    }
    /**
     * Set intraDelay value
     * @param string $intraDelay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setIntraDelay($intraDelay = null)
    {
        $this->intraDelay = $intraDelay;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get numDigitsToStrip value
     * @return string|null
     */
    public function getNumDigitsToStrip()
    {
        return $this->numDigitsToStrip;
    }
    /**
     * Set numDigitsToStrip value
     * @param string $numDigitsToStrip
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setNumDigitsToStrip($numDigitsToStrip = null)
    {
        $this->numDigitsToStrip = $numDigitsToStrip;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setPrefix($prefix = null)
    {
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string|null
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @param string $presentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setPresentationBit($presentationBit = null)
    {
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get sendRestart value
     * @return string|null
     */
    public function getSendRestart()
    {
        return $this->sendRestart;
    }
    /**
     * Set sendRestart value
     * @param string $sendRestart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setSendRestart($sendRestart = null)
    {
        $this->sendRestart = $sendRestart;
        return $this;
    }
    /**
     * Get setupNonIsdnPi value
     * @return string|null
     */
    public function getSetupNonIsdnPi()
    {
        return $this->setupNonIsdnPi;
    }
    /**
     * Set setupNonIsdnPi value
     * @param string $setupNonIsdnPi
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setSetupNonIsdnPi($setupNonIsdnPi = null)
    {
        $this->setupNonIsdnPi = $setupNonIsdnPi;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setSigDigits(\\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get statusPoll value
     * @return string|null
     */
    public function getStatusPoll()
    {
        return $this->statusPoll;
    }
    /**
     * Set statusPoll value
     * @param string $statusPoll
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setStatusPoll($statusPoll = null)
    {
        $this->statusPoll = $statusPoll;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param string $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @param string $packetCaptureDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return $this->nationalStripDigits;
    }
    /**
     * Set nationalStripDigits value
     * @param string $nationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        $this->nationalStripDigits = $nationalStripDigits;
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return $this->internationalStripDigits;
    }
    /**
     * Set internationalStripDigits value
     * @param string $internationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        $this->internationalStripDigits = $internationalStripDigits;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return $this->unknownStripDigits;
    }
    /**
     * Set unknownStripDigits value
     * @param string $unknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        $this->unknownStripDigits = $unknownStripDigits;
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return $this->subscriberStripDigits;
    }
    /**
     * Set subscriberStripDigits value
     * @param string $subscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        $this->subscriberStripDigits = $subscriberStripDigits;
        return $this;
    }
    /**
     * Get nationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNationalTransformationCssName()
    {
        return $this->nationalTransformationCssName;
    }
    /**
     * Set nationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null)
    {
        $this->nationalTransformationCssName = $nationalTransformationCssName;
        return $this;
    }
    /**
     * Get internationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInternationalTransformationCssName()
    {
        return $this->internationalTransformationCssName;
    }
    /**
     * Set internationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null)
    {
        $this->internationalTransformationCssName = $internationalTransformationCssName;
        return $this;
    }
    /**
     * Get unknownTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUnknownTransformationCssName()
    {
        return $this->unknownTransformationCssName;
    }
    /**
     * Set unknownTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null)
    {
        $this->unknownTransformationCssName = $unknownTransformationCssName;
        return $this;
    }
    /**
     * Get subscriberTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscriberTransformationCssName()
    {
        return $this->subscriberTransformationCssName;
    }
    /**
     * Set subscriberTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setSubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null)
    {
        $this->subscriberTransformationCssName = $subscriberTransformationCssName;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setPstnAccess($pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setImeE164TransformationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = null)
    {
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = null)
    {
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = null)
    {
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = null)
    {
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get GClearEnable value
     * @return string|null
     */
    public function getGClearEnable()
    {
        return $this->GClearEnable;
    }
    /**
     * Set GClearEnable value
     * @param string $gClearEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setGClearEnable($gClearEnable = null)
    {
        $this->GClearEnable = $gClearEnable;
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return $this->calledPartyNationalStripDigits;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * @param string $calledPartyNationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return $this->calledPartyInternationalStripDigits;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * @param string $calledPartyInternationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return $this->calledPartyUnknownStripDigits;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * @param string $calledPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return $this->calledPartySubscriberStripDigits;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * @param string $calledPartySubscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return $this->calledPartyNationalTransformationCssName;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return $this->calledPartyInternationalTransformationCssName;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return $this->calledPartyUnknownTransformationCssName;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return $this->calledPartySubscriberTransformationCssName;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCalledPartySubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssNatl()
    {
        return $this->useDevicePoolCalledCssNatl;
    }
    /**
     * Set useDevicePoolCalledCssNatl value
     * @param string $useDevicePoolCalledCssNatl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl = null)
    {
        $this->useDevicePoolCalledCssNatl = $useDevicePoolCalledCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssIntl()
    {
        return $this->useDevicePoolCalledCssIntl;
    }
    /**
     * Set useDevicePoolCalledCssIntl value
     * @param string $useDevicePoolCalledCssIntl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl = null)
    {
        $this->useDevicePoolCalledCssIntl = $useDevicePoolCalledCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = null)
    {
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssSubs()
    {
        return $this->useDevicePoolCalledCssSubs;
    }
    /**
     * Set useDevicePoolCalledCssSubs value
     * @param string $useDevicePoolCalledCssSubs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs = null)
    {
        $this->useDevicePoolCalledCssSubs = $useDevicePoolCalledCssSubs;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LGatewayEndpointDigitalBri
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
