<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDdi StructType
 * @subpackage Structs
 */
class LDdi extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The clause
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clause;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitAnalysisId
     * Meta information extracted from the WSDL
     * - documentation: Read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitAnalysisId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDdi
     * @uses LDdi::setName()
     * @uses LDdi::setClause()
     * @uses LDdi::setDialPlanName()
     * @uses LDdi::setDigitAnalysisId()
     * @uses LDdi::setUuid()
     * @param string $name
     * @param string $clause
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param string $digitAnalysisId
     * @param string $uuid
     */
    public function __construct($name = null, $clause = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, $digitAnalysisId = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setClause($clause)
            ->setDialPlanName($dialPlanName)
            ->setDigitAnalysisId($digitAnalysisId)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LDdi
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get clause value
     * @return string|null
     */
    public function getClause()
    {
        return $this->clause;
    }
    /**
     * Set clause value
     * @param string $clause
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LDdi
     */
    public function setClause($clause = null)
    {
        $this->clause = $clause;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LDdi
     */
    public function setDialPlanName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitAnalysisId value
     * @return string|null
     */
    public function getDigitAnalysisId()
    {
        return $this->digitAnalysisId;
    }
    /**
     * Set digitAnalysisId value
     * @param string $digitAnalysisId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LDdi
     */
    public function setDigitAnalysisId($digitAnalysisId = null)
    {
        $this->digitAnalysisId = $digitAnalysisId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LDdi
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
