<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LConferenceBridge StructType
 * @subpackage Structs
 */
class LConferenceBridge extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:Name
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The subUnit
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values range from 1 to 4.The value should be given as per the formula. Cisco Media Server : subunit = ((Extract two digits after 'A'
     * from the name)-2)/3 + 1. Cisco Conference Bridge: subunit = ((Extract two digits after 'C' from the name)-1)/3 + 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subUnit;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: This tag is used only by Cisco Conference Bridge Hardware.For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the
     * product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The maximumCapacity
     * Meta information extracted from the WSDL
     * - documentation: This tag is mandatory for Cisco Conference Bridge(WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maximumCapacity;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco IOS Enhanced Conference Bridge
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The destinationAddress
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destinationAddress;
    /**
     * The mcuConferenceBridgeSipPort
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mcuConferenceBridgeSipPort;
    /**
     * The sipProfile
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipProfile;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The normalizationScript
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $normalizationScript;
    /**
     * The enableTrace
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTrace;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The httpPort
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $httpPort;
    /**
     * The useHttps
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHttps;
    /**
     * The conferenceBridgePrefix
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $conferenceBridgePrefix;
    /**
     * The overrideSIPTrunkAddress
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideSIPTrunkAddress;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LConferenceBridge
     * @uses LConferenceBridge::setName()
     * @uses LConferenceBridge::setDescription()
     * @uses LConferenceBridge::setProduct()
     * @uses LConferenceBridge::setDevicePoolName()
     * @uses LConferenceBridge::setCommonDeviceConfigName()
     * @uses LConferenceBridge::setLocationName()
     * @uses LConferenceBridge::setSubUnit()
     * @uses LConferenceBridge::setLoadInformation()
     * @uses LConferenceBridge::setMaximumCapacity()
     * @uses LConferenceBridge::setUseTrustedRelayPoint()
     * @uses LConferenceBridge::setSecurityProfileName()
     * @uses LConferenceBridge::setDestinationAddress()
     * @uses LConferenceBridge::setMcuConferenceBridgeSipPort()
     * @uses LConferenceBridge::setSipProfile()
     * @uses LConferenceBridge::setSrtpAllowed()
     * @uses LConferenceBridge::setNormalizationScript()
     * @uses LConferenceBridge::setEnableTrace()
     * @uses LConferenceBridge::setUserName()
     * @uses LConferenceBridge::setPassword()
     * @uses LConferenceBridge::setHttpPort()
     * @uses LConferenceBridge::setUseHttps()
     * @uses LConferenceBridge::setConferenceBridgePrefix()
     * @uses LConferenceBridge::setOverrideSIPTrunkAddress()
     * @uses LConferenceBridge::setSipTrunkName()
     * @uses LConferenceBridge::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $subUnit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param string $maximumCapacity
     * @param string $useTrustedRelayPoint
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param string $destinationAddress
     * @param string $mcuConferenceBridgeSipPort
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile
     * @param string $srtpAllowed
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript
     * @param string $enableTrace
     * @param string $userName
     * @param string $password
     * @param string $httpPort
     * @param string $useHttps
     * @param string $conferenceBridgePrefix
     * @param string $overrideSIPTrunkAddress
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $subUnit = null, \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, $maximumCapacity = null, $useTrustedRelayPoint = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, $destinationAddress = null, $mcuConferenceBridgeSipPort = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile = null, $srtpAllowed = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript = null, $enableTrace = null, $userName = null, $password = null, $httpPort = null, $useHttps = null, $conferenceBridgePrefix = null, $overrideSIPTrunkAddress = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setSubUnit($subUnit)
            ->setLoadInformation($loadInformation)
            ->setMaximumCapacity($maximumCapacity)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setDestinationAddress($destinationAddress)
            ->setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort)
            ->setSipProfile($sipProfile)
            ->setSrtpAllowed($srtpAllowed)
            ->setNormalizationScript($normalizationScript)
            ->setEnableTrace($enableTrace)
            ->setUserName($userName)
            ->setPassword($password)
            ->setHttpPort($httpPort)
            ->setUseHttps($useHttps)
            ->setConferenceBridgePrefix($conferenceBridgePrefix)
            ->setOverrideSIPTrunkAddress($overrideSIPTrunkAddress)
            ->setSipTrunkName($sipTrunkName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @param string $subUnit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setSubUnit($subUnit = null)
    {
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @param string $maximumCapacity
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setSecurityProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get mcuConferenceBridgeSipPort value
     * @return string|null
     */
    public function getMcuConferenceBridgeSipPort()
    {
        return $this->mcuConferenceBridgeSipPort;
    }
    /**
     * Set mcuConferenceBridgeSipPort value
     * @param string $mcuConferenceBridgeSipPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort = null)
    {
        $this->mcuConferenceBridgeSipPort = $mcuConferenceBridgeSipPort;
        return $this;
    }
    /**
     * Get sipProfile value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipProfile()
    {
        return $this->sipProfile;
    }
    /**
     * Set sipProfile value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setSipProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile = null)
    {
        $this->sipProfile = $sipProfile;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get normalizationScript value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNormalizationScript()
    {
        return $this->normalizationScript;
    }
    /**
     * Set normalizationScript value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setNormalizationScript(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript = null)
    {
        $this->normalizationScript = $normalizationScript;
        return $this;
    }
    /**
     * Get enableTrace value
     * @return string|null
     */
    public function getEnableTrace()
    {
        return $this->enableTrace;
    }
    /**
     * Set enableTrace value
     * @param string $enableTrace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setEnableTrace($enableTrace = null)
    {
        $this->enableTrace = $enableTrace;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setUserName($userName = null)
    {
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get httpPort value
     * @return string|null
     */
    public function getHttpPort()
    {
        return $this->httpPort;
    }
    /**
     * Set httpPort value
     * @param string $httpPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setHttpPort($httpPort = null)
    {
        $this->httpPort = $httpPort;
        return $this;
    }
    /**
     * Get useHttps value
     * @return string|null
     */
    public function getUseHttps()
    {
        return $this->useHttps;
    }
    /**
     * Set useHttps value
     * @param string $useHttps
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setUseHttps($useHttps = null)
    {
        $this->useHttps = $useHttps;
        return $this;
    }
    /**
     * Get conferenceBridgePrefix value
     * @return string|null
     */
    public function getConferenceBridgePrefix()
    {
        return $this->conferenceBridgePrefix;
    }
    /**
     * Set conferenceBridgePrefix value
     * @param string $conferenceBridgePrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setConferenceBridgePrefix($conferenceBridgePrefix = null)
    {
        $this->conferenceBridgePrefix = $conferenceBridgePrefix;
        return $this;
    }
    /**
     * Get overrideSIPTrunkAddress value
     * @return string|null
     */
    public function getOverrideSIPTrunkAddress()
    {
        return $this->overrideSIPTrunkAddress;
    }
    /**
     * Set overrideSIPTrunkAddress value
     * @param string $overrideSIPTrunkAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setOverrideSIPTrunkAddress($overrideSIPTrunkAddress = null)
    {
        $this->overrideSIPTrunkAddress = $overrideSIPTrunkAddress;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setSipTrunkName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LConferenceBridge
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
