<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCommonDeviceConfig StructType
 * @subpackage Structs
 */
class LCommonDeviceConfig extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XUserLocale in AXLEnums.xsd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affect devices that support MLPP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - documentation: Default is not applicable for CommonDeviceConfig API
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affect devices that support MLPP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The ipAddressingMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressingMode;
    /**
     * The ipAddressingModePreferenceControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressingModePreferenceControl;
    /**
     * The allowAutoConfigurationForPhones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $allowAutoConfigurationForPhones;
    /**
     * The useImeForOutboundCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useImeForOutboundCalls;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The allowDuplicateAddressDetection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $allowDuplicateAddressDetection;
    /**
     * The acceptRedirectMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $acceptRedirectMessages;
    /**
     * The replyMulticastEchoRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $replyMulticastEchoRequest;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCommonDeviceConfig
     * @uses LCommonDeviceConfig::setName()
     * @uses LCommonDeviceConfig::setSoftkeyTemplateName()
     * @uses LCommonDeviceConfig::setUserLocale()
     * @uses LCommonDeviceConfig::setNetworkHoldMohAudioSourceId()
     * @uses LCommonDeviceConfig::setUserHoldMohAudioSourceId()
     * @uses LCommonDeviceConfig::setMlppIndicationStatus()
     * @uses LCommonDeviceConfig::setUseTrustedRelayPoint()
     * @uses LCommonDeviceConfig::setPreemption()
     * @uses LCommonDeviceConfig::setIpAddressingMode()
     * @uses LCommonDeviceConfig::setIpAddressingModePreferenceControl()
     * @uses LCommonDeviceConfig::setAllowAutoConfigurationForPhones()
     * @uses LCommonDeviceConfig::setUseImeForOutboundCalls()
     * @uses LCommonDeviceConfig::setConfidentialAccess()
     * @uses LCommonDeviceConfig::setAllowDuplicateAddressDetection()
     * @uses LCommonDeviceConfig::setAcceptRedirectMessages()
     * @uses LCommonDeviceConfig::setReplyMulticastEchoRequest()
     * @uses LCommonDeviceConfig::setUuid()
     * @param string $name
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @param string $userLocale
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $mlppIndicationStatus
     * @param string $useTrustedRelayPoint
     * @param string $preemption
     * @param string $ipAddressingMode
     * @param string $ipAddressingModePreferenceControl
     * @param string $allowAutoConfigurationForPhones
     * @param string $useImeForOutboundCalls
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param string $allowDuplicateAddressDetection
     * @param string $acceptRedirectMessages
     * @param string $replyMulticastEchoRequest
     * @param string $uuid
     */
    public function __construct($name = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null, $userLocale = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $mlppIndicationStatus = null, $useTrustedRelayPoint = null, $preemption = null, $ipAddressingMode = null, $ipAddressingModePreferenceControl = null, $allowAutoConfigurationForPhones = null, $useImeForOutboundCalls = null, \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, $allowDuplicateAddressDetection = null, $acceptRedirectMessages = null, $replyMulticastEchoRequest = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setUserLocale($userLocale)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setPreemption($preemption)
            ->setIpAddressingMode($ipAddressingMode)
            ->setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl)
            ->setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones)
            ->setUseImeForOutboundCalls($useImeForOutboundCalls)
            ->setConfidentialAccess($confidentialAccess)
            ->setAllowDuplicateAddressDetection($allowDuplicateAddressDetection)
            ->setAcceptRedirectMessages($acceptRedirectMessages)
            ->setReplyMulticastEchoRequest($replyMulticastEchoRequest)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setSoftkeyTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setUserLocale($userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param string $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param string $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param string $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param string $preemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setPreemption($preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get ipAddressingMode value
     * @return string|null
     */
    public function getIpAddressingMode()
    {
        return $this->ipAddressingMode;
    }
    /**
     * Set ipAddressingMode value
     * @param string $ipAddressingMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setIpAddressingMode($ipAddressingMode = null)
    {
        $this->ipAddressingMode = $ipAddressingMode;
        return $this;
    }
    /**
     * Get ipAddressingModePreferenceControl value
     * @return string|null
     */
    public function getIpAddressingModePreferenceControl()
    {
        return $this->ipAddressingModePreferenceControl;
    }
    /**
     * Set ipAddressingModePreferenceControl value
     * @param string $ipAddressingModePreferenceControl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl = null)
    {
        $this->ipAddressingModePreferenceControl = $ipAddressingModePreferenceControl;
        return $this;
    }
    /**
     * Get allowAutoConfigurationForPhones value
     * @return string|null
     */
    public function getAllowAutoConfigurationForPhones()
    {
        return $this->allowAutoConfigurationForPhones;
    }
    /**
     * Set allowAutoConfigurationForPhones value
     * @param string $allowAutoConfigurationForPhones
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones = null)
    {
        $this->allowAutoConfigurationForPhones = $allowAutoConfigurationForPhones;
        return $this;
    }
    /**
     * Get useImeForOutboundCalls value
     * @return string|null
     */
    public function getUseImeForOutboundCalls()
    {
        return $this->useImeForOutboundCalls;
    }
    /**
     * Set useImeForOutboundCalls value
     * @param string $useImeForOutboundCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setUseImeForOutboundCalls($useImeForOutboundCalls = null)
    {
        $this->useImeForOutboundCalls = $useImeForOutboundCalls;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get allowDuplicateAddressDetection value
     * @return string|null
     */
    public function getAllowDuplicateAddressDetection()
    {
        return $this->allowDuplicateAddressDetection;
    }
    /**
     * Set allowDuplicateAddressDetection value
     * @param string $allowDuplicateAddressDetection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setAllowDuplicateAddressDetection($allowDuplicateAddressDetection = null)
    {
        $this->allowDuplicateAddressDetection = $allowDuplicateAddressDetection;
        return $this;
    }
    /**
     * Get acceptRedirectMessages value
     * @return string|null
     */
    public function getAcceptRedirectMessages()
    {
        return $this->acceptRedirectMessages;
    }
    /**
     * Set acceptRedirectMessages value
     * @param string $acceptRedirectMessages
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setAcceptRedirectMessages($acceptRedirectMessages = null)
    {
        $this->acceptRedirectMessages = $acceptRedirectMessages;
        return $this;
    }
    /**
     * Get replyMulticastEchoRequest value
     * @return string|null
     */
    public function getReplyMulticastEchoRequest()
    {
        return $this->replyMulticastEchoRequest;
    }
    /**
     * Set replyMulticastEchoRequest value
     * @param string $replyMulticastEchoRequest
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setReplyMulticastEchoRequest($replyMulticastEchoRequest = null)
    {
        $this->replyMulticastEchoRequest = $replyMulticastEchoRequest;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LCommonDeviceConfig
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
