<?php

namespace \Losc\CucmBundle\Model\Webservice\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSipProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipTrunkSecurityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSipTrunkSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTimePeriodReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateTimePeriod(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateTimePeriodReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTimeScheduleReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateTimeSchedule(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTodAccessReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateTodAccess(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateTodAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPilotReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateVoiceMailPilot(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateProcessNode(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallerFilterListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCallerFilterList(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRoutePartition(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCssReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCss(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCssReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCallManager(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMediaResourceGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMediaResourceGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMediaResourceListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMediaResourceList(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRegion(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAarGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateAarGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateAarGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhysicalLocationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updatePhysicalLocation(\\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRouteGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRouteGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDevicePool(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDevicePoolReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDeviceMobilityGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDeviceMobilityGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLocationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLocation(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSoftKeyTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSoftKeyTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTranscoderReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateTranscoder(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateTranscoderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonDeviceConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCommonDeviceConfig(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateResourcePriorityNamespace(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateResourcePriorityNamespaceList(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDeviceMobilityReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDeviceMobility(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCmcInfoReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCmcInfo(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCmcInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCredentialPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFacInfoReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateFacInfo(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateFacInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateHuntListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateHuntList(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateHuntListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIvrUserLocaleReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateIvrUserLocale(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLineGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRecordingProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRecordingProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRouteFilterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRouteFilter(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRouteFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCallManagerGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUserGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateUserGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateUserGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProcessNodeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateProcessNodeService(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProcessNodeService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMohAudioSource(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDhcpServer(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDhcpSubnet(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallParkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCallPark(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirectedCallParkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDirectedCallPark(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMeetMeReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMeetMe(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMeetMeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMobileVoiceAccess(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRouteListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRouteList(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRouteListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateUser(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateAppUser(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRealmReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSipRealm(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRealmReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updatePhoneNtp(\\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDateTimeGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePresenceGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updatePresenceGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdatePresenceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGeoLocationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGeoLocation(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGeoLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSrstReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSrst(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSrstReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMlppDomainReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMlppDomain(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMlppDomainReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCumaServerSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateApplicationServer(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationUserCapfProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateApplicationUserCapfProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateEndUserCapfProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateEndUserCapfProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateServiceParameter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateServiceParameterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateServiceParameter(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateServiceParameterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateServiceParameter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGeoLocationFilterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGeoLocationFilter(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateVoiceMailProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateVoiceMailPort(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatekeeperReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGatekeeper(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatekeeperReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneButtonTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updatePhoneButtonTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCommonPhoneConfig(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMessageWaiting(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateIpPhoneServices(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCtiRoutePointReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCtiRoutePoint(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTransPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateTransPattern(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateTransPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallingPartyTransformationPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCallingPartyTransformationPattern(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSipRoutePattern(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateHuntPilotReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateHuntPilot(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateHuntPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRoutePattern(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationDialRulesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateApplicationDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirectoryLookupDialRulesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDirectoryLookupDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updatePhoneSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSipDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateConferenceBridgeReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateConferenceBridge(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAnnunciator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAnnunciatorReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateAnnunciator(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateAnnunciatorReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAnnunciator($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMtpReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMtp(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFixedMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateFixedMohAudioSource(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFixedMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAarGroupMatrix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAarGroupMatrixReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateAarGroupMatrix(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateAarGroupMatrixReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAarGroupMatrix($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRemoteDestinationProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLineReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLine(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLineReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDefaultDeviceProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDefaultDeviceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323PhoneReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateH323Phone(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323PhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMohServer(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323TrunkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateH323Trunk(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323TrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updatePhone(\\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateH323Gateway(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateH323GatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDeviceProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDeviceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRemoteDestination(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVg224Req $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateVg224(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateVg224Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGateway(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayEndpointAnalogAccessReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointAnalogAccess(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessPri(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessBri(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessT1(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst600024PortFXSGateway(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000E1VoIPGateway(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000T1VoIPGatewayPri(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000T1VoIPGatewayT1(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCallPickupGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGeoLocationPolicyReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGeoLocationPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipTrunkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSipTrunk(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipTrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRegionMatrix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRegionMatrix(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRegionMatrix($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCalledPartyTransformationPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCalledPartyTransformationPattern(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateExternalCallControlProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafSecurityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSafSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSafForwarder(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCcdHostedDN(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCcdHostedDNGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCcdRequestingService(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateInterClusterServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateInterClusterServiceProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateInterClusterServiceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateInterClusterServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateInterClusterServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteClusterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRemoteCluster(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdAdvertisingServiceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCcdAdvertisingService(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLdapDirectory(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEmccFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateEmccFeatureConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateEmccFeatureConfig(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateEmccFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEmccFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSafCcdPurgeBlockLearnedRoutes(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVpnGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateVpnGateway(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVpnGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateVpnGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateVpnGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVpnProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateVpnProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateVpnProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeServer(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeRouteFilterGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeRouteFilterGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeRouteFilterElementReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeRouteFilterElement(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeClientReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeClient(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeClientReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeEnrolledPattern(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeEnrolledPatternGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeExclusionNumber(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeExclusionNumberGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeFirewallReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeFirewall(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeFirewallReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeE164Transformation(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTransformationProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateTransformationProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateFallbackProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapFilterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLdapFilter(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppServerInfoReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateAppServerInfo(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTvsCertificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTvsCertificateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateTvsCertificate(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateTvsCertificateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTvsCertificate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureControlPolicyReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateFeatureControlPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMobilityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMobilityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateEnterpriseFeatureAccessConfiguration(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateHandoffConfigurationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateHandoffConfiguration(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSIPNormalizationScriptReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSIPNormalizationScript(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSIPNormalizationScriptReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCustomUserFieldReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCustomUserField(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGatewaySccpEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewaySccpEndpointsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateGatewaySccpEndpoints(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatewaySccpEndpointsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewaySccpEndpoints($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLbmGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLbmGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLbmGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAnnouncementReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateAnnouncement(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateAnnouncementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateServiceProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateServiceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapSyncCustomFieldReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLdapSyncCustomField(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAudioCodecPreferenceListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateAudioCodecPreferenceList(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateAudioCodecPreferenceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUcServiceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateUcService(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateUcServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLbmHubGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLbmHubGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLbmHubGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImportedDirectoryUriCatalogsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImportedDirectoryUriCatalogs(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImportedDirectoryUriCatalogsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVohServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateVohServer(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateVohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSdpTransparencyProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSdpTransparencyProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSdpTransparencyProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateFeatureGroupTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateFeatureGroupTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateDirNumberAliasLookupandSync(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateDirNumberAliasLookupandSyncReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateAdvertisedPatterns(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateBlockedLearnedPatternsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateBlockedLearnedPatterns(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCCAProfilesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCCAProfiles(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalDeviceTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateUniversalDeviceTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalDeviceTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUserProfileProvisionReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateUserProfileProvision(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateUserProfileProvisionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePresenceRedundancyGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updatePresenceRedundancyGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdatePresenceRedundancyGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWifiHotspotReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateWifiHotspot(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateWifiHotspotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWlanProfileGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateWlanProfileGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateWlanProfileGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateWLANProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateUniversalLineTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateNetworkAccessProfile(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMobilityReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateMobility(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEnterprisePhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateEnterprisePhoneConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateEnterprisePhoneConfig(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateEnterprisePhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEnterprisePhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapSystem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapSystemReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLdapSystem(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapSystemReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapSystem($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapAuthentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapAuthenticationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLdapAuthentication(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLdapAuthenticationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapAuthentication($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeFeatureConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeFeatureConfig(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFallbackFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackFeatureConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateFallbackFeatureConfig(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFallbackFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeLearnedRoutesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateImeLearnedRoutes(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSoftKeySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSoftKeySetReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSoftKeySet(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSoftKeySetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSoftKeySet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSyslogConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSyslogConfigurationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSyslogConfigurationRes|bool
     */
    public function updateSyslogConfiguration(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSyslogConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSyslogConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateInterClusterDirectoryUri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateInterClusterDirectoryUriReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateInterClusterDirectoryUri(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateInterClusterDirectoryUriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateInterClusterDirectoryUri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateIlsConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateIlsConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateIlsConfig(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateIlsConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateIlsConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSNMPCommunityString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPCommunityStringReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPCommunityStringRes|bool
     */
    public function updateSNMPCommunityString(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPCommunityStringReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSNMPCommunityString($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSNMPUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPUserRes|bool
     */
    public function updateSNMPUser(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSNMPUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSNMPMIB2List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPMIB2ListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPMIB2ListRes|bool
     */
    public function updateSNMPMIB2List(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPMIB2ListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSNMPMIB2List($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateBillingServer(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdFeatureConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdFeatureConfigRes|bool
     */
    public function updateCcdFeatureConfig(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateRoutePartitionsForLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionsForLearnedPatternsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateRoutePartitionsForLearnedPatterns(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionsForLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRoutePartitionsForLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateLocalRouteGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateLocalRouteGroup(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePageLayoutPreferences
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePageLayoutPreferencesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updatePageLayoutPreferences(\\Losc\CucmBundle\Model\Webservice\StructType\UpdatePageLayoutPreferencesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePageLayoutPreferences($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCredentialPolicyDefault
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateCredentialPolicyDefault(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCredentialPolicyDefaultReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCredentialPolicyDefault($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSelfProvisioning
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSelfProvisioningReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function updateSelfProvisioning(\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSelfProvisioningReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSelfProvisioning($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|\\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdFeatureConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPCommunityStringRes|\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPMIB2ListRes|\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSNMPUserRes|\\Losc\CucmBundle\Model\Webservice\StructType\UpdateSyslogConfigurationRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
