<?php

namespace \Losc\CucmBundle\Model\Webservice\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named removeSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSipProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSipTrunkSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeTimePeriod(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeTimeSchedule(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeTodAccess(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveVoiceMailPilotReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeVoiceMailPilot(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeProcessNode(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCallerFilterList(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRoutePartition(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCss(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMediaResourceGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMediaResourceList(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRegion(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeAarGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removePhysicalLocation(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removePhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRouteGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDevicePool(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDeviceMobilityGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLocation(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSoftKeyTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeTranscoder(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCommonDeviceConfig(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveResourcePriorityNamespaceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeResourcePriorityNamespace(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeResourcePriorityNamespaceList(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDeviceMobility(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCmcInfoReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCmcInfo(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCmcInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCredentialPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeFacInfo(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeHuntList(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveIvrUserLocaleReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeIvrUserLocale(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLineGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRecordingProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRouteFilter(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCallManagerGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeUserGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveMohAudioSourceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMohAudioSource(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveDhcpServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDhcpServer(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveDhcpServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveDhcpSubnetReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDhcpSubnet(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCallParkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCallPark(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveDirectedCallParkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDirectedCallPark(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveMeetMeReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMeetMe(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveMeetMeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveMobileVoiceAccessReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMobileVoiceAccess(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRouteList(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeUser(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeAppUser(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSipRealmReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSipRealm(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveSipRealmReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemovePhoneNtpReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removePhoneNtp(\\Losc\CucmBundle\Model\Webservice\StructType\RemovePhoneNtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removePhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDateTimeGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removePresenceGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removePresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGeoLocation(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSrst(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveMlppDomainReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMlppDomain(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveMlppDomainReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCumaServerSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveApplicationServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeApplicationServer(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveApplicationServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveApplicationUserCapfProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeApplicationUserCapfProfile(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveEndUserCapfProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeEndUserCapfProfile(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGeoLocationFilter(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeVoiceMailProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeVoiceMailPort(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGatekeeper(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removePhoneButtonTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removePhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCommonPhoneConfig(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveMessageWaitingReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMessageWaiting(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveIpPhoneServicesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeIpPhoneServices(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCtiRoutePoint(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveTransPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeTransPattern(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveTransPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCallingPartyTransformationPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCallingPartyTransformationPattern(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSipRoutePatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSipRoutePattern(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveHuntPilotReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeHuntPilot(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveHuntPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveRoutePatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRoutePattern(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeApplicationDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDirectoryLookupDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removePhoneSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removePhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSipDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeConferenceBridge(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMtp(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRemoteDestinationProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveLineReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLine(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveLineReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDefaultDeviceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeH323Phone(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeH323Trunk(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removePhone(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removePhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeH323Gateway(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDeviceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveRemoteDestinationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRemoteDestination(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveVg224Req $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeVg224(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveVg224Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGateway(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointAnalogAccess(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessPri(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessBri(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessT1(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst600024PortFXSGateway(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000E1VoIPGateway(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000T1VoIPGatewayPri(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000T1VoIPGatewayT1(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCallPickupGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCallPickupGroup(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGeoLocationPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSipTrunk(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCalledPartyTransformationPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCalledPartyTransformationPattern(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeExternalCallControlProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSafSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSafForwarder(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCcdHostedDNReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCcdHostedDN(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCcdHostedDNGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCcdRequestingService(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveRemoteClusterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeRemoteCluster(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCcdAdvertisingService(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLdapDirectory(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSafCcdPurgeBlockLearnedRoutes(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeVpnGateway(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeVpnGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeVpnProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeServer(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeRouteFilterGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeRouteFilterElement(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeClient(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveImeEnrolledPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeEnrolledPattern(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeEnrolledPatternGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveImeExclusionNumberReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeExclusionNumber(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeExclusionNumberGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeFirewall(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeE164Transformation(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeTransformationProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeFallbackProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLdapFilter(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeFeatureControlPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeMobilityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeEnterpriseFeatureAccessConfiguration(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveHandoffConfigurationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeHandoffConfiguration(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCalledPartyTracing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCalledPartyTracingReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCalledPartyTracing(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCalledPartyTracingReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCalledPartyTracing($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSIPNormalizationScript(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCustomUserFieldReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCustomUserField(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatewaySccpEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGatewaySccpEndpoints(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGatewaySccpEndpoints($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLbmGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeAnnouncement(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeServiceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveLdapSyncCustomFieldReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLdapSyncCustomField(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeAudioCodecPreferenceList(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeUcService(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLbmHubGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImportedDirectoryUriCatalogs(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeVohServer(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeSdpTransparencyProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeFeatureGroupTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeDirNumberAliasLookupandSync(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAdvertisedPatternsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeAdvertisedPatterns(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveBlockedLearnedPatternsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeBlockedLearnedPatterns(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCCAProfilesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeCCAProfiles(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeUniversalDeviceTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeUserProfileProvision(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removePresenceRedundancyGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removePresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeWifiHotspot(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeWlanProfileGroup(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeWLANProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeUniversalLineTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeNetworkAccessProfile(\\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationToSoftkeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveApplicationToSoftkeyTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeApplicationToSoftkeyTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveApplicationToSoftkeyTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeApplicationToSoftkeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUnitsToGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveUnitsToGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeUnitsToGateway(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveUnitsToGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeUnitsToGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatewaySubunits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewaySubunitsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeGatewaySubunits(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveGatewaySubunitsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGatewaySubunits($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveImeLearnedRoutesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeImeLearnedRoutes(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppServerInfoReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeAppServerInfo(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSNMPCommunityString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSNMPCommunityStringReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSNMPCommunityStringRes|bool
     */
    public function removeSNMPCommunityString(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveSNMPCommunityStringReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSNMPCommunityString($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSNMPUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSNMPUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSNMPUserRes|bool
     */
    public function removeSNMPUser(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveSNMPUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeSNMPUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveBillingServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeBillingServer(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveBillingServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveLocalRouteGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function removeLocalRouteGroup(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->removeLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveSNMPCommunityStringRes|\\Losc\CucmBundle\Model\Webservice\StructType\RemoveSNMPUserRes|\\Losc\CucmBundle\Model\Webservice\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
