<?php

namespace \Losc\CucmBundle\Model\Webservice\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSipProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSipProfileRes|bool
     */
    public function getSipProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetSipProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipProfileOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSipProfileOptionsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSipProfileOptionsRes|bool
     */
    public function getSipProfileOptions(\\Losc\CucmBundle\Model\Webservice\StructType\GetSipProfileOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipProfileOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSipTrunkSecurityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSipTrunkSecurityProfileRes|bool
     */
    public function getSipTrunkSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetTimePeriodReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTimePeriodRes|bool
     */
    public function getTimePeriod(\\Losc\CucmBundle\Model\Webservice\StructType\GetTimePeriodReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetTimeScheduleReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTimeScheduleRes|bool
     */
    public function getTimeSchedule(\\Losc\CucmBundle\Model\Webservice\StructType\GetTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetTodAccessReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTodAccessRes|bool
     */
    public function getTodAccess(\\Losc\CucmBundle\Model\Webservice\StructType\GetTodAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotRes|bool
     */
    public function getVoiceMailPilot(\\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetProcessNodeReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetProcessNodeRes|bool
     */
    public function getProcessNode(\\Losc\CucmBundle\Model\Webservice\StructType\GetProcessNodeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCallerFilterListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCallerFilterListRes|bool
     */
    public function getCallerFilterList(\\Losc\CucmBundle\Model\Webservice\StructType\GetCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePartitionReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePartitionRes|bool
     */
    public function getRoutePartition(\\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCssReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCssRes|bool
     */
    public function getCss(\\Losc\CucmBundle\Model\Webservice\StructType\GetCssReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCallManagerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCallManagerRes|bool
     */
    public function getCallManager(\\Losc\CucmBundle\Model\Webservice\StructType\GetCallManagerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMediaResourceGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMediaResourceGroupRes|bool
     */
    public function getMediaResourceGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMediaResourceListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMediaResourceListRes|bool
     */
    public function getMediaResourceList(\\Losc\CucmBundle\Model\Webservice\StructType\GetMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRegionReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRegionRes|bool
     */
    public function getRegion(\\Losc\CucmBundle\Model\Webservice\StructType\GetRegionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetAarGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetAarGroupRes|bool
     */
    public function getAarGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetAarGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPhysicalLocationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPhysicalLocationRes|bool
     */
    public function getPhysicalLocation(\\Losc\CucmBundle\Model\Webservice\StructType\GetPhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRouteGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRouteGroupRes|bool
     */
    public function getRouteGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDevicePoolReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDevicePoolRes|bool
     */
    public function getDevicePool(\\Losc\CucmBundle\Model\Webservice\StructType\GetDevicePoolReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceMobilityGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceMobilityGroupRes|bool
     */
    public function getDeviceMobilityGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLocationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLocationRes|bool
     */
    public function getLocation(\\Losc\CucmBundle\Model\Webservice\StructType\GetLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSoftKeyTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSoftKeyTemplateRes|bool
     */
    public function getSoftKeyTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\GetSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetTranscoderReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTranscoderRes|bool
     */
    public function getTranscoder(\\Losc\CucmBundle\Model\Webservice\StructType\GetTranscoderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCommonDeviceConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCommonDeviceConfigRes|bool
     */
    public function getCommonDeviceConfig(\\Losc\CucmBundle\Model\Webservice\StructType\GetCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetResourcePriorityNamespaceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetResourcePriorityNamespaceRes|bool
     */
    public function getResourcePriorityNamespace(\\Losc\CucmBundle\Model\Webservice\StructType\GetResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetResourcePriorityNamespaceListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetResourcePriorityNamespaceListRes|bool
     */
    public function getResourcePriorityNamespaceList(\\Losc\CucmBundle\Model\Webservice\StructType\GetResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceMobilityReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceMobilityRes|bool
     */
    public function getDeviceMobility(\\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCmcInfoReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCmcInfoRes|bool
     */
    public function getCmcInfo(\\Losc\CucmBundle\Model\Webservice\StructType\GetCmcInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCredentialPolicyReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCredentialPolicyRes|bool
     */
    public function getCredentialPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\GetCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetFacInfoReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetFacInfoRes|bool
     */
    public function getFacInfo(\\Losc\CucmBundle\Model\Webservice\StructType\GetFacInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetHuntListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetHuntListRes|bool
     */
    public function getHuntList(\\Losc\CucmBundle\Model\Webservice\StructType\GetHuntListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetIvrUserLocaleReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetIvrUserLocaleRes|bool
     */
    public function getIvrUserLocale(\\Losc\CucmBundle\Model\Webservice\StructType\GetIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLineGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLineGroupRes|bool
     */
    public function getLineGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetLineGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRecordingProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRecordingProfileRes|bool
     */
    public function getRecordingProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRouteFilterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRouteFilterRes|bool
     */
    public function getRouteFilter(\\Losc\CucmBundle\Model\Webservice\StructType\GetRouteFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCallManagerGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCallManagerGroupRes|bool
     */
    public function getCallManagerGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetUserGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetUserGroupRes|bool
     */
    public function getUserGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetUserGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDialPlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDialPlanReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDialPlanRes|bool
     */
    public function getDialPlan(\\Losc\CucmBundle\Model\Webservice\StructType\GetDialPlanReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDialPlan($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDialPlanTag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDialPlanTagReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDialPlanTagRes|bool
     */
    public function getDialPlanTag(\\Losc\CucmBundle\Model\Webservice\StructType\GetDialPlanTagReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDialPlanTag($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDdi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDdiReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDdiRes|bool
     */
    public function getDdi(\\Losc\CucmBundle\Model\Webservice\StructType\GetDdiReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDdi($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobileSmartClientProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMobileSmartClientProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMobileSmartClientProfileRes|bool
     */
    public function getMobileSmartClientProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetMobileSmartClientProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobileSmartClientProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProcessNodeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetProcessNodeServiceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetProcessNodeServiceRes|bool
     */
    public function getProcessNodeService(\\Losc\CucmBundle\Model\Webservice\StructType\GetProcessNodeServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getProcessNodeService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMohAudioSourceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMohAudioSourceRes|bool
     */
    public function getMohAudioSource(\\Losc\CucmBundle\Model\Webservice\StructType\GetMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDhcpServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDhcpServerRes|bool
     */
    public function getDhcpServer(\\Losc\CucmBundle\Model\Webservice\StructType\GetDhcpServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDhcpSubnetReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDhcpSubnetRes|bool
     */
    public function getDhcpSubnet(\\Losc\CucmBundle\Model\Webservice\StructType\GetDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCallParkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCallParkRes|bool
     */
    public function getCallPark(\\Losc\CucmBundle\Model\Webservice\StructType\GetCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDirectedCallParkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDirectedCallParkRes|bool
     */
    public function getDirectedCallPark(\\Losc\CucmBundle\Model\Webservice\StructType\GetDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMeetMeReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMeetMeRes|bool
     */
    public function getMeetMe(\\Losc\CucmBundle\Model\Webservice\StructType\GetMeetMeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMobileVoiceAccessReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMobileVoiceAccessRes|bool
     */
    public function getMobileVoiceAccess(\\Losc\CucmBundle\Model\Webservice\StructType\GetMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRouteListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRouteListRes|bool
     */
    public function getRouteList(\\Losc\CucmBundle\Model\Webservice\StructType\GetRouteListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetUserRes|bool
     */
    public function getUser(\\Losc\CucmBundle\Model\Webservice\StructType\GetUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetAppUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetAppUserRes|bool
     */
    public function getAppUser(\\Losc\CucmBundle\Model\Webservice\StructType\GetAppUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSipRealmReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSipRealmRes|bool
     */
    public function getSipRealm(\\Losc\CucmBundle\Model\Webservice\StructType\GetSipRealmReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneNtpReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneNtpRes|bool
     */
    public function getPhoneNtp(\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneNtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDateTimeGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDateTimeGroupRes|bool
     */
    public function getDateTimeGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPresenceGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPresenceGroupRes|bool
     */
    public function getPresenceGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetPresenceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationRes|bool
     */
    public function getGeoLocation(\\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSrstReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSrstRes|bool
     */
    public function getSrst(\\Losc\CucmBundle\Model\Webservice\StructType\GetSrstReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMlppDomainReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMlppDomainRes|bool
     */
    public function getMlppDomain(\\Losc\CucmBundle\Model\Webservice\StructType\GetMlppDomainReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCumaServerSecurityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCumaServerSecurityProfileRes|bool
     */
    public function getCumaServerSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationServerRes|bool
     */
    public function getApplicationServer(\\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationUserCapfProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationUserCapfProfileRes|bool
     */
    public function getApplicationUserCapfProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetEndUserCapfProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetEndUserCapfProfileRes|bool
     */
    public function getEndUserCapfProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServiceParameter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetServiceParameterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetServiceParameterRes|bool
     */
    public function getServiceParameter(\\Losc\CucmBundle\Model\Webservice\StructType\GetServiceParameterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getServiceParameter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationFilterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationFilterRes|bool
     */
    public function getGeoLocationFilter(\\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailProfileRes|bool
     */
    public function getVoiceMailProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPortReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPortRes|bool
     */
    public function getVoiceMailPort(\\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGatekeeperReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGatekeeperRes|bool
     */
    public function getGatekeeper(\\Losc\CucmBundle\Model\Webservice\StructType\GetGatekeeperReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneButtonTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneButtonTemplateRes|bool
     */
    public function getPhoneButtonTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCommonPhoneConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCommonPhoneConfigRes|bool
     */
    public function getCommonPhoneConfig(\\Losc\CucmBundle\Model\Webservice\StructType\GetCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMessageWaitingReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMessageWaitingRes|bool
     */
    public function getMessageWaiting(\\Losc\CucmBundle\Model\Webservice\StructType\GetMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetIpPhoneServicesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetIpPhoneServicesRes|bool
     */
    public function getIpPhoneServices(\\Losc\CucmBundle\Model\Webservice\StructType\GetIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCtiRoutePointReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCtiRoutePointRes|bool
     */
    public function getCtiRoutePoint(\\Losc\CucmBundle\Model\Webservice\StructType\GetCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetTransPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTransPatternRes|bool
     */
    public function getTransPattern(\\Losc\CucmBundle\Model\Webservice\StructType\GetTransPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransPatternOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetTransPatternOptionsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTransPatternOptionsRes|bool
     */
    public function getTransPatternOptions(\\Losc\CucmBundle\Model\Webservice\StructType\GetTransPatternOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTransPatternOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCallingPartyTransformationPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCallingPartyTransformationPatternRes|bool
     */
    public function getCallingPartyTransformationPattern(\\Losc\CucmBundle\Model\Webservice\StructType\GetCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSipRoutePatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSipRoutePatternRes|bool
     */
    public function getSipRoutePattern(\\Losc\CucmBundle\Model\Webservice\StructType\GetSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetHuntPilotReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetHuntPilotRes|bool
     */
    public function getHuntPilot(\\Losc\CucmBundle\Model\Webservice\StructType\GetHuntPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternRes|bool
     */
    public function getRoutePattern(\\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationDialRulesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationDialRulesRes|bool
     */
    public function getApplicationDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDirectoryLookupDialRulesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDirectoryLookupDialRulesRes|bool
     */
    public function getDirectoryLookupDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\GetDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneSecurityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneSecurityProfileRes|bool
     */
    public function getPhoneSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSipDialRulesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSipDialRulesRes|bool
     */
    public function getSipDialRules(\\Losc\CucmBundle\Model\Webservice\StructType\GetSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetConferenceBridgeReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetConferenceBridgeRes|bool
     */
    public function getConferenceBridge(\\Losc\CucmBundle\Model\Webservice\StructType\GetConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAnnunciator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetAnnunciatorReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetAnnunciatorRes|bool
     */
    public function getAnnunciator(\\Losc\CucmBundle\Model\Webservice\StructType\GetAnnunciatorReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAnnunciator($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMtpReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMtpRes|bool
     */
    public function getMtp(\\Losc\CucmBundle\Model\Webservice\StructType\GetMtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFixedMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetFixedMohAudioSourceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetFixedMohAudioSourceRes|bool
     */
    public function getFixedMohAudioSource(\\Losc\CucmBundle\Model\Webservice\StructType\GetFixedMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFixedMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteDestinationProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteDestinationProfileRes|bool
     */
    public function getRemoteDestinationProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLineReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLineRes|bool
     */
    public function getLine(\\Losc\CucmBundle\Model\Webservice\StructType\GetLineReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLineOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLineOptionsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLineOptionsRes|bool
     */
    public function getLineOptions(\\Losc\CucmBundle\Model\Webservice\StructType\GetLineOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLineOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDefaultDeviceProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDefaultDeviceProfileRes|bool
     */
    public function getDefaultDeviceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetH323PhoneReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetH323PhoneRes|bool
     */
    public function getH323Phone(\\Losc\CucmBundle\Model\Webservice\StructType\GetH323PhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMohServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMohServerRes|bool
     */
    public function getMohServer(\\Losc\CucmBundle\Model\Webservice\StructType\GetMohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetH323TrunkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetH323TrunkRes|bool
     */
    public function getH323Trunk(\\Losc\CucmBundle\Model\Webservice\StructType\GetH323TrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneRes|bool
     */
    public function getPhone(\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneOptionsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneOptionsRes|bool
     */
    public function getPhoneOptions(\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetH323GatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetH323GatewayRes|bool
     */
    public function getH323Gateway(\\Losc\CucmBundle\Model\Webservice\StructType\GetH323GatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceProfileRes|bool
     */
    public function getDeviceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceProfileOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceProfileOptionsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceProfileOptionsRes|bool
     */
    public function getDeviceProfileOptions(\\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceProfileOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceProfileOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteDestinationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteDestinationRes|bool
     */
    public function getRemoteDestination(\\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetVg224Req $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetVg224Res|bool
     */
    public function getVg224(\\Losc\CucmBundle\Model\Webservice\StructType\GetVg224Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayRes|bool
     */
    public function getGateway(\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointAnalogAccessReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointAnalogAccessRes|bool
     */
    public function getGatewayEndpointAnalogAccess(\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessPriRes|bool
     */
    public function getGatewayEndpointDigitalAccessPri(\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessBriRes|bool
     */
    public function getGatewayEndpointDigitalAccessBri(\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessT1Res|bool
     */
    public function getGatewayEndpointDigitalAccessT1(\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst600024PortFXSGatewayRes|bool
     */
    public function getCiscoCatalyst600024PortFXSGateway(\\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000E1VoIPGatewayRes|bool
     */
    public function getCiscoCatalyst6000E1VoIPGateway(\\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriRes|bool
     */
    public function getCiscoCatalyst6000T1VoIPGatewayPri(\\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Res|bool
     */
    public function getCiscoCatalyst6000T1VoIPGatewayT1(\\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCallPickupGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCallPickupGroupRes|bool
     */
    public function getCallPickupGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationPolicyReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationPolicyRes|bool
     */
    public function getGeoLocationPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSipTrunkReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSipTrunkRes|bool
     */
    public function getSipTrunk(\\Losc\CucmBundle\Model\Webservice\StructType\GetSipTrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCalledPartyTransformationPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCalledPartyTransformationPatternRes|bool
     */
    public function getCalledPartyTransformationPattern(\\Losc\CucmBundle\Model\Webservice\StructType\GetCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetExternalCallControlProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetExternalCallControlProfileRes|bool
     */
    public function getExternalCallControlProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSafSecurityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSafSecurityProfileRes|bool
     */
    public function getSafSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSafForwarderReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSafForwarderRes|bool
     */
    public function getSafForwarder(\\Losc\CucmBundle\Model\Webservice\StructType\GetSafForwarderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdHostedDNReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdHostedDNRes|bool
     */
    public function getCcdHostedDN(\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdHostedDNGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdHostedDNGroupRes|bool
     */
    public function getCcdHostedDNGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdRequestingServiceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdRequestingServiceRes|bool
     */
    public function getCcdRequestingService(\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInterClusterServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetInterClusterServiceProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetInterClusterServiceProfileRes|bool
     */
    public function getInterClusterServiceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetInterClusterServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getInterClusterServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteClusterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteClusterRes|bool
     */
    public function getRemoteCluster(\\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdAdvertisingServiceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdAdvertisingServiceRes|bool
     */
    public function getCcdAdvertisingService(\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapDirectoryReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapDirectoryRes|bool
     */
    public function getLdapDirectory(\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEmccFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetEmccFeatureConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetEmccFeatureConfigRes|bool
     */
    public function getEmccFeatureConfig(\\Losc\CucmBundle\Model\Webservice\StructType\GetEmccFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getEmccFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSafCcdPurgeBlockLearnedRoutesRes|bool
     */
    public function getSafCcdPurgeBlockLearnedRoutes(\\Losc\CucmBundle\Model\Webservice\StructType\GetSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetVpnGatewayReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetVpnGatewayRes|bool
     */
    public function getVpnGateway(\\Losc\CucmBundle\Model\Webservice\StructType\GetVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetVpnGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetVpnGroupRes|bool
     */
    public function getVpnGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetVpnGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetVpnProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetVpnProfileRes|bool
     */
    public function getVpnProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetVpnProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeServerRes|bool
     */
    public function getImeServer(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeRouteFilterGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeRouteFilterGroupRes|bool
     */
    public function getImeRouteFilterGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeRouteFilterElementReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeRouteFilterElementRes|bool
     */
    public function getImeRouteFilterElement(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeClientReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeClientRes|bool
     */
    public function getImeClient(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeClientReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeEnrolledPatternReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeEnrolledPatternRes|bool
     */
    public function getImeEnrolledPattern(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeEnrolledPatternGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeEnrolledPatternGroupRes|bool
     */
    public function getImeEnrolledPatternGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeExclusionNumberReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeExclusionNumberRes|bool
     */
    public function getImeExclusionNumber(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeExclusionNumberGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeExclusionNumberGroupRes|bool
     */
    public function getImeExclusionNumberGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeFirewallReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeFirewallRes|bool
     */
    public function getImeFirewall(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeFirewallReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeE164TransformationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeE164TransformationRes|bool
     */
    public function getImeE164Transformation(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetTransformationProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTransformationProfileRes|bool
     */
    public function getTransformationProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetFallbackProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetFallbackProfileRes|bool
     */
    public function getFallbackProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapFilterReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapFilterRes|bool
     */
    public function getLdapFilter(\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTvsCertificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateRes|bool
     */
    public function getTvsCertificate(\\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTvsCertificate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetFeatureControlPolicyReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetFeatureControlPolicyRes|bool
     */
    public function getFeatureControlPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\GetFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMobilityProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMobilityProfileRes|bool
     */
    public function getMobilityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetEnterpriseFeatureAccessConfigurationRes|bool
     */
    public function getEnterpriseFeatureAccessConfiguration(\\Losc\CucmBundle\Model\Webservice\StructType\GetEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetHandoffConfigurationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetHandoffConfigurationRes|bool
     */
    public function getHandoffConfiguration(\\Losc\CucmBundle\Model\Webservice\StructType\GetHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSIPNormalizationScriptReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSIPNormalizationScriptRes|bool
     */
    public function getSIPNormalizationScript(\\Losc\CucmBundle\Model\Webservice\StructType\GetSIPNormalizationScriptReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCustomUserFieldReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCustomUserFieldRes|bool
     */
    public function getCustomUserField(\\Losc\CucmBundle\Model\Webservice\StructType\GetCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewaySccpEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewaySccpEndpointsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetGatewaySccpEndpointsRes|bool
     */
    public function getGatewaySccpEndpoints(\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewaySccpEndpointsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewaySccpEndpoints($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLbmGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLbmGroupRes|bool
     */
    public function getLbmGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetLbmGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetAnnouncementReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetAnnouncementRes|bool
     */
    public function getAnnouncement(\\Losc\CucmBundle\Model\Webservice\StructType\GetAnnouncementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetServiceProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetServiceProfileRes|bool
     */
    public function getServiceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldRes|bool
     */
    public function getLdapSyncCustomField(\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetAudioCodecPreferenceListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetAudioCodecPreferenceListRes|bool
     */
    public function getAudioCodecPreferenceList(\\Losc\CucmBundle\Model\Webservice\StructType\GetAudioCodecPreferenceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetUcServiceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetUcServiceRes|bool
     */
    public function getUcService(\\Losc\CucmBundle\Model\Webservice\StructType\GetUcServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLbmHubGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLbmHubGroupRes|bool
     */
    public function getLbmHubGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetLbmHubGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImportedDirectoryUriCatalogsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImportedDirectoryUriCatalogsRes|bool
     */
    public function getImportedDirectoryUriCatalogs(\\Losc\CucmBundle\Model\Webservice\StructType\GetImportedDirectoryUriCatalogsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetVohServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetVohServerRes|bool
     */
    public function getVohServer(\\Losc\CucmBundle\Model\Webservice\StructType\GetVohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSdpTransparencyProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSdpTransparencyProfileRes|bool
     */
    public function getSdpTransparencyProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetSdpTransparencyProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetFeatureGroupTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetFeatureGroupTemplateRes|bool
     */
    public function getFeatureGroupTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\GetFeatureGroupTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetDirNumberAliasLookupandSyncReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetDirNumberAliasLookupandSyncRes|bool
     */
    public function getDirNumberAliasLookupandSync(\\Losc\CucmBundle\Model\Webservice\StructType\GetDirNumberAliasLookupandSyncReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLocalRouteGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLocalRouteGroupRes|bool
     */
    public function getLocalRouteGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetAdvertisedPatternsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetAdvertisedPatternsRes|bool
     */
    public function getAdvertisedPatterns(\\Losc\CucmBundle\Model\Webservice\StructType\GetAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetBlockedLearnedPatternsReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetBlockedLearnedPatternsRes|bool
     */
    public function getBlockedLearnedPatterns(\\Losc\CucmBundle\Model\Webservice\StructType\GetBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCCAProfilesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCCAProfilesRes|bool
     */
    public function getCCAProfiles(\\Losc\CucmBundle\Model\Webservice\StructType\GetCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetUniversalDeviceTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetUniversalDeviceTemplateRes|bool
     */
    public function getUniversalDeviceTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\GetUniversalDeviceTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetUserProfileProvisionReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetUserProfileProvisionRes|bool
     */
    public function getUserProfileProvision(\\Losc\CucmBundle\Model\Webservice\StructType\GetUserProfileProvisionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPresenceRedundancyGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPresenceRedundancyGroupRes|bool
     */
    public function getPresenceRedundancyGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetPresenceRedundancyGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetWifiHotspotReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetWifiHotspotRes|bool
     */
    public function getWifiHotspot(\\Losc\CucmBundle\Model\Webservice\StructType\GetWifiHotspotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetWlanProfileGroupReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetWlanProfileGroupRes|bool
     */
    public function getWlanProfileGroup(\\Losc\CucmBundle\Model\Webservice\StructType\GetWlanProfileGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetWLANProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetWLANProfileRes|bool
     */
    public function getWLANProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetWLANProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetUniversalLineTemplateReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetUniversalLineTemplateRes|bool
     */
    public function getUniversalLineTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\GetUniversalLineTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetNetworkAccessProfileReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetNetworkAccessProfileRes|bool
     */
    public function getNetworkAccessProfile(\\Losc\CucmBundle\Model\Webservice\StructType\GetNetworkAccessProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLicensedUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLicensedUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLicensedUserRes|bool
     */
    public function getLicensedUser(\\Losc\CucmBundle\Model\Webservice\StructType\GetLicensedUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLicensedUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOSVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetOSVersionReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetOSVersionRes|bool
     */
    public function getOSVersion(\\Losc\CucmBundle\Model\Webservice\StructType\GetOSVersionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getOSVersion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNumDevices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetNumDevicesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetNumDevicesResponse|bool
     */
    public function getNumDevices(\\Losc\CucmBundle\Model\Webservice\StructType\GetNumDevicesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getNumDevices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetMobilityReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetMobilityRes|bool
     */
    public function getMobility(\\Losc\CucmBundle\Model\Webservice\StructType\GetMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnterprisePhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetEnterprisePhoneConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetEnterprisePhoneConfigRes|bool
     */
    public function getEnterprisePhoneConfig(\\Losc\CucmBundle\Model\Webservice\StructType\GetEnterprisePhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnterprisePhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapSystem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSystemReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSystemRes|bool
     */
    public function getLdapSystem(\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSystemReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapSystem($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapAuthentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapAuthenticationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapAuthenticationRes|bool
     */
    public function getLdapAuthentication(\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapAuthenticationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapAuthentication($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCCMVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCCMVersionReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCCMVersionRes|bool
     */
    public function getCCMVersion(\\Losc\CucmBundle\Model\Webservice\StructType\GetCCMVersionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCCMVersion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeLearnedRoutesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeLearnedRoutesRes|bool
     */
    public function getImeLearnedRoutes(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetImeFeatureConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetImeFeatureConfigRes|bool
     */
    public function getImeFeatureConfig(\\Losc\CucmBundle\Model\Webservice\StructType\GetImeFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFallbackFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetFallbackFeatureConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetFallbackFeatureConfigRes|bool
     */
    public function getFallbackFeatureConfig(\\Losc\CucmBundle\Model\Webservice\StructType\GetFallbackFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFallbackFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetAppServerInfoReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetAppServerInfoRes|bool
     */
    public function getAppServerInfo(\\Losc\CucmBundle\Model\Webservice\StructType\GetAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapSyncStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncStatusReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncStatusRes|bool
     */
    public function getLdapSyncStatus(\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncStatusReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapSyncStatus($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSoftKeySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSoftKeySetReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSoftKeySetRes|bool
     */
    public function getSoftKeySet(\\Losc\CucmBundle\Model\Webservice\StructType\GetSoftKeySetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSoftKeySet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSyslogConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSyslogConfigurationReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSyslogConfigurationRes|bool
     */
    public function getSyslogConfiguration(\\Losc\CucmBundle\Model\Webservice\StructType\GetSyslogConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSyslogConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneTypeDisplayInstance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneTypeDisplayInstanceReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneTypeDisplayInstanceRes|bool
     */
    public function getPhoneTypeDisplayInstance(\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneTypeDisplayInstanceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneTypeDisplayInstance($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIlsConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetIlsConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetIlsConfigRes|bool
     */
    public function getIlsConfig(\\Losc\CucmBundle\Model\Webservice\StructType\GetIlsConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getIlsConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSNMPCommunityString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPCommunityStringReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPCommunityStringRes|bool
     */
    public function getSNMPCommunityString(\\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPCommunityStringReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSNMPCommunityString($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSNMPUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPUserReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPUserRes|bool
     */
    public function getSNMPUser(\\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSNMPUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSNMPMIB2List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPMIB2ListReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPMIB2ListRes|bool
     */
    public function getSNMPMIB2List(\\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPMIB2ListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSNMPMIB2List($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetBillingServerReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetBillingServerRes|bool
     */
    public function getBillingServer(\\Losc\CucmBundle\Model\Webservice\StructType\GetBillingServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdFeatureConfigReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCcdFeatureConfigRes|bool
     */
    public function getCcdFeatureConfig(\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPageLayoutPreferences
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetPageLayoutPreferencesReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetPageLayoutPreferencesRes|bool
     */
    public function getPageLayoutPreferences(\\Losc\CucmBundle\Model\Webservice\StructType\GetPageLayoutPreferencesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPageLayoutPreferences($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCredentialPolicyDefault
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GetCredentialPolicyDefaultReq $axlParams
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetCredentialPolicyDefaultRes|bool
     */
    public function getCredentialPolicyDefault(\\Losc\CucmBundle\Model\Webservice\StructType\GetCredentialPolicyDefaultReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCredentialPolicyDefault($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetAarGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetAdvertisedPatternsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetAnnouncementRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetAnnunciatorRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationDialRulesRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationServerRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetApplicationUserCapfProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetAppServerInfoRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetAppUserRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetAudioCodecPreferenceListRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetBillingServerRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetBlockedLearnedPatternsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCalledPartyTransformationPatternRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCallerFilterListRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCallingPartyTransformationPatternRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCallManagerGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCallManagerRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCallParkRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCallPickupGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCCAProfilesRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdAdvertisingServiceRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdFeatureConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdHostedDNGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdHostedDNRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCcdRequestingServiceRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCCMVersionRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000E1VoIPGatewayRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Res|\\Losc\CucmBundle\Model\Webservice\StructType\GetCiscoCatalyst600024PortFXSGatewayRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCmcInfoRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCommonDeviceConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCommonPhoneConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetConferenceBridgeRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCredentialPolicyDefaultRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCredentialPolicyRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCssRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCtiRoutePointRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCumaServerSecurityProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetCustomUserFieldRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDateTimeGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDdiRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDefaultDeviceProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceMobilityGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceMobilityRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDevicePoolRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceProfileOptionsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDeviceProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDhcpServerRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDhcpSubnetRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDialPlanRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDialPlanTagRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDirectedCallParkRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDirectoryLookupDialRulesRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetDirNumberAliasLookupandSyncRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetEmccFeatureConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetEndUserCapfProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetEnterpriseFeatureAccessConfigurationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetEnterprisePhoneConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetExternalCallControlProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetFacInfoRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetFallbackFeatureConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetFallbackProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetFeatureControlPolicyRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetFeatureGroupTemplateRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetFixedMohAudioSourceRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGatekeeperRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointAnalogAccessRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessBriRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessPriRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayEndpointDigitalAccessT1Res|\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewayRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGatewaySccpEndpointsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationFilterRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationPolicyRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetGeoLocationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetH323GatewayRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetH323PhoneRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetH323TrunkRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetHandoffConfigurationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetHuntListRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetHuntPilotRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetIlsConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeClientRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeE164TransformationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeEnrolledPatternGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeEnrolledPatternRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeExclusionNumberGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeExclusionNumberRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeFeatureConfigRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeFirewallRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeLearnedRoutesRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeRouteFilterElementRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeRouteFilterGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImeServerRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetImportedDirectoryUriCatalogsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetInterClusterServiceProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetIpPhoneServicesRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetIvrUserLocaleRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLbmGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLbmHubGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapAuthenticationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapDirectoryRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapFilterRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncCustomFieldRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncStatusRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSystemRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLicensedUserRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLineGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLineOptionsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLineRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLocalRouteGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetLocationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMediaResourceGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMediaResourceListRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMeetMeRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMessageWaitingRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMlppDomainRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMobileSmartClientProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMobileVoiceAccessRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMobilityProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMobilityRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMohAudioSourceRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMohServerRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetMtpRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetNetworkAccessProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetNumDevicesResponse|\\Losc\CucmBundle\Model\Webservice\StructType\GetOSVersionRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPageLayoutPreferencesRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneButtonTemplateRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneNtpRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneOptionsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneSecurityProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPhoneTypeDisplayInstanceRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPhysicalLocationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPresenceGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetPresenceRedundancyGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetProcessNodeRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetProcessNodeServiceRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRecordingProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRegionRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteClusterRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteDestinationProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRemoteDestinationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetResourcePriorityNamespaceListRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetResourcePriorityNamespaceRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRouteFilterRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRouteGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRouteListRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePartitionRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSafCcdPurgeBlockLearnedRoutesRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSafForwarderRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSafSecurityProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSdpTransparencyProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetServiceParameterRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetServiceProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSipDialRulesRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSIPNormalizationScriptRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSipProfileOptionsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSipProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSipRealmRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSipRoutePatternRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSipTrunkRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSipTrunkSecurityProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPCommunityStringRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPMIB2ListRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSNMPUserRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSoftKeySetRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSoftKeyTemplateRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSrstRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetSyslogConfigurationRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetTimePeriodRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetTimeScheduleRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetTodAccessRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetTranscoderRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetTransformationProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetTransPatternOptionsRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetTransPatternRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetUcServiceRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetUniversalDeviceTemplateRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetUniversalLineTemplateRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetUserGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetUserProfileProvisionRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetUserRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetVg224Res|\\Losc\CucmBundle\Model\Webservice\StructType\GetVohServerRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPilotRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailPortRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetVoiceMailProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetVpnGatewayRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetVpnGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetVpnProfileRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetWifiHotspotRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetWlanProfileGroupRes|\\Losc\CucmBundle\Model\Webservice\StructType\GetWLANProfileRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
