<?php

namespace \Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XNetworkLocation EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XNetworkLocation extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OnNet'
     * @return string 'OnNet'
     */
    const VALUE_ON_NET = 'OnNet';
    /**
     * Constant for value 'OffNet'
     * @return string 'OffNet'
     */
    const VALUE_OFF_NET = 'OffNet';
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Return allowed values
     * @uses self::VALUE_ON_NET
     * @uses self::VALUE_OFF_NET
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ON_NET,
            self::VALUE_OFF_NET,
            self::VALUE_USE_SYSTEM_DEFAULT,
        );
    }
}
