<?php

namespace \Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XDNDOption EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XDNDOption extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Ringer Off'
     * @return string 'Ringer Off'
     */
    const VALUE_RINGER_OFF = 'Ringer Off';
    /**
     * Constant for value 'Call Reject'
     * @return string 'Call Reject'
     */
    const VALUE_CALL_REJECT = 'Call Reject';
    /**
     * Constant for value 'Use Common Phone Profile Setting'
     * @return string 'Use Common Phone Profile Setting'
     */
    const VALUE_USE_COMMON_PHONE_PROFILE_SETTING = 'Use Common Phone Profile Setting';
    /**
     * Return allowed values
     * @uses self::VALUE_RINGER_OFF
     * @uses self::VALUE_CALL_REJECT
     * @uses self::VALUE_USE_COMMON_PHONE_PROFILE_SETTING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RINGER_OFF,
            self::VALUE_CALL_REJECT,
            self::VALUE_USE_COMMON_PHONE_PROFILE_SETTING,
        );
    }
}
