<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTimePeriod StructType
 * @subpackage Structs
 */
class XTimePeriod extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The startTime
     * Meta information extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endTime;
    /**
     * The startDay
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startDay;
    /**
     * The endDay
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endDay;
    /**
     * The monthOfYear
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYear;
    /**
     * The dayOfMonth
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonth;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta information extracted from the WSDL
     * - documentation: TimePeriod cannot be published if it has a todOwnerId assigned to it. Only Administrative Time Period can be published.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The todOwnerIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * The dayOfMonthEnd
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonthEnd;
    /**
     * The monthOfYearEnd
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYearEnd;
    /**
     * Constructor method for XTimePeriod
     * @uses XTimePeriod::setName()
     * @uses XTimePeriod::setStartTime()
     * @uses XTimePeriod::setEndTime()
     * @uses XTimePeriod::setStartDay()
     * @uses XTimePeriod::setEndDay()
     * @uses XTimePeriod::setMonthOfYear()
     * @uses XTimePeriod::setDayOfMonth()
     * @uses XTimePeriod::setDescription()
     * @uses XTimePeriod::setIsPublished()
     * @uses XTimePeriod::setTodOwnerIdName()
     * @uses XTimePeriod::setDayOfMonthEnd()
     * @uses XTimePeriod::setMonthOfYearEnd()
     * @param string $name
     * @param string $startTime
     * @param string $endTime
     * @param string $startDay
     * @param string $endDay
     * @param string $monthOfYear
     * @param string $dayOfMonth
     * @param string $description
     * @param string $isPublished
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName
     * @param string $dayOfMonthEnd
     * @param string $monthOfYearEnd
     */
    public function __construct($name = null, $startTime = 'No Office Hours', $endTime = 'No Office Hours', $startDay = 'None', $endDay = 'None', $monthOfYear = 'None', $dayOfMonth = '0', $description = null, $isPublished = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName = null, $dayOfMonthEnd = '0', $monthOfYearEnd = 'None')
    {
        $this
            ->setName($name)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setStartDay($startDay)
            ->setEndDay($endDay)
            ->setMonthOfYear($monthOfYear)
            ->setDayOfMonth($dayOfMonth)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTodOwnerIdName($todOwnerIdName)
            ->setDayOfMonthEnd($dayOfMonthEnd)
            ->setMonthOfYearEnd($monthOfYearEnd);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @param string $startTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setStartTime($startTime = 'No Office Hours')
    {
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @param string $endTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setEndTime($endTime = 'No Office Hours')
    {
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @param string $startDay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setStartDay($startDay = 'None')
    {
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get endDay value
     * @return string|null
     */
    public function getEndDay()
    {
        return $this->endDay;
    }
    /**
     * Set endDay value
     * @param string $endDay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setEndDay($endDay = 'None')
    {
        $this->endDay = $endDay;
        return $this;
    }
    /**
     * Get monthOfYear value
     * @return string|null
     */
    public function getMonthOfYear()
    {
        return $this->monthOfYear;
    }
    /**
     * Set monthOfYear value
     * @param string $monthOfYear
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setMonthOfYear($monthOfYear = 'None')
    {
        $this->monthOfYear = $monthOfYear;
        return $this;
    }
    /**
     * Get dayOfMonth value
     * @return string|null
     */
    public function getDayOfMonth()
    {
        return $this->dayOfMonth;
    }
    /**
     * Set dayOfMonth value
     * @param string $dayOfMonth
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setDayOfMonth($dayOfMonth = '0')
    {
        $this->dayOfMonth = $dayOfMonth;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setIsPublished($isPublished = null)
    {
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return isset($this->todOwnerIdName) ? $this->todOwnerIdName : null;
    }
    /**
     * Set todOwnerIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setTodOwnerIdName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName = null)
    {
        if (is_null($todOwnerIdName) || (is_array($todOwnerIdName) && empty($todOwnerIdName))) {
            unset($this->todOwnerIdName);
        } else {
            $this->todOwnerIdName = $todOwnerIdName;
        }
        return $this;
    }
    /**
     * Get dayOfMonthEnd value
     * @return string|null
     */
    public function getDayOfMonthEnd()
    {
        return $this->dayOfMonthEnd;
    }
    /**
     * Set dayOfMonthEnd value
     * @param string $dayOfMonthEnd
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setDayOfMonthEnd($dayOfMonthEnd = '0')
    {
        $this->dayOfMonthEnd = $dayOfMonthEnd;
        return $this;
    }
    /**
     * Get monthOfYearEnd value
     * @return string|null
     */
    public function getMonthOfYearEnd()
    {
        return $this->monthOfYearEnd;
    }
    /**
     * Set monthOfYearEnd value
     * @param string $monthOfYearEnd
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setMonthOfYearEnd($monthOfYearEnd = 'None')
    {
        $this->monthOfYearEnd = $monthOfYearEnd;
        return $this;
    }
}
