<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XServiceParameter StructType
 * @subpackage Structs
 */
class XServiceParameter extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - documentation: The process Node that this the service parameter belongs to. Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Name of the service parameter. Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - documentation: The service that this service parameter belongs to.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The valueType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $valueType;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $value;
    /**
     * Constructor method for XServiceParameter
     * @uses XServiceParameter::setProcessNodeName()
     * @uses XServiceParameter::setName()
     * @uses XServiceParameter::setService()
     * @uses XServiceParameter::setValueType()
     * @uses XServiceParameter::setValue()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param string $name
     * @param string $service
     * @param string $valueType
     * @param string $value
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, $name = null, $service = null, $valueType = null, $value = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setName($name)
            ->setService($service)
            ->setValueType($valueType)
            ->setValue($value);
    }
    /**
     * Get processNodeName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XServiceParameter
     */
    public function setProcessNodeName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XServiceParameter
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XServiceParameter
     */
    public function setService($service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get valueType value
     * @return string
     */
    public function getValueType()
    {
        return $this->valueType;
    }
    /**
     * Set valueType value
     * @param string $valueType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XServiceParameter
     */
    public function setValueType($valueType = null)
    {
        $this->valueType = $valueType;
        return $this;
    }
    /**
     * Get value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->value) ? $this->value : null;
    }
    /**
     * Set value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XServiceParameter
     */
    public function setValue($value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->value);
        } else {
            $this->value = $value;
        }
        return $this;
    }
}
